/*
 * Decompiled with CFR 0.152.
 */
package convex.net;

import convex.core.Belief;
import convex.core.Result;
import convex.core.data.ACell;
import convex.core.data.AVector;
import convex.core.data.SignedData;
import convex.core.data.prim.CVMLong;
import convex.core.util.Utils;
import convex.net.Connection;
import convex.net.MessageType;

public class Message {
    private final Connection connection;
    private final ACell payload;
    private final MessageType type;

    private Message(Connection peerConnection, MessageType type, ACell payload) {
        this.connection = peerConnection;
        this.type = type;
        this.payload = payload;
    }

    public static Message create(Connection peerConnection, MessageType type, ACell payload) {
        return new Message(peerConnection, type, payload);
    }

    public static Message create(Connection peerConnection, ACell o) {
        return Message.create(peerConnection, MessageType.DATA, o);
    }

    public static Message createData(ACell o) {
        return Message.create(null, MessageType.DATA, o);
    }

    public static Message createBelief(SignedData<Belief> sb) {
        return Message.create(null, MessageType.BELIEF, sb);
    }

    public static Message createChallenge(SignedData<ACell> challenge) {
        return Message.create(null, MessageType.CHALLENGE, challenge);
    }

    public static Message createResponse(SignedData<ACell> response) {
        return Message.create(null, MessageType.RESPONSE, response);
    }

    public static Message createGoodBye(SignedData<ACell> peerKey) {
        return Message.create(null, MessageType.GOODBYE, peerKey);
    }

    public Connection getConnection() {
        return this.connection;
    }

    public Message withConnection(Connection peerConnection) {
        return new Message(peerConnection, this.type, this.payload);
    }

    public <T extends ACell> T getPayload() {
        return (T)this.payload;
    }

    public MessageType getType() {
        return this.type;
    }

    public ACell getErrorCode() {
        Object et = ((AVector)this.payload).get(2);
        return et;
    }

    public String toString() {
        return "#message {:type " + this.getType() + " :payload " + Utils.print(this.payload) + "}";
    }

    public CVMLong getID() {
        switch (this.type) {
            case QUERY: 
            case TRANSACT: {
                return (CVMLong)((AVector)this.payload).get(0);
            }
            case RESULT: {
                return (CVMLong)((Result)this.payload).getID();
            }
            case STATUS: {
                return (CVMLong)this.payload;
            }
        }
        return null;
    }
}

