/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.etch;

import convex.core.store.Stores;
import convex.gui.components.models.StateModel;
import convex.gui.etch.panels.DatabasePanel;
import convex.gui.utils.Toolkit;
import etch.EtchStore;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EtchExplorer
extends JPanel {
    public static final Logger log = LoggerFactory.getLogger(EtchExplorer.class.getName());
    private static JFrame frame;
    public static long maxBlock;
    JPanel panel = new JPanel();
    private static StateModel<EtchStore> etchState;
    DatabasePanel homePanel = new DatabasePanel(this);
    JTabbedPane tabs = new JTabbedPane();
    JPanel mainPanel = new JPanel();

    public static void main(String[] args) {
        Toolkit.init();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    frame = new JFrame();
                    frame.setTitle("Etch Explorer");
                    frame.setIconImage(java.awt.Toolkit.getDefaultToolkit().getImage(EtchExplorer.class.getResource("/images/Convex.png")));
                    frame.setBounds(100, 100, 1024, 768);
                    frame.setDefaultCloseOperation(3);
                    EtchExplorer window = new EtchExplorer();
                    frame.getContentPane().add((Component)window, "Center");
                    frame.pack();
                    frame.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public EtchExplorer() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabs, "Center");
        this.tabs.add("Database", this.homePanel);
    }

    public void switchPanel(String title) {
        int n = this.tabs.getTabCount();
        for (int i = 0; i < n; ++i) {
            if (!this.tabs.getTitleAt(i).contentEquals(title)) continue;
            this.tabs.setSelectedIndex(i);
            return;
        }
        System.err.println("Missing tab: " + title);
    }

    public static Component getFrame() {
        return frame;
    }

    public StateModel<EtchStore> getEtchState() {
        return etchState;
    }

    public EtchStore getStore() {
        return etchState.getValue();
    }

    public void setStore(EtchStore newEtch) {
        EtchStore e = etchState.getValue();
        e.close();
        etchState.setValue(newEtch);
    }

    static {
        maxBlock = 0L;
        etchState = StateModel.create((EtchStore)Stores.getGlobalStore());
    }
}

