/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.Belief;
import convex.core.Block;
import convex.core.BlockResult;
import convex.core.Order;
import convex.core.Result;
import convex.core.State;
import convex.core.data.AArrayBlob;
import convex.core.data.ABlob;
import convex.core.data.ACell;
import convex.core.data.AObject;
import convex.core.data.AccountStatus;
import convex.core.data.Address;
import convex.core.data.Blob;
import convex.core.data.BlobMap;
import convex.core.data.Blobs;
import convex.core.data.Keyword;
import convex.core.data.List;
import convex.core.data.Maps;
import convex.core.data.PeerStatus;
import convex.core.data.Ref;
import convex.core.data.Sets;
import convex.core.data.SignedData;
import convex.core.data.Strings;
import convex.core.data.Symbol;
import convex.core.data.Syntax;
import convex.core.data.Vectors;
import convex.core.data.prim.CVMBool;
import convex.core.data.prim.CVMByte;
import convex.core.data.prim.CVMChar;
import convex.core.data.prim.CVMDouble;
import convex.core.data.prim.CVMLong;
import convex.core.exceptions.BadFormatException;
import convex.core.lang.Core;
import convex.core.lang.Ops;
import convex.core.lang.RT;
import convex.core.lang.impl.Fn;
import convex.core.lang.impl.MultiFn;
import convex.core.transactions.ATransaction;
import convex.core.transactions.Call;
import convex.core.transactions.Invoke;
import convex.core.transactions.Transfer;
import convex.core.util.Utils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;

public class Format {
    public static final int LIMIT_ENCODING_LENGTH = 8191;
    public static final int MAX_VLC_LONG_LENGTH = 10;
    public static final int MAX_EMBEDDED_LENGTH = 140;
    public static final int NULL_ENCODING_LENGTH = 1;
    public static final int MAX_REF_LENGTH = Math.max(33, 140);
    private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    private static final ThreadLocal<CharsetDecoder> UTF8_DECODERS = new ThreadLocal<CharsetDecoder>(){

        @Override
        protected CharsetDecoder initialValue() {
            CharsetDecoder dec = UTF8_CHARSET.newDecoder();
            dec.onUnmappableCharacter(CodingErrorAction.REPORT);
            dec.onMalformedInput(CodingErrorAction.REPORT);
            return dec;
        }
    };
    private static final ThreadLocal<CharsetEncoder> UTF8_ENCODERS = new ThreadLocal<CharsetEncoder>(){

        @Override
        protected CharsetEncoder initialValue() {
            CharsetEncoder dec = UTF8_CHARSET.newEncoder();
            dec.onUnmappableCharacter(CodingErrorAction.REPORT);
            dec.onMalformedInput(CodingErrorAction.REPORT);
            return dec;
        }
    };

    public static int getVLCLength(long x) {
        if (x < 64L && x >= -64L) {
            return 1;
        }
        int bitLength = Utils.bitLength(x);
        int blen = (bitLength + 6) / 7;
        return blen;
    }

    public static ByteBuffer writeVLCLong(ByteBuffer bb, long x) {
        if (x < 64L && x >= -64L) {
            byte single = (byte)(x & 0x7FL);
            return bb.put(single);
        }
        int bitLength = Utils.bitLength(x);
        int blen = (bitLength + 6) / 7;
        for (int i = blen - 1; i >= 1; --i) {
            byte single = (byte)(0x80L | x >> 7 * i);
            bb = bb.put(single);
        }
        byte end = (byte)(x & 0x7FL);
        return bb.put(end);
    }

    public static int writeVLCLong(byte[] bs, int pos, long x) {
        if (x < 64L && x >= -64L) {
            byte single = (byte)(x & 0x7FL);
            bs[pos++] = single;
            return pos;
        }
        int bitLength = Utils.bitLength(x);
        int blen = (bitLength + 6) / 7;
        for (int i = blen - 1; i >= 1; --i) {
            byte single = (byte)(0x80L | x >> 7 * i);
            bs[pos++] = single;
        }
        byte end = (byte)(x & 0x7FL);
        bs[pos++] = end;
        return pos;
    }

    public static long readVLCLong(ByteBuffer bb) throws BadFormatException {
        boolean signOnly;
        byte octet = bb.get();
        long result = Format.vlcSignExtend(octet);
        int bitsRead = 7;
        int sevenBits = octet & 0x7F;
        boolean bl = signOnly = sevenBits == 0 || sevenBits == 127;
        while ((octet & 0x80) != 0) {
            if (bitsRead > 64) {
                throw new BadFormatException("VLC long encoding too long for long value");
            }
            octet = bb.get();
            sevenBits = octet & 0x7F;
            if (signOnly && bitsRead == 7) {
                boolean resultSignBit;
                boolean signBit = (sevenBits & 0x40) != 0;
                boolean bl2 = resultSignBit = result < 0L;
                if (signBit == resultSignBit) {
                    throw new BadFormatException("VLC long encoding not canonical, excess leading sign byte(s)");
                }
            }
            result = result << 7 | (long)sevenBits;
            bitsRead += 7;
        }
        if (bitsRead > 63 && !signOnly) {
            throw new BadFormatException("VLC long encoding not canonical, non-sign information beyond 63 bits read");
        }
        return result;
    }

    public static long vlcSignExtend(byte b) {
        return (long)b << 57 >> 57;
    }

    public static long readVLCLong(byte[] data, int pos) throws BadFormatException {
        byte octet = data[pos++];
        long result = (long)octet << 57 >> 57;
        int bits = 7;
        while ((octet & 0x80) != 0) {
            if (pos >= data.length) {
                throw new BadFormatException("VLC encoding beyong end of array");
            }
            if (bits > 64) {
                throw new BadFormatException("VLC encoding too long for long value");
            }
            octet = data[pos++];
            result = result << 7 | (long)(octet & 0x7F);
            bits += 7;
        }
        return result;
    }

    public static int peekMessageLength(ByteBuffer bb) throws BadFormatException {
        int len = bb.get(0);
        if (len == 0) {
            throw new BadFormatException("Format.peekMessageLength: Zero message length:" + Utils.readBufferData(bb));
        }
        if ((len & 0x40) != 0) {
            String hex = Utils.toHexString((byte)len);
            throw new BadFormatException("Format.peekMessageLength: Expected positive message length, got first byte [" + hex + "]");
        }
        if ((len & 0x80) == 0) {
            return len & 0x3F;
        }
        byte lsb = bb.get(1);
        if ((lsb & 0x80) != 0) {
            String hex = Utils.toHexString((byte)len) + Utils.toHexString(lsb);
            throw new BadFormatException("Format.peekMessageLength: Max 2 bytes allowed in VLC encoded message length, got [" + hex + "]");
        }
        len = ((len & 0x3F) << 7) + lsb;
        return len;
    }

    public static ByteBuffer writeMessageLength(ByteBuffer bb, int len) {
        if (len <= 0 || len > 8191) {
            throw new IllegalArgumentException("Invalid message length: " + len);
        }
        return Format.writeVLCLong(bb, len);
    }

    public static ByteBuffer writeVLCBigInteger(ByteBuffer bb, BigInteger value) {
        int bitLength = value.bitLength() + 1;
        if (bitLength <= 64) {
            return Format.writeVLCLong(bb, value.longValue());
        }
        byte[] bs = value.toByteArray();
        int bslen = bs.length;
        int blen = (bitLength + 6) / 7;
        for (int i = blen - 1; i >= 1; --i) {
            int bits7 = Utils.extractBits(bs, 7, i * 7);
            byte single = (byte)(0x80 | bits7);
            bb = bb.put(single);
        }
        byte end = (byte)(bs[bslen - 1] & 0x7F);
        return bb.put(end);
    }

    private static int findVLCTerminal(ByteBuffer bb) {
        int pos = bb.position();
        int len = bb.remaining();
        for (int i = 0; i < len; ++i) {
            byte x = bb.get(pos + i);
            if ((x & 0x80) != 0) continue;
            return i;
        }
        return -1;
    }

    public static BigInteger readVLCBigInteger(ByteBuffer bb) throws BadFormatException {
        int vlclen = Format.findVLCTerminal(bb) + 1;
        if (vlclen == 0) {
            throw new BadFormatException("No terminal byte found for VLC encoding of BigInteger");
        }
        byte[] vlc = new byte[vlclen];
        bb.get(vlc);
        assert ((vlc[vlclen - 1] & 0x80) == 0);
        int blen = (vlclen * 7 + 7) / 8;
        byte[] bs = new byte[blen];
        boolean signBit = (vlc[0] & 0x40) != 0;
        boolean signOnly = vlc[0] == -1 | vlc[0] == -128;
        bs[0] = (byte)(signBit ? -1 : 0);
        for (int i = 0; i < vlclen; ++i) {
            byte bits7 = (byte)(vlc[i] & 0x7F);
            if (signOnly && i == 1) {
                boolean thisSign;
                boolean bl = thisSign = (bits7 & 0x40) != 0;
                if (thisSign == signBit) {
                    throw new BadFormatException("Non-canonical BigInteger with VLC bytes " + Blob.wrap(vlc));
                }
            }
            Utils.setBits(bs, 7, 7 * (vlclen - 1 - i), bits7);
        }
        return new BigInteger(bs);
    }

    public static ByteBuffer write(ByteBuffer bb, ACell cell) {
        if (cell == null) {
            return bb.put((byte)0);
        }
        return cell.write(bb);
    }

    public static int write(byte[] bs, int pos, ACell cell) {
        if (cell == null) {
            bs[pos++] = 0;
            return pos;
        }
        return cell.encode(bs, pos);
    }

    public static ByteBuffer writeVLCBigDecimal(ByteBuffer bb, BigDecimal value) {
        bb = bb.put((byte)value.scale());
        bb = Format.writeVLCBigInteger(bb, value.unscaledValue());
        return bb;
    }

    public static BigDecimal readVLCBigDecimal(ByteBuffer bb) throws BadFormatException {
        byte scale = bb.get();
        BigInteger value = Format.readVLCBigInteger(bb);
        return new BigDecimal(value, scale);
    }

    public static ByteBuffer writeUTF8String(ByteBuffer bb, String s) {
        bb = bb.put((byte)48);
        return Format.writeRawUTF8String(bb, s);
    }

    public static ByteBuffer writeRawUTF8String(ByteBuffer bb, String s) {
        if (s.length() == 0) {
            bb = Format.writeLength(bb, 0);
        } else {
            byte[] bs = Utils.toByteArray(s);
            bb = Format.writeLength(bb, bs.length);
            bb = bb.put(bs);
        }
        return bb;
    }

    public static int writeRawUTF8String(byte[] bs, int pos, String s) {
        if (s.length() == 0) {
            return Format.writeVLCLong(bs, pos, 0L);
        }
        byte[] sBytes = Utils.toByteArray(s);
        int n = sBytes.length;
        pos = Format.writeVLCLong(bs, pos, sBytes.length);
        System.arraycopy(sBytes, 0, bs, pos, n);
        return pos + n;
    }

    public static String readUTF8String(ByteBuffer bb) throws BadFormatException {
        try {
            int len = Format.readLength(bb);
            if (len == 0) {
                return "";
            }
            byte[] bs = new byte[len];
            bb.get(bs);
            String s = UTF8_DECODERS.get().decode(ByteBuffer.wrap(bs)).toString();
            return s;
        }
        catch (BufferUnderflowException e) {
            throw new BadFormatException("Buffer underflow", e);
        }
        catch (CharacterCodingException e) {
            throw new BadFormatException("Bad UTF-8 format", e);
        }
    }

    public static Symbol readSymbol(ByteBuffer bb) throws BadFormatException {
        return Symbol.read(bb);
    }

    public static ByteBuffer writeLength(ByteBuffer bb, int i) {
        bb = Format.writeVLCLong(bb, i);
        return bb;
    }

    public static int readLength(ByteBuffer bb) throws BadFormatException {
        int li;
        long l = Format.readVLCLong(bb);
        if (l != (long)(li = (int)l)) {
            throw new BadFormatException("Bad length, out of integer range: " + l);
        }
        if (li < 0) {
            throw new BadFormatException("Negative length: " + li);
        }
        return li;
    }

    public static ByteBuffer writeLong(ByteBuffer bb, long value) {
        return bb.putLong(value);
    }

    public static long readLong(ByteBuffer bb) {
        return bb.getLong();
    }

    public static <T extends ACell> Ref<T> readRef(ByteBuffer bb) throws BadFormatException {
        byte tag = bb.get();
        if (tag == 32) {
            return Ref.readRaw(bb);
        }
        T cell = Format.read(tag, bb);
        if (cell == null) {
            return Ref.NULL_VALUE;
        }
        return ((ACell)cell).getRef();
    }

    private static <T extends ACell> T readDataStructure(ByteBuffer bb, byte tag) throws BadFormatException {
        if (tag == -128) {
            return (T)Vectors.read(bb);
        }
        if (tag == -126) {
            return (T)Maps.read(bb);
        }
        if (tag == -120) {
            return (T)Syntax.read(bb);
        }
        if (tag == -125) {
            return (T)Sets.read(bb);
        }
        if (tag == -127) {
            return (T)List.read(bb);
        }
        if (tag == -124) {
            return (T)BlobMap.read(bb);
        }
        throw new BadFormatException("Can't read data structure with tag byte: " + tag);
    }

    private static ACell readCode(ByteBuffer bb, byte tag) throws BadFormatException {
        if (tag == -52) {
            return Ops.read(bb);
        }
        if (tag == -51) {
            Symbol sym = Symbol.read(bb);
            Object o = Core.ENVIRONMENT.get(sym);
            if (o == null) {
                throw new BadFormatException("Core definition not found [" + sym + "]");
            }
            return o;
        }
        if (tag == -53) {
            MultiFn fn = MultiFn.read(bb);
            return fn;
        }
        if (tag == -49) {
            Fn fn = Fn.read(bb);
            return fn;
        }
        throw new BadFormatException("Can't read Op with tag byte: " + Utils.toHexString(tag));
    }

    public static <T extends ACell> T read(Blob blob) throws BadFormatException {
        byte tag = blob.byteAt(0L);
        return Format.read(tag, blob);
    }

    public static <T extends ACell> T read(byte tag, Blob blob) throws BadFormatException {
        T result;
        if (tag == 0) {
            long len = blob.count();
            if (len != 1L) {
                throw new BadFormatException("Bad null encoding with length" + len);
            }
            return null;
        }
        if (tag == 49) {
            return Blobs.readFromBlob(blob);
        }
        ByteBuffer bb = blob.getByteBuffer().position(1);
        try {
            result = Format.read(tag, bb);
            if (bb.hasRemaining()) {
                throw new BadFormatException("Blob with type " + Utils.getClass(result) + " has excess bytes: " + bb.remaining());
            }
        }
        catch (BufferUnderflowException e) {
            throw new BadFormatException("Blob has insufficients bytes: " + blob.count(), e);
        }
        ((AObject)result).attachEncoding(blob);
        return result;
    }

    public static <T extends ACell> T read(String hexString) throws BadFormatException {
        return Format.read(Blob.fromHex(hexString));
    }

    private static <T extends ACell> T readBasicType(ByteBuffer bb, byte tag) throws BadFormatException, BufferUnderflowException {
        try {
            if (tag == 0) {
                return null;
            }
            if (tag == 1) {
                return (T)CVMByte.create(bb.get());
            }
            if (tag == 12) {
                return (T)CVMChar.create(bb.getChar());
            }
            if (tag == 9) {
                return (T)CVMLong.create(Format.readVLCLong(bb));
            }
            if (tag == 13) {
                return (T)CVMDouble.create(bb.getDouble());
            }
            throw new BadFormatException("Can't read basic type with tag byte: " + tag);
        }
        catch (IllegalArgumentException e) {
            throw new BadFormatException("Format error basic type with tag byte: " + tag);
        }
    }

    private static <T extends ACell> T readRecord(ByteBuffer bb, byte tag) throws BadFormatException {
        if (tag == -85) {
            return (T)Block.read(bb);
        }
        if (tag == -96) {
            return (T)State.read(bb);
        }
        if (tag == -84) {
            return (T)Order.read(bb);
        }
        if (tag == -86) {
            return (T)Belief.read(bb);
        }
        if (tag == -83) {
            return (T)Result.read(bb);
        }
        if (tag == -82) {
            return (T)BlockResult.read(bb);
        }
        throw new BadFormatException("Can't read record type with tag byte: " + tag);
    }

    public static <T extends ACell> T read(ByteBuffer bb) throws BadFormatException {
        byte tag = bb.get();
        return Format.read(tag, bb);
    }

    static <T extends ACell> T read(byte tag, ByteBuffer bb) throws BadFormatException {
        try {
            if ((tag & 0xF0) == 0) {
                return Format.readBasicType(bb, tag);
            }
            if (tag == 48) {
                return (T)Strings.read(bb);
            }
            if (tag == 49) {
                return (T)Blobs.read(bb);
            }
            if (tag == 50) {
                return (T)Format.readSymbol(bb);
            }
            if (tag == 51) {
                return (T)Keyword.read(bb);
            }
            if (tag == -79) {
                return (T)CVMBool.TRUE;
            }
            if (tag == -80) {
                return (T)CVMBool.FALSE;
            }
            if (tag == 33) {
                return (T)Address.readRaw(bb);
            }
            if (tag == -112) {
                return (T)SignedData.read(bb);
            }
            if ((tag & 0xF0) == 128) {
                return Format.readDataStructure(bb, tag);
            }
            if ((tag & 0xF0) == 160) {
                return Format.readRecord(bb, tag);
            }
            if ((tag & 0xF0) == 208) {
                return (T)Format.readTransaction(bb, tag);
            }
            if (tag == -62) {
                return (T)PeerStatus.read(bb);
            }
            if (tag == -63) {
                return (T)AccountStatus.read(bb);
            }
            if ((tag & 0xF0) == 192) {
                return (T)Format.readCode(bb, tag);
            }
        }
        catch (IllegalArgumentException e) {
            throw new BadFormatException("Illegal argument reading encoding", e);
        }
        catch (ClassCastException e) {
            throw new BadFormatException("Unexpected data type when decoding: " + e.getMessage(), e);
        }
        int pos = bb.position() - 1;
        bb.position(0);
        AArrayBlob data = Utils.readBufferData(bb);
        throw new BadFormatException("Don't recognise tag: " + Utils.toHexString(tag) + " at position " + pos + " Content: " + ((ABlob)data).toHexString());
    }

    static ATransaction readTransaction(ByteBuffer bb, byte tag) throws BadFormatException {
        if (tag == -48) {
            return Invoke.read(bb);
        }
        if (tag == -47) {
            return Transfer.read(bb);
        }
        if (tag == -46) {
            return Call.read(bb);
        }
        throw new BadFormatException("Can't read Transaction with tag " + Utils.toHexString(tag));
    }

    public static boolean isCanonical(ACell o) {
        if (o == null) {
            return true;
        }
        return o.isCanonical();
    }

    public static boolean isEmbedded(ACell cell) {
        if (cell == null) {
            return true;
        }
        return cell.isEmbedded();
    }

    public static Blob encodedBlob(ACell o) {
        if (o == null) {
            return Blob.NULL_ENCODING;
        }
        return o.getEncoding();
    }

    public static ByteBuffer encodedBuffer(ACell cell) {
        if (cell == null) {
            return ByteBuffer.wrap(new byte[]{0}).flip();
        }
        ABlob b = cell.cachedEncoding();
        if (b != null) {
            return b.getByteBuffer();
        }
        int initialLength = cell.estimatedEncodingSize();
        ByteBuffer bb = ByteBuffer.allocate(initialLength);
        boolean done = false;
        while (!done) {
            try {
                bb = cell.write(bb);
                done = true;
            }
            catch (BufferOverflowException be) {
                bb = ByteBuffer.allocate(bb.capacity() * 2 + 10);
            }
        }
        bb.flip();
        return bb;
    }

    static ByteBuffer writeHexDigits(ByteBuffer bb, ABlob src, long start, long length) {
        bb = Format.writeVLCLong(bb, start);
        bb = Format.writeVLCLong(bb, length);
        int nBytes = Utils.checkedInt(length + 1L >> 1);
        byte[] bs = new byte[nBytes];
        int i = 0;
        while ((long)i < length) {
            Utils.setBits(bs, 4, 4 * (nBytes * 2 - i - 1), src.getHexDigit(start + (long)i));
            ++i;
        }
        bb = bb.put(bs);
        return bb;
    }

    public static int writeHexDigits(byte[] bs, int pos, ABlob src, long start, long length) {
        pos = Format.writeVLCLong(bs, pos, start);
        pos = Format.writeVLCLong(bs, pos, length);
        int nBytes = Utils.checkedInt(length + 1L >> 1);
        byte[] bs2 = new byte[nBytes];
        for (int i = 0; i < nBytes; ++i) {
            long ix = start + (long)(i * 2);
            int d0 = src.getHexDigit(ix);
            int d1 = (long)(i * 2 + 1) < length ? src.getHexDigit(ix + 1L) : 0;
            bs2[i] = (byte)(d0 << 4 | d1 & 0xF);
        }
        System.arraycopy(bs2, 0, bs, pos, nBytes);
        return pos + nBytes;
    }

    public static byte[] readHexDigits(ByteBuffer bb, long start, long length) throws BadFormatException {
        int nBytes = Utils.checkedInt(length + 1L >> 1);
        byte[] bs = new byte[nBytes];
        bb.get(bs);
        if (length < (long)(nBytes * 2) && Utils.extractBits(bs, 4, 0) != 0) {
            throw new BadFormatException("Bytes for " + length + " hex digits: " + Utils.toHexString(bs));
        }
        int rBytes = Utils.checkedInt(start + length + 1L >> 1);
        byte[] rs = new byte[rBytes];
        int i = 0;
        while ((long)i < length) {
            int digit = Utils.extractBits(bs, 4, 4 * (nBytes * 2 - i - 1));
            int di = Utils.checkedInt(4L * ((long)(rBytes * 2) - (start + (long)i) - 1L));
            Utils.setBits(rs, 4, di, digit);
            ++i;
        }
        return rs;
    }

    public static String encodedString(ACell cell) {
        return Format.encodedBlob(cell).toHexString();
    }

    public static String encodedString(Object o) {
        return Format.encodedString(RT.cvm(o));
    }

    public static int estimateSize(ACell cell) {
        if (cell == null) {
            return 1;
        }
        return cell.estimatedEncodingSize();
    }

    static boolean canEncodeUFT8(CharSequence s) {
        return UTF8_ENCODERS.get().canEncode(s);
    }
}

