/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.AArrayBlob;
import convex.core.data.ABlob;
import convex.core.data.ACell;
import convex.core.data.Blob;
import convex.core.data.Blobs;
import convex.core.data.Format;
import convex.core.data.IRefFunction;
import convex.core.data.Ref;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import convex.core.util.Errors;
import convex.core.util.Utils;
import java.nio.ByteBuffer;
import java.security.MessageDigest;

public class BlobTree
extends ABlob {
    public static final int BIT_SHIFT_PER_LEVEL = 4;
    public static final int FANOUT = 16;
    private final Ref<ABlob>[] children;
    private final int shift;
    private final long count;
    public static final int MAX_ENCODING_LENGTH = 11 + 16 * Format.MAX_REF_LENGTH;

    private BlobTree(Ref<ABlob>[] children, int shift, long count) {
        this.children = children;
        this.shift = shift;
        this.count = count;
    }

    public static BlobTree create(ABlob blob) {
        if (blob instanceof BlobTree) {
            return (BlobTree)blob;
        }
        long length = blob.count();
        int chunks = Utils.checkedInt(BlobTree.calcChunks(length));
        Blob[] blobs = new Blob[chunks];
        for (int i = 0; i < chunks; ++i) {
            int offset = i * 4096;
            blobs[i] = blob.slice(offset, Math.min(4096L, length - (long)offset)).toBlob();
        }
        return BlobTree.create(blobs);
    }

    static BlobTree create(Blob ... blobs) {
        return BlobTree.create(blobs, 0, blobs.length);
    }

    static int calcShift(long chunkCount) {
        int shift = 0;
        while (chunkCount > 16L) {
            shift += 4;
            chunkCount >>= 4;
        }
        return shift;
    }

    public static long calcChunks(long length) {
        return (length - 1L >> 12) + 1L;
    }

    private static BlobTree createSmall(Blob[] blobs, int offset, int chunkCount) {
        long length = 0L;
        if (chunkCount < 2) {
            throw new IllegalArgumentException("Cannot create BlobTree without at least 2 Blobs");
        }
        Ref[] children = new Ref[chunkCount];
        for (int i = 0; i < chunkCount; ++i) {
            Ref child;
            Blob blob = blobs[offset + i];
            long childLength = blob.count();
            if (childLength > 4096L) {
                throw new IllegalArgumentException("BlobTree chunk too large: " + childLength);
            }
            if (i < chunkCount - 1 && childLength != 4096L) {
                throw new IllegalArgumentException("Illegal internediate chunk size: " + childLength);
            }
            children[i] = child = blob.getRef();
            length += childLength;
        }
        return new BlobTree(children, 0, length);
    }

    private static BlobTree create(Blob[] blobs, int offset, int chunkCount) {
        int shift = BlobTree.calcShift(chunkCount);
        if (shift == 0) {
            return BlobTree.createSmall(blobs, offset, chunkCount);
        }
        int childSize = 1 << shift;
        int numChildren = (chunkCount - 1 >> shift) + 1;
        Ref[] children = new Ref[numChildren];
        long length = 0L;
        for (int i = 0; i < numChildren; ++i) {
            int childOffset = i * childSize;
            BlobTree bt = BlobTree.create(blobs, offset + childOffset, Math.min(childSize, chunkCount - childOffset));
            children[i] = bt.getRef();
            length += bt.count;
        }
        return new BlobTree(children, shift, length);
    }

    @Override
    public boolean isCanonical() {
        return this.count > 4096L;
    }

    @Override
    public final boolean isCVMValue() {
        return true;
    }

    @Override
    public void getBytes(byte[] dest, int destOffset) {
        long clen = this.childLength();
        int n = this.children.length;
        for (int i = 0; i < n; ++i) {
            this.getChild(i).getBytes(dest, Utils.checkedInt((long)destOffset + (long)i * clen));
        }
    }

    @Override
    public long count() {
        return this.count;
    }

    @Override
    public ABlob slice(long start, long length) {
        if (start == 0L && length == this.count) {
            return this;
        }
        if (start < 0L) {
            throw new IndexOutOfBoundsException(Errors.badIndex(start));
        }
        long csize = this.childLength();
        int ci = (int)(start / csize);
        if ((long)ci == (start + length - 1L) / csize) {
            return this.getChild(ci).slice(start - (long)ci * csize, length);
        }
        int alen = Utils.checkedInt(this.count);
        byte[] bs = new byte[alen];
        return Blob.wrap(bs, Utils.checkedInt(start), Utils.checkedInt(length));
    }

    private ABlob getChild(int childIndex) {
        return this.children[childIndex].getValue();
    }

    @Override
    public Blob toBlob() {
        int len = Utils.checkedInt(this.count());
        byte[] data = new byte[len];
        this.getBytes(data, 0);
        return Blob.wrap(data);
    }

    @Override
    protected void updateDigest(MessageDigest digest) {
        int n = this.children.length;
        for (int i = 0; i < n; ++i) {
            this.getChild(i).updateDigest(digest);
        }
    }

    @Override
    public byte getUnchecked(long i) {
        int childLength = this.childLength();
        int ci = (int)(i >> this.shift + 12);
        return this.getChild(ci).getUnchecked(i - (long)(ci * childLength));
    }

    private int childLength() {
        return 1 << this.shift + 12;
    }

    @Override
    public boolean equals(ABlob a) {
        if (!(a instanceof BlobTree)) {
            return false;
        }
        return this.equals((BlobTree)a);
    }

    public boolean equals(BlobTree b) {
        if (b == this) {
            return true;
        }
        if (b.count != this.count) {
            return false;
        }
        int n = this.children.length;
        for (int i = 0; i < n; ++i) {
            if (this.children[i].equals(b.children[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equalsBytes(byte[] bytes, int byteOffset) {
        int clen = this.childLength();
        for (int i = 0; i < this.children.length; ++i) {
            if (this.getChild(i).equalsBytes(bytes, byteOffset + i * clen)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equalsBytes(ABlob b) {
        if (b.count() != this.count) {
            return false;
        }
        if (b instanceof BlobTree) {
            BlobTree bb = (BlobTree)b;
            for (int i = 0; i < this.children.length; ++i) {
                if (this.getChild(i).equalsBytes(bb.getChild(i))) continue;
                return false;
            }
            return true;
        }
        if (b instanceof AArrayBlob) {
            AArrayBlob ab = (AArrayBlob)b;
            return this.equalsBytes(ab.getInternalArray(), ab.getInternalOffset());
        }
        throw new UnsupportedOperationException("Shouldn't be possible?");
    }

    @Override
    public int encode(byte[] bs, int pos) {
        bs[pos++] = 49;
        return this.encodeRaw(bs, pos);
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        pos = Format.writeVLCLong(bs, pos, this.count);
        int n = this.children.length;
        for (int i = 0; i < n; ++i) {
            pos = this.children[i].encode(bs, pos);
        }
        return pos;
    }

    @Override
    public ByteBuffer writeToBuffer(ByteBuffer bb) {
        int n = this.children.length;
        for (int i = 0; i < n; ++i) {
            bb = this.children[i].write(bb);
        }
        return bb;
    }

    @Override
    public int writeToBuffer(byte[] bs, int pos) {
        int n = this.children.length;
        for (int i = 0; i < n; ++i) {
            pos = this.children[i].getValue().writeToBuffer(bs, pos);
        }
        return pos;
    }

    public static BlobTree read(ByteBuffer bb, long count) throws BadFormatException {
        int shift;
        if (count < 0L) {
            throw new BadFormatException("Negative length: " + count);
        }
        long chunks = BlobTree.calcChunks(count);
        int numChildren = Utils.checkedInt((chunks - 1L >> (shift = BlobTree.calcShift(chunks))) + 1L);
        if (numChildren < 2 || numChildren > 16) {
            throw new BadFormatException("Invalid number of children [" + numChildren + "] for BlobTree with length: " + count);
        }
        Ref[] children = new Ref[numChildren];
        for (int i = 0; i < numChildren; ++i) {
            Ref ref;
            children[i] = ref = Format.readRef(bb);
        }
        return new BlobTree(children, shift, count);
    }

    public static BlobTree read(Blob src, long count) throws BadFormatException {
        int headerLength = 1 + Format.getVLCLength(count);
        long chunks = BlobTree.calcChunks(count);
        int shift = BlobTree.calcShift(chunks);
        int numChildren = Utils.checkedInt((chunks - 1L >> shift) + 1L);
        Ref[] children = new Ref[numChildren];
        ByteBuffer bb = src.getByteBuffer();
        bb.position(headerLength);
        for (int i = 0; i < numChildren; ++i) {
            Ref ref;
            children[i] = ref = Format.readRef(bb);
        }
        return new BlobTree(children, shift, count);
    }

    @Override
    public int estimatedEncodingSize() {
        return 11 + 33 * this.children.length;
    }

    @Override
    public ABlob append(ABlob d) {
        return this.toBlob().append(d);
    }

    @Override
    public Blob getChunk(long chunkIndex) {
        long childSize = 1 << this.shift;
        int child = Utils.checkedInt(chunkIndex >> this.shift);
        return this.getChild(child).getChunk(chunkIndex - (long)child * childSize);
    }

    @Override
    public void validate() throws InvalidDataException {
        super.validate();
        int n = this.children.length;
        if (n < 2 | n > 16) {
            throw new InvalidDataException("Illegal number of BlobTree children: " + n, this);
        }
        int clen = this.childLength();
        long total = 0L;
        for (int i = 0; i < n; ++i) {
            ABlob child = this.getChild(i);
            child.validate();
            long cl = child.count();
            total += cl;
            if (i == n - 1) {
                if (cl <= (long)clen) continue;
                throw new InvalidDataException("Illegal last child length: " + cl + " expected less than or equal to " + clen, this);
            }
            if (cl == (long)clen) continue;
            throw new InvalidDataException("Illegal child length: " + cl + " expected " + clen, this);
        }
        if (total != this.count) {
            throw new InvalidDataException("Incorrect total child count: " + total, this);
        }
    }

    @Override
    public ByteBuffer getByteBuffer() {
        throw new UnsupportedOperationException("Can't get bytebuffer for " + this.getClass());
    }

    @Override
    public String toHexString() {
        StringBuilder sb = new StringBuilder();
        this.toHexString(sb);
        return sb.toString();
    }

    @Override
    public void toHexString(StringBuilder sb) {
        for (int i = 0; i < this.children.length; ++i) {
            this.children[i].getValue().toHexString(sb);
        }
    }

    @Override
    public void validateCell() throws InvalidDataException {
        int n = this.children.length;
        if (n < 2 | n > 16) {
            throw new InvalidDataException("Illegal number of BlobTree children: " + n, this);
        }
    }

    @Override
    public long commonHexPrefixLength(ABlob b) {
        long cpl = 0L;
        long DIGITS_PER_CHUNK = 8192L;
        long i = 0L;
        long cl;
        while ((cl = this.getChunk(i).commonHexPrefixLength(b.getChunk(i))) >= DIGITS_PER_CHUNK) {
            cpl += DIGITS_PER_CHUNK;
            ++i;
        }
        return cpl + cl;
    }

    @Override
    public long hexMatchLength(ABlob b, long start, long length) {
        long HEX_CHUNK_LENGTH = 8192L;
        long end = start + length;
        long endChunk = (end - 1L) / HEX_CHUNK_LENGTH;
        for (long ci = start / HEX_CHUNK_LENGTH; ci < endChunk; ++ci) {
            long cpos = ci * HEX_CHUNK_LENGTH;
            long cs = Math.max(0L, start - cpos);
            long ce = Math.min(HEX_CHUNK_LENGTH, end - cpos);
            long clen = ce - cs;
            long match = this.getChunk(ci).hexMatchLength(b.getChunk(ci), cs, clen);
            if (match >= clen) continue;
            return cpos + cs + match;
        }
        return length;
    }

    @Override
    public long longValue() {
        if (this.count != 8L) {
            throw new IllegalStateException(Errors.wrongLength(8L, this.count));
        }
        return this.getChunk(0L).longValue();
    }

    @Override
    public long toLong() {
        return this.slice(this.count - 8L, 8L).toLong();
    }

    @Override
    public int getRefCount() {
        return this.children.length;
    }

    @Override
    public <R extends ACell> Ref<R> getRef(int i) {
        return this.children[i];
    }

    @Override
    public BlobTree updateRefs(IRefFunction func) {
        Ref<ABlob>[] newChildren = Ref.updateRefs(this.children, func);
        return this.withChildren(newChildren);
    }

    private BlobTree withChildren(Ref<ABlob>[] newChildren) {
        if (this.children == newChildren) {
            return this;
        }
        return new BlobTree(newChildren, this.shift, this.count);
    }

    @Override
    public boolean isRegularBlob() {
        return true;
    }

    @Override
    public byte getTag() {
        return 49;
    }

    @Override
    public ABlob toCanonical() {
        if (this.isCanonical()) {
            return this;
        }
        return Blobs.toCanonical(this);
    }
}

