/*
 * Decompiled with CFR 0.152.
 */
package convex.core;

import convex.core.data.ACell;
import convex.core.data.AMap;
import convex.core.data.ARecord;
import convex.core.data.AVector;
import convex.core.data.AccountKey;
import convex.core.data.Format;
import convex.core.data.Hash;
import convex.core.data.Keyword;
import convex.core.data.Keywords;
import convex.core.data.SignedData;
import convex.core.data.Vectors;
import convex.core.data.prim.CVMLong;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import convex.core.lang.RT;
import convex.core.lang.impl.RecordFormat;
import convex.core.transactions.ATransaction;
import convex.core.util.Utils;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.List;

public final class Block
extends ARecord {
    private final long timestamp;
    private final AVector<SignedData<ATransaction>> transactions;
    private final AccountKey peerKey;
    private static final Keyword[] BLOCK_KEYS = new Keyword[]{Keywords.TIMESTAMP, Keywords.TRANSACTIONS, Keywords.PEER};
    private static final RecordFormat FORMAT = RecordFormat.of(BLOCK_KEYS);
    static final Comparator<Block> TIMESTAMP_COMPARATOR = new Comparator<Block>(){

        @Override
        public int compare(Block a, Block b) {
            int sig = Long.compare(a.getTimeStamp(), b.getTimeStamp());
            return sig;
        }
    };

    private Block(long timestamp, AVector<SignedData<ATransaction>> transactions, AccountKey peer) {
        super(FORMAT);
        this.timestamp = timestamp;
        this.transactions = transactions;
        this.peerKey = peer;
        if (this.peerKey == null) {
            throw new Error("Trying to construct block with null peer key");
        }
    }

    @Override
    public ACell get(ACell k) {
        if (Keywords.TIMESTAMP.equals(k)) {
            return CVMLong.create(this.timestamp);
        }
        if (Keywords.TRANSACTIONS.equals(k)) {
            return this.transactions;
        }
        if (Keywords.PEER.equals(k)) {
            return this.peerKey;
        }
        return null;
    }

    @Override
    protected Block updateAll(ACell[] newVals) {
        long newTimestamp = RT.ensureLong(newVals[0]).longValue();
        AVector newTransactions = (AVector)newVals[1];
        AccountKey newPeer = (AccountKey)newVals[2];
        if (this.transactions == newTransactions && this.timestamp == newTimestamp && this.peerKey == newPeer) {
            return this;
        }
        return new Block(newTimestamp, newTransactions, newPeer);
    }

    public long getTimeStamp() {
        return this.timestamp;
    }

    public AccountKey getPeer() {
        return this.peerKey;
    }

    public static Block create(long timestamp, List<SignedData<ATransaction>> transactions, AccountKey peerKey) {
        return new Block(timestamp, Vectors.create(transactions), peerKey);
    }

    public static Block create(long timestamp, AccountKey peerKey, AVector<SignedData<ATransaction>> transactions) {
        return new Block(timestamp, transactions, peerKey);
    }

    @SafeVarargs
    public static Block of(long timestamp, AccountKey peerKey, SignedData<ATransaction> ... transactions) {
        return new Block(timestamp, Vectors.of(transactions), peerKey);
    }

    public int length() {
        return Utils.checkedInt(this.transactions.count());
    }

    @Override
    public int encode(byte[] bs, int pos) {
        bs[pos++] = this.getTag();
        return this.encodeRaw(bs, pos);
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        pos = Utils.writeLong(bs, pos, this.timestamp);
        pos = this.transactions.encode(bs, pos);
        pos = this.peerKey.writeToBuffer(bs, pos);
        return pos;
    }

    @Override
    public int estimatedEncodingSize() {
        return 10 + this.transactions.estimatedEncodingSize() + 32;
    }

    public static Block read(ByteBuffer bb) throws BadFormatException {
        long timestamp = Format.readLong(bb);
        try {
            AVector transactions = (AVector)Format.read(bb);
            if (transactions == null) {
                throw new BadFormatException("Null transactions");
            }
            AccountKey peer = AccountKey.readRaw(bb);
            if (peer == null) {
                throw new BadFormatException("Bad peer key in Block");
            }
            return Block.create(timestamp, peer, transactions);
        }
        catch (ClassCastException e) {
            throw new BadFormatException("Error reading Block format", e);
        }
    }

    public AVector<SignedData<ATransaction>> getTransactions() {
        return this.transactions;
    }

    @Override
    public boolean isCanonical() {
        return this.transactions.isCanonical();
    }

    @Override
    public byte getTag() {
        return -85;
    }

    @Override
    public void validateCell() throws InvalidDataException {
        this.transactions.validateCell();
    }

    @Override
    public boolean equals(AMap<Keyword, ACell> a) {
        if (!(a instanceof Block)) {
            return false;
        }
        return this.equals((Block)a);
    }

    public boolean equals(Block a) {
        Hash ha;
        if (a == null) {
            return false;
        }
        if (this.timestamp != a.timestamp) {
            return false;
        }
        Hash h = this.cachedHash();
        if (h != null && (ha = a.cachedHash()) != null) {
            return Utils.equals(h, ha);
        }
        if (!Utils.equals(this.peerKey, a.peerKey)) {
            return false;
        }
        return Utils.equals(this.transactions, a.transactions);
    }
}

