/*
 * Decompiled with CFR 0.152.
 */
package mdlaf.themes;

import java.awt.Color;
import javax.swing.BorderFactory;
import javax.swing.UIDefaults;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import mdlaf.shadows.DropShadowBorder;
import mdlaf.themes.AbstractMaterialTheme;
import mdlaf.utils.MaterialBorders;
import mdlaf.utils.MaterialColors;
import mdlaf.utils.MaterialImageFactory;
import mdlaf.utils.icons.IMaterialIconCode;
import mdlaf.utils.icons.MaterialIconFont;

public class MaterialOceanicTheme
extends AbstractMaterialTheme {
    private ColorUIResource selectedBackground = new ColorUIResource(50, 66, 74);

    @Override
    protected void installIcons() {
        super.installIcons();
        this.selectedCheckBoxIconSelectionRowTable = MaterialImageFactory.getInstance().getImage((IMaterialIconCode)MaterialIconFont.CHECK_BOX, this.highlightBackgroundPrimary);
        this.unselectedCheckBoxIconSelectionRowTable = MaterialImageFactory.getInstance().getImage((IMaterialIconCode)MaterialIconFont.CHECK_BOX_OUTLINE_BLANK, this.highlightBackgroundPrimary);
        this.selectedCheckBoxIconTable = MaterialImageFactory.getInstance().getImage((IMaterialIconCode)MaterialIconFont.CHECK_BOX, this.highlightBackgroundPrimary);
        this.unselectedCheckBoxIconTable = MaterialImageFactory.getInstance().getImage((IMaterialIconCode)MaterialIconFont.CHECK_BOX_OUTLINE_BLANK, this.highlightBackgroundPrimary);
        this.unselectedCheckBoxIcon = MaterialImageFactory.getInstance().getImage((IMaterialIconCode)MaterialIconFont.CHECK_BOX_OUTLINE_BLANK, this.textColor);
    }

    @Override
    protected void installBorders() {
        super.installBorders();
        this.borderMenuBar = new BorderUIResource(new DropShadowBorder(Color.DARK_GRAY, 10, 4, 0.3f, 12, false, false, true, false));
        this.borderPopupMenu = MaterialBorders.OCEAN_LINE_BORDER;
        this.borderSpinner = new BorderUIResource(BorderFactory.createLineBorder(this.backgroundTextField));
        this.borderSlider = new BorderUIResource(BorderFactory.createCompoundBorder(MaterialBorders.DARK_LINE_BORDER, BorderFactory.createEmptyBorder(15, 15, 15, 15)));
        this.cellBorderTableHeader = new BorderUIResource(BorderFactory.createCompoundBorder(MaterialBorders.DARK_LINE_BORDER, BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.borderToolBar = MaterialBorders.OCEAN_LINE_BORDER;
        this.borderDialogRootPane = MaterialBorders.LIGHT_SHADOW_BORDER;
        this.borderProgressBar = MaterialBorders.OCEAN_LINE_BORDER;
        this.borderTable = MaterialBorders.OCEAN_LINE_BORDER;
        this.borderTableHeader = new BorderUIResource(new DropShadowBorder(this.backgroundPrimary, 5, 3, 0.4f, 12, true, true, true, true));
        this.borderTitledBorder = new BorderUIResource(BorderFactory.createLineBorder(MaterialColors.WHITE));
    }

    @Override
    protected void installDefaultColor() {
        super.installDefaultColor();
        this.buttonDefaultTextColor = this.textColor;
        this.foregroundTableHeader = this.textColor;
        this.selectionForegroundTable = this.highlightBackgroundPrimary;
    }

    @Override
    protected void installColor() {
        this.backgroundPrimary = new ColorUIResource(38, 50, 56);
        this.highlightBackgroundPrimary = new ColorUIResource(0, 150, 136);
        this.textColor = new ColorUIResource(176, 190, 197);
        this.disableTextColor = new ColorUIResource(65, 89, 103);
        this.buttonBackgroundColor = new ColorUIResource(46, 60, 67);
        this.buttonBackgroundColorMouseHover = new ColorUIResource(84, 110, 122);
        this.buttonDefaultBackgroundColorMouseHover = new ColorUIResource(84, 110, 122);
        this.buttonDefaultBackgroundColor = new ColorUIResource(50, 66, 74);
        this.buttonDisabledBackground = this.buttonBackgroundColor;
        this.buttonDisabledForeground = this.disableTextColor;
        this.buttonFocusColor = this.buttonBackgroundColorMouseHover;
        this.buttonDefaultFocusColor = this.buttonDefaultBackgroundColorMouseHover;
        this.buttonBorderColor = this.buttonBackgroundColor;
        this.buttonColorHighlight = this.buttonBackgroundColorMouseHover;
        this.selectedInDropDownBackgroundComboBox = this.buttonBackgroundColorMouseHover;
        this.selectedForegroundComboBox = this.textColor;
        this.menuBackground = this.backgroundPrimary;
        this.menuBackgroundMouseHover = this.selectedBackground;
        this.arrowButtonColorScrollBar = this.buttonBackgroundColor;
        this.trackColorScrollBar = new ColorUIResource(30, 39, 44);
        this.thumbColorScrollBar = this.selectedBackground;
        this.arrowButtonOnClickColorScrollBar = this.buttonBackgroundColorMouseHover;
        this.mouseHoverColorScrollBar = this.buttonBackgroundColorMouseHover;
        this.trackColorSlider = this.highlightBackgroundPrimary;
        this.haloColorSlider = MaterialColors.bleach(this.highlightBackgroundPrimary, 0.5f);
        this.highlightColorTabbedPane = this.highlightBackgroundPrimary;
        this.borderHighlightColorTabbedPane = this.highlightBackgroundPrimary;
        this.focusColorLineTabbedPane = this.highlightBackgroundPrimary;
        this.disableColorTabTabbedPane = MaterialColors.COSMO_STRONG_GRAY;
        this.backgroundTable = new ColorUIResource(30, 39, 44);
        this.backgroundTableHeader = new ColorUIResource(30, 39, 44);
        this.selectionBackgroundTable = this.selectedBackground;
        this.gridColorTable = new ColorUIResource(30, 39, 44);
        this.alternateRowBackgroundTable = null;
        this.backgroundTextField = this.backgroundPrimary;
        this.inactiveForegroundTextField = this.textColor;
        this.inactiveBackgroundTextField = this.backgroundTextField;
        this.selectionBackgroundTextField = this.highlightBackgroundPrimary;
        this.selectionForegroundTextField = this.textColor;
        this.disabledBackgroudnTextField = new ColorUIResource(65, 89, 103);
        this.disabledForegroundTextField = this.disableTextColor;
        this.inactiveColorLineTextField = this.textColor;
        this.activeColorLineTextField = this.highlightColorTabbedPane;
        this.arrowButtonBackgroundSpinner = this.backgroundTextField;
        this.mouseHoverButtonColorSpinner = this.buttonBackgroundColorMouseHover;
        this.titleBackgroundGradientStartTaskPane = this.backgroundPrimary;
        this.titleBackgroundGradientEndTaskPane = this.highlightBackgroundPrimary;
        this.titleOverTaskPane = this.highlightBackgroundPrimary;
        this.specialTitleOverTaskPane = this.textColor;
        this.backgroundTaskPane = this.highlightBackgroundPrimary;
        this.borderColorTaskPane = new ColorUIResource(65, 89, 103);
        this.contentBackgroundTaskPane = this.backgroundTaskPane;
        this.selectionBackgroundList = this.selectionBackgroundTable;
        this.selectionForegroundList = this.selectionForegroundTable;
        this.backgroundProgressBar = new ColorUIResource(30, 39, 44);
        this.foregroundProgressBar = this.highlightBackgroundPrimary;
        this.withoutIconSelectedBackgroundToggleButton = this.highlightBackgroundPrimary;
        this.withoutIconSelectedForegoundToggleButton = MaterialColors.BLACK;
        this.withoutIconBackgroundToggleButton = this.backgroundPrimary;
        this.withoutIconForegroundToggleButton = this.textColor;
        this.colorDividierSplitPane = MaterialColors.COSMO_DARK_GRAY;
        this.colorDividierFocusSplitPane = MaterialColors.LIME_A400;
        this.backgroundSeparator = MaterialColors.GRAY_300;
        this.foregroundSeparator = MaterialColors.GRAY_300;
        this.titleColorTaskPane = MaterialColors.BLACK;
        this.backgroundToolTip = this.menuBackground;
    }

    @Override
    public void installUIDefault(UIDefaults table) {
        super.installUIDefault(table);
    }

    @Override
    public String getName() {
        return "Material Oceanic";
    }

    @Override
    public boolean getButtonBorderEnable() {
        return false;
    }

    @Override
    public int getArchBorderComboBox() {
        return 0;
    }
}

