/*
 * Decompiled with CFR 0.152.
 */
package convex.core.lang;

import convex.core.ErrorCodes;
import convex.core.State;
import convex.core.data.ABlob;
import convex.core.data.ABlobMap;
import convex.core.data.ACell;
import convex.core.data.ADataStructure;
import convex.core.data.AHashMap;
import convex.core.data.AList;
import convex.core.data.AMap;
import convex.core.data.ASequence;
import convex.core.data.ASet;
import convex.core.data.AString;
import convex.core.data.AVector;
import convex.core.data.AccountKey;
import convex.core.data.AccountStatus;
import convex.core.data.Address;
import convex.core.data.Blob;
import convex.core.data.BlobMaps;
import convex.core.data.Format;
import convex.core.data.Hash;
import convex.core.data.INumeric;
import convex.core.data.Keyword;
import convex.core.data.Keywords;
import convex.core.data.List;
import convex.core.data.MapEntry;
import convex.core.data.Maps;
import convex.core.data.SetLeaf;
import convex.core.data.Sets;
import convex.core.data.Symbol;
import convex.core.data.Syntax;
import convex.core.data.Vectors;
import convex.core.data.prim.APrimitive;
import convex.core.data.prim.CVMBool;
import convex.core.data.prim.CVMByte;
import convex.core.data.prim.CVMChar;
import convex.core.data.prim.CVMDouble;
import convex.core.data.prim.CVMLong;
import convex.core.data.type.AType;
import convex.core.data.type.Types;
import convex.core.lang.AFn;
import convex.core.lang.AOp;
import convex.core.lang.Compiler;
import convex.core.lang.Context;
import convex.core.lang.Juice;
import convex.core.lang.RT;
import convex.core.lang.Reader;
import convex.core.lang.Symbols;
import convex.core.lang.impl.CoreFn;
import convex.core.lang.impl.CorePred;
import convex.core.lang.impl.ErrorValue;
import convex.core.lang.impl.HaltValue;
import convex.core.lang.impl.RecurValue;
import convex.core.lang.impl.Reduced;
import convex.core.lang.impl.ReturnValue;
import convex.core.lang.impl.RollbackValue;
import convex.core.lang.impl.TailcallValue;
import convex.core.util.Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class Core {
    public static final AHashMap<Symbol, ACell> ENVIRONMENT;
    public static final AHashMap<Symbol, AHashMap<ACell, ACell>> METADATA;
    public static final Symbol CORE_SYMBOL;
    private static final HashSet<ACell> tempReg;
    public static final CoreFn<AVector<ACell>> VECTOR;
    public static final CoreFn<ASequence<ACell>> CONCAT;
    public static final CoreFn<AVector<ACell>> VEC;
    public static final CoreFn<AVector<ACell>> REVERSE;
    public static final CoreFn<ASet<ACell>> SET;
    public static final CoreFn<ASet<ACell>> UNION;
    public static final CoreFn<ASet<ACell>> INTERSECTION;
    public static final CoreFn<ASet<ACell>> DIFFERENCE;
    public static final CoreFn<AList<ACell>> LIST;
    public static final CoreFn<AString> STR;
    public static final CoreFn<AString> NAME;
    public static final CoreFn<Keyword> KEYWORD;
    public static final CoreFn<Symbol> SYMBOL;
    public static final CoreFn<AOp<ACell>> COMPILE;
    public static final CoreFn<ACell> EVAL;
    public static final CoreFn<ACell> EVAL_AS;
    public static final CoreFn<CVMLong> SCHEDULE_STAR;
    public static final CoreFn<Syntax> SYNTAX;
    public static final CoreFn<ACell> UNSYNTAX;
    public static final CoreFn<AHashMap<ACell, ACell>> META;
    public static final CorePred SYNTAX_Q;
    public static final CoreFn<ACell> EXPAND;
    public static final AFn<ACell> INITIAL_EXPANDER;
    public static final AFn<ACell> QUOTE_EXPANDER;
    public static final AFn<ACell> QUASIQUOTE_EXPANDER;
    public static final CoreFn<CVMBool> CALLABLE_Q;
    public static final CoreFn<Address> DEPLOY;
    public static final CoreFn<CVMLong> ACCEPT;
    public static final CoreFn<ACell> CALL_STAR;
    public static final CoreFn<Hash> LOG;
    public static final CoreFn<ACell> UNDEF_STAR;
    public static final CoreFn<ACell> LOOKUP;
    public static final CoreFn<Syntax> LOOKUP_META;
    public static final CoreFn<Address> ADDRESS;
    public static final CoreFn<ABlob> BLOB;
    public static final CoreFn<AccountStatus> ACCOUNT;
    public static final CoreFn<CVMLong> BALANCE;
    public static final CoreFn<CVMLong> TRANSFER;
    public static final CoreFn<CVMLong> SET_MEMORY;
    public static final CoreFn<CVMLong> TRANSFER_MEMORY;
    public static final CoreFn<CVMLong> STAKE;
    public static final CoreFn<CVMLong> CREATE_PEER;
    public static final CoreFn<CVMLong> SET_PEER_DATA;
    public static final CoreFn<CVMLong> SET_PEER_STAKE;
    public static final CoreFn<AMap<?, ?>> HASHMAP;
    public static final CoreFn<ABlobMap> BLOB_MAP;
    public static final CoreFn<ASet<?>> HASHSET;
    public static final CoreFn<AVector<ACell>> KEYS;
    public static final CoreFn<AVector<ACell>> VALUES;
    public static final CoreFn<ADataStructure<ACell>> ASSOC;
    public static final CoreFn<ACell> ASSOC_IN;
    public static final CoreFn<ACell> GET_HOLDING;
    public static final CoreFn<ACell> SET_HOLDING;
    public static final CoreFn<ACell> SET_CONTROLLER;
    public static final CoreFn<AccountKey> SET_KEY;
    public static final CoreFn<ACell> GET;
    public static final CoreFn<ACell> GET_IN;
    public static final CoreFn<CVMBool> CONTAINS_KEY_Q;
    public static final CoreFn<CVMBool> SUBSET_Q;
    public static final CoreFn<AMap<?, ?>> DISSOC;
    public static final CoreFn<ADataStructure<ACell>> CONJ;
    public static final CoreFn<ASet<ACell>> DISJ;
    public static final CoreFn<AList<ACell>> CONS;
    public static final CoreFn<ACell> FIRST;
    public static final CoreFn<ACell> SECOND;
    public static final CoreFn<ACell> LAST;
    public static final CoreFn<CVMBool> EQUALS;
    public static final CoreFn<CVMBool> EQ;
    public static final CoreFn<CVMBool> GE;
    public static final CoreFn<CVMBool> GT;
    public static final CoreFn<CVMBool> LE;
    public static final CoreFn<CVMBool> LT;
    public static final CoreFn<CVMLong> INC;
    public static final CoreFn<CVMLong> DEC;
    public static final CoreFn<CVMBool> BOOLEAN;
    public static final CorePred BOOLEAN_Q;
    public static final CoreFn<ABlob> ENCODING;
    public static final CoreFn<CVMLong> LONG;
    public static final CoreFn<CVMDouble> DOUBLE;
    public static final CoreFn<CVMChar> CHAR;
    public static final CoreFn<CVMByte> BYTE;
    public static final CoreFn<APrimitive> PLUS;
    public static final CoreFn<APrimitive> MINUS;
    public static final CoreFn<APrimitive> TIMES;
    public static final CoreFn<CVMDouble> DIVIDE;
    public static final CoreFn<CVMDouble> FLOOR;
    public static final CoreFn<CVMDouble> CEIL;
    public static final CoreFn<CVMDouble> SQRT;
    public static final CoreFn<APrimitive> ABS;
    public static final CoreFn<CVMLong> SIGNUM;
    public static final CoreFn<CVMLong> MOD;
    public static final CoreFn<CVMLong> REM;
    public static final CoreFn<CVMLong> QUOT;
    public static final CoreFn<CVMDouble> POW;
    public static final CoreFn<CVMDouble> EXP;
    public static final CoreFn<CVMBool> NOT;
    public static final CoreFn<Hash> HASH;
    public static final CoreFn<CVMLong> COUNT;
    public static final CoreFn<ACell> EMPTY;
    public static final CoreFn<ACell> NTH;
    public static final CoreFn<ASequence<ACell>> NEXT;
    public static final CoreFn<?> RECUR;
    public static final CoreFn<?> TAILCALL_STAR;
    public static final CoreFn<?> ROLLBACK;
    public static final CoreFn<?> HALT;
    public static final CoreFn<?> RETURN;
    public static final CoreFn<CVMBool> FAIL;
    public static final CoreFn<?> APPLY;
    public static final CoreFn<ADataStructure<ACell>> INTO;
    public static final CoreFn<AHashMap<ACell, ACell>> MERGE;
    public static final CoreFn<ASequence<?>> MAP;
    public static final CoreFn<ACell> REDUCE;
    public static final CoreFn<ACell> REDUCED;
    public static final CorePred NIL_Q;
    public static final CorePred VECTOR_Q;
    public static final CorePred LIST_Q;
    public static final CorePred SET_Q;
    public static final CorePred MAP_Q;
    public static final CorePred COLL_Q;
    public static final CorePred EMPTY_Q;
    public static final CorePred SYMBOL_Q;
    public static final CorePred KEYWORD_Q;
    public static final CorePred BLOB_Q;
    public static final CorePred ADDRESS_Q;
    public static final CorePred LONG_Q;
    public static final CorePred STR_Q;
    public static final CorePred NUMBER_Q;
    public static final CorePred NAN_Q;
    public static final CorePred FN_Q;
    public static final CorePred ZERO_Q;

    private static <T extends ACell> T reg(T o) {
        tempReg.add(o);
        return o;
    }

    private static final Context<ACell> reduceResult(Context<?> ctx) {
        Object ex = ctx.getValue();
        if (ex instanceof Reduced) {
            ctx = ctx.withResult(((Reduced)ex).getValue());
        }
        return ctx.consumeJuice(100L);
    }

    static Symbol symbolFor(ACell o) {
        if (o instanceof CoreFn) {
            return ((CoreFn)o).getSymbol();
        }
        throw new Error("Cant get symbol for object of type " + o.getClass());
    }

    private static AHashMap<Symbol, ACell> register(AHashMap<Symbol, ACell> env, ACell o) {
        Symbol sym = Core.symbolFor(o);
        assert (!env.containsKey(sym)) : "Duplicate core declaration: " + sym;
        return env.assoc(sym, o);
    }

    private static Context<?> registerCoreCode(AHashMap<Symbol, ACell> env) throws IOException {
        Address ADDR = Address.ZERO;
        State state = State.EMPTY.putAccount(ADDR, AccountStatus.createActor());
        Context<Object> ctx = Context.createFake(state, ADDR);
        for (Map.Entry me : env.entrySet()) {
            ctx = ctx.define((Symbol)me.getKey(), (ACell)me.getValue());
        }
        ACell form = null;
        AList<ACell> forms = Reader.readAll(Utils.readResourceAsString("convex/core.cvx"));
        for (ACell f : forms) {
            form = f;
            if ((ctx = ctx.expandCompile(form)).isExceptional()) {
                throw new Error("Error compiling form: " + form + "\nException : " + ctx.getExceptional());
            }
            AOp op = (AOp)ctx.getResult();
            ctx = ctx.execute(op);
            assert (!ctx.isExceptional()) : "Error executing op: " + op + "\nException : " + ctx.getExceptional().toString();
        }
        return ctx;
    }

    private static Context<?> applyDocumentation(Context<?> ctx) throws IOException {
        AMap metas = (AMap)Reader.read(Utils.readResourceAsString("convex/core/metadata.cvx"));
        for (Map.Entry entry : metas.entrySet()) {
            try {
                Symbol sym = (Symbol)entry.getKey();
                AHashMap meta = (AHashMap)entry.getValue();
                MapEntry<Object, Object> definedEntry = ctx.getEnvironment().getEntry(sym);
                if (definedEntry == null) {
                    AHashMap doc = (AHashMap)meta.get(Keywords.DOC);
                    if (doc == null) {
                        System.err.println("CORE WARNING: Missing :doc tag in metadata for: " + sym);
                        continue;
                    }
                    if (meta.get(Keywords.SPECIAL_Q) == CVMBool.TRUE) {
                        ctx = ctx.define(sym, sym);
                        definedEntry = MapEntry.create(sym, sym);
                    } else {
                        System.err.println("CORE WARNING: Documentation for non-existent core symbol: " + sym);
                        continue;
                    }
                }
                ctx = ctx.defineWithSyntax(Syntax.create(sym, meta), (ACell)definedEntry.getValue());
            }
            catch (Throwable ex) {
                throw new Error("Error applying documentation:  " + entry, ex);
            }
        }
        return ctx;
    }

    static {
        CORE_SYMBOL = Symbol.create("convex.core");
        tempReg = new HashSet();
        VECTOR = Core.reg(new CoreFn<AVector<ACell>>(Symbols.VECTOR){

            @Override
            public Context<AVector<ACell>> invoke(Context<ACell> context, ACell[] args) {
                long juice = 50L + (long)args.length * 50L;
                if (!context.checkJuice(juice)) {
                    return context.withJuiceError();
                }
                AVector result = Vectors.create(args);
                return context.withResult(juice, result);
            }
        });
        CONCAT = Core.reg(new CoreFn<ASequence<ACell>>(Symbols.CONCAT){

            @Override
            public Context<ASequence<ACell>> invoke(Context context, ACell[] args) {
                ASequence<?> result = null;
                int n = args.length;
                long juice = 10L;
                for (int ix = 0; ix < n; ++ix) {
                    ACell a = args[ix];
                    if (a == null) continue;
                    ASequence seq = RT.sequence(a);
                    if (seq == null) {
                        return context.withCastError(ix, args, Types.SEQUENCE);
                    }
                    if (!context.checkJuice(juice += 50L + seq.count() * 50L)) {
                        return context.withJuiceError();
                    }
                    result = RT.concat(result, seq);
                }
                return context.withResult(juice, result);
            }
        });
        VEC = Core.reg(new CoreFn<AVector<ACell>>(Symbols.VEC){

            @Override
            public Context<AVector<ACell>> invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                ACell o = args[0];
                Long n = RT.count(o);
                if (n == null) {
                    return context.withCastError(0, args, Types.VECTOR);
                }
                long juice = 50L + n * 50L;
                if (!context.checkJuice(juice)) {
                    return context.withJuiceError();
                }
                AVector result = RT.castVector(o);
                return context.withResult(juice, result);
            }
        });
        REVERSE = Core.reg(new CoreFn<AVector<ACell>>(Symbols.REVERSE){

            @Override
            public Context<AVector<ACell>> invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                ACell o = args[0];
                ASequence seq = RT.ensureSequence(o);
                if (seq == null) {
                    return context.withCastError(0, args, Types.SEQUENCE);
                }
                long juice = 50L;
                ASequence result = seq.reverse();
                return context.withResult(juice, result);
            }
        });
        SET = Core.reg(new CoreFn<ASet<ACell>>(Symbols.SET){

            @Override
            public Context<ASet<ACell>> invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                ACell o = args[0];
                Long n = RT.count(o);
                if (n == null) {
                    return context.withCastError(0, args, Types.SEQUENCE);
                }
                long juice = Juice.addMul(50L, n, 50L);
                if (!context.checkJuice(juice)) {
                    return context.withJuiceError();
                }
                ASet result = RT.castSet(o);
                if (result == null) {
                    return context.withCastError(0, args, Types.SET);
                }
                return context.withResult(juice, result);
            }
        });
        UNION = Core.reg(new CoreFn<ASet<ACell>>(Symbols.UNION){

            @Override
            public Context<ASet<ACell>> invoke(Context context, ACell[] args) {
                int n = args.length;
                ASet result = Sets.empty();
                long juice = 50L;
                for (int i = 0; i < n; ++i) {
                    ACell arg = args[i];
                    ASet set = RT.ensureSet(arg);
                    if (set == null) {
                        return context.withCastError(i, args, Types.SET);
                    }
                    long size = set.count();
                    if (!context.checkJuice(juice = Juice.addMul(juice, size, 50L))) {
                        return context.withJuiceError();
                    }
                    result = ((ASet)result).includeAll(set);
                }
                return context.withResult(juice, result);
            }
        });
        INTERSECTION = Core.reg(new CoreFn<ASet<ACell>>(Symbols.INTERSECTION){

            @Override
            public Context<ASet<ACell>> invoke(Context context, ACell[] args) {
                ASet result;
                if (args.length < 1) {
                    return context.withArityError(this.minArityMessage(1, args.length));
                }
                int n = args.length;
                ACell arg0 = args[0];
                ASet aSet = result = arg0 == null ? Sets.empty() : RT.ensureSet(arg0);
                if (result == null) {
                    return context.withCastError(0, args, Types.SET);
                }
                long juice = 50L;
                for (int i = 1; i < n; ++i) {
                    SetLeaf set;
                    ACell arg = args[i];
                    ASet aSet2 = set = arg == null ? Sets.empty() : RT.ensureSet(args[i]);
                    if (set == null) {
                        return context.withCastError(i, args, Types.SET);
                    }
                    long size = set.count();
                    if (!context.checkJuice(juice = Juice.addMul(juice, size, 50L))) {
                        return context.withJuiceError();
                    }
                    result = result.intersectAll(set);
                }
                return context.withResult(juice, result);
            }
        });
        DIFFERENCE = Core.reg(new CoreFn<ASet<ACell>>(Symbols.DIFFERENCE){

            @Override
            public Context<ASet<ACell>> invoke(Context context, ACell[] args) {
                ASet result;
                if (args.length < 1) {
                    return context.withArityError(this.minArityMessage(1, args.length));
                }
                int n = args.length;
                ACell arg0 = args[0];
                ASet aSet = result = arg0 == null ? Sets.empty() : RT.ensureSet(arg0);
                if (result == null) {
                    return context.withCastError(0, args, Types.SET);
                }
                long juice = 50L;
                for (int i = 1; i < n; ++i) {
                    ACell arg = args[i];
                    ASet set = RT.ensureSet(arg);
                    if (set == null) {
                        return context.withCastError(i, args, Types.SET);
                    }
                    long size = set.count();
                    if (!context.checkJuice(juice = Juice.addMul(juice, size, 50L))) {
                        return context.withJuiceError();
                    }
                    result = result.excludeAll(set);
                }
                return context.withResult(juice, result);
            }
        });
        LIST = Core.reg(new CoreFn<AList<ACell>>(Symbols.LIST){

            @Override
            public Context<AList<ACell>> invoke(Context context, ACell[] args) {
                long juice = 50L + (long)args.length * 50L;
                if (!context.checkJuice(juice)) {
                    return context.withJuiceError();
                }
                List result = List.create(args);
                return context.withResult(juice, result);
            }
        });
        STR = Core.reg(new CoreFn<AString>(Symbols.STR){

            @Override
            public Context<AString> invoke(Context context, ACell[] args) {
                AString result = RT.str(args);
                if (result == null) {
                    return context.withCastError(Types.STRING);
                }
                long juice = 20L + (long)result.length() * 5L;
                return context.withResult(juice, result);
            }
        });
        NAME = Core.reg(new CoreFn<AString>(Symbols.NAME){

            @Override
            public Context<AString> invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                ACell arg = args[0];
                AString result = RT.name(arg);
                if (result == null) {
                    return context.withCastError(0, args, Types.STRING);
                }
                long juice = 20L;
                return context.withResult(juice, result);
            }
        });
        KEYWORD = Core.reg(new CoreFn<Keyword>(Symbols.KEYWORD){

            @Override
            public Context<Keyword> invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                ACell arg = args[0];
                if (arg instanceof Keyword) {
                    return context.withResult(50L, arg);
                }
                AString name = RT.name(arg);
                if (name == null) {
                    return context.withCastError(0, args, Types.KEYWORD);
                }
                Keyword result = Keyword.create(name);
                if (result == null) {
                    return context.withArgumentError("Invalid Keyword name, must be between 1 and 64 characters");
                }
                return context.withResult(50L, result);
            }
        });
        SYMBOL = Core.reg(new CoreFn<Symbol>(Symbols.SYMBOL){

            @Override
            public Context<Symbol> invoke(Context context, ACell[] args) {
                int n = args.length;
                if (n != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                ACell maybeName = args[n - 1];
                if (maybeName instanceof Symbol) {
                    Symbol sym = (Symbol)maybeName;
                    return context.withResult(50L, sym);
                }
                AString name = RT.name(maybeName);
                if (name == null) {
                    return context.withCastError(0, args, Types.SYMBOL);
                }
                Symbol sym = Symbol.create(name);
                if (sym == null) {
                    return context.withArgumentError("Invalid Symbol name, must be between 1 and 64 characters");
                }
                long juice = 50L;
                return context.withResult(juice, sym);
            }
        });
        COMPILE = Core.reg(new CoreFn<AOp<ACell>>(Symbols.COMPILE){

            @Override
            public Context<AOp<ACell>> invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                ACell form = args[0];
                return context.expandCompile(form);
            }
        });
        EVAL = Core.reg(new CoreFn<ACell>(Symbols.EVAL){

            @Override
            public Context<ACell> invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                ACell form = args[0];
                Context rctx = context.eval(form);
                return rctx.consumeJuice(500L);
            }
        });
        EVAL_AS = Core.reg(new CoreFn<ACell>(Symbols.EVAL_AS){

            @Override
            public Context<ACell> invoke(Context context, ACell[] args) {
                if (args.length != 2) {
                    return context.withArityError(this.exactArityMessage(2, args.length));
                }
                Address address = RT.ensureAddress(args[0]);
                if (address == null) {
                    return context.withCastError(0, args, Types.ADDRESS);
                }
                ACell form = args[1];
                Context rctx = context.evalAs(address, form);
                return rctx.consumeJuice(500L);
            }
        });
        SCHEDULE_STAR = Core.reg(new CoreFn<CVMLong>(Symbols.SCHEDULE_STAR){

            @Override
            public Context<CVMLong> invoke(Context context, ACell[] args) {
                int n = args.length;
                if (n != 2) {
                    return context.withArityError(this.exactArityMessage(3, n));
                }
                CVMLong tso = RT.ensureLong(args[0]);
                if (tso == null) {
                    return context.withCastError(0, args, Types.LONG);
                }
                long scheduleTimestamp = tso.longValue();
                ACell opo = args[1];
                if (!(opo instanceof AOp)) {
                    return context.withCastError(1, args, Types.OP);
                }
                AOp op = (AOp)opo;
                return context.schedule(scheduleTimestamp, op);
            }
        });
        SYNTAX = Core.reg(new CoreFn<Syntax>(Symbols.SYNTAX){

            @Override
            public Context<Syntax> invoke(Context context, ACell[] args) {
                Syntax result;
                int n = args.length;
                if (n < 1) {
                    return context.withArityError(this.minArityMessage(1, args.length));
                }
                if (n > 2) {
                    return context.withArityError(this.maxArityMessage(2, args.length));
                }
                if (n == 1) {
                    result = Syntax.create(args[0]);
                } else {
                    AHashMap<ACell, ACell> meta = RT.ensureHashMap(args[1]);
                    if (meta == null) {
                        return context.withCastError(1, args, Types.MAP);
                    }
                    result = Syntax.create(args[0], meta);
                }
                long juice = 20L;
                return context.withResult(juice, result);
            }
        });
        UNSYNTAX = Core.reg(new CoreFn<ACell>(Symbols.UNSYNTAX){

            @Override
            public Context<ACell> invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                ACell result = (ACell)Syntax.unwrap(args[0]);
                long juice = 20L;
                return context.withResult(juice, result);
            }
        });
        META = Core.reg(new CoreFn<AHashMap<ACell, ACell>>(Symbols.META){

            @Override
            public Context<AHashMap<ACell, ACell>> invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                ACell a = args[0];
                AHashMap<ACell, ACell> result = a instanceof Syntax ? ((Syntax)a).getMeta() : null;
                long juice = 10L;
                return context.withResult(juice, result);
            }
        });
        SYNTAX_Q = Core.reg(new CorePred(Symbols.SYNTAX_Q){

            @Override
            public boolean test(ACell val) {
                return val instanceof Syntax;
            }
        });
        EXPAND = Core.reg(new CoreFn<ACell>(Symbols.EXPAND){

            @Override
            public Context<ACell> invoke(Context context, ACell[] args) {
                ACell contArg;
                ACell exArg;
                int n = args.length;
                if (n < 1 || n > 3) {
                    return context.withArityError(this.name() + " requires a form argument, optional expander and optional continuation expander (arity 1, 2 or 2)");
                }
                AFn<ACell> expander = Compiler.INITIAL_EXPANDER;
                if (n >= 2 && (expander = RT.ensureFunction(exArg = args[1])) == null) {
                    return context.withCastError(1, args, Types.FUNCTION);
                }
                AFn<ACell> cont = expander;
                if (n >= 3 && (cont = RT.ensureFunction(contArg = args[2])) == null) {
                    return context.withCastError(2, args, Types.FUNCTION);
                }
                ACell form = args[0];
                Context<ACell> rctx = context.expand(expander, form, cont);
                return rctx;
            }
        });
        INITIAL_EXPANDER = Core.reg(Compiler.INITIAL_EXPANDER);
        QUOTE_EXPANDER = Core.reg(Compiler.QUOTE_EXPANDER);
        QUASIQUOTE_EXPANDER = Core.reg(Compiler.QUASIQUOTE_EXPANDER);
        CALLABLE_Q = Core.reg(new CoreFn<CVMBool>(Symbols.CALLABLE_Q){

            @Override
            public Context<CVMBool> invoke(Context context, ACell[] args) {
                if (args.length != 2) {
                    return context.withArityError(this.exactArityMessage(2, args.length));
                }
                Address addr = RT.ensureAddress(args[0]);
                if (addr == null) {
                    return context.withCastError(1, args, Types.ADDRESS);
                }
                Symbol sym = RT.ensureSymbol(args[1]);
                if (sym == null) {
                    return context.withCastError(1, args, Types.SYMBOL);
                }
                AccountStatus as = context.getState().getAccount(addr);
                if (as == null) {
                    return context.withResult(15L, CVMBool.FALSE);
                }
                AHashMap symMeta = (AHashMap)as.getMetadata().get(sym);
                CVMBool result = symMeta == null ? CVMBool.FALSE : CVMBool.of(symMeta.get(Keywords.CALLABLE_Q) == CVMBool.TRUE);
                return context.withResult(15L, result);
            }
        });
        DEPLOY = Core.reg(new CoreFn<Address>(Symbols.DEPLOY){

            @Override
            public Context<Address> invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                return context.deployActor(args[0]);
            }
        });
        ACCEPT = Core.reg(new CoreFn<CVMLong>(Symbols.ACCEPT){

            @Override
            public Context<CVMLong> invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                CVMLong amount = RT.ensureLong(args[0]);
                if (amount == null) {
                    return context.withCastError(0, args, Types.LONG);
                }
                return context.acceptFunds(amount.longValue());
            }
        });
        CALL_STAR = Core.reg(new CoreFn<ACell>(Symbols.CALL_STAR){

            @Override
            public Context<ACell> invoke(Context context, ACell[] args) {
                if (args.length < 3) {
                    return context.withArityError(this.minArityMessage(1, args.length));
                }
                Context<ACell> ctx = context.consumeJuice(100L);
                if (ctx.isExceptional()) {
                    return ctx;
                }
                Address target = RT.ensureAddress(args[0]);
                if (target == null) {
                    return ctx.withCastError(0, args, Types.ADDRESS);
                }
                CVMLong sendAmount = RT.ensureLong(args[1]);
                if (sendAmount == null) {
                    return ctx.withCastError(1, args, Types.LONG);
                }
                Symbol sym = RT.ensureSymbol(args[2]);
                if (sym == null) {
                    return ctx.withCastError(2, args, Types.SYMBOL);
                }
                int arity = args.length - 3;
                ACell[] callArgs = Arrays.copyOfRange(args, 3, 3 + arity);
                return ctx.actorCall(target, sendAmount.longValue(), sym, callArgs);
            }
        });
        LOG = Core.reg(new CoreFn<Hash>(Symbols.LOG){

            @Override
            public Context<Hash> invoke(Context context, ACell[] args) {
                int n = args.length;
                long juice = 150L + (long)n * 50L;
                if (!context.checkJuice(juice)) {
                    return context.withJuiceError();
                }
                AVector<ACell> values = Vectors.create(args);
                context = context.appendLog(values);
                return context.withResult(juice, values);
            }
        });
        UNDEF_STAR = Core.reg(new CoreFn<ACell>(Symbols.UNDEF_STAR){

            @Override
            public Context<ACell> invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                Symbol sym = RT.ensureSymbol(args[0]);
                if (sym == null) {
                    return context.withArgumentError("Invalid Symbol name for undef: " + Utils.toString(args[0]));
                }
                Context ctx = context.undefine(sym);
                return ctx.withResult(100L, null);
            }
        });
        LOOKUP = Core.reg(new CoreFn<ACell>(Symbols.LOOKUP){

            @Override
            public Context<ACell> invoke(Context context, ACell[] args) {
                Address address;
                int n = args.length;
                if (n < 1 || n > 2) {
                    return context.withArityError(this.rangeArityMessage(1, 2, args.length));
                }
                Address address2 = address = n == 1 ? context.getAddress() : RT.ensureAddress(args[0]);
                if (address == null) {
                    return context.withCastError(0, args, Types.ADDRESS);
                }
                ACell symArg = args[n - 1];
                Symbol sym = RT.ensureSymbol(symArg);
                if (sym == null) {
                    return context.withCastError(n - 1, args, Types.SYMBOL);
                }
                MapEntry<Symbol, ACell> me = context.lookupDynamicEntry(address, sym);
                long juice = 15L;
                Object result = me == null ? null : me.getValue();
                return context.withResult(juice, result);
            }
        });
        LOOKUP_META = Core.reg(new CoreFn<Syntax>(Symbols.LOOKUP_META){

            @Override
            public Context<Syntax> invoke(Context context, ACell[] args) {
                int n = args.length;
                if (n < 1 || n > 2) {
                    return context.withArityError(this.rangeArityMessage(1, 2, args.length));
                }
                Address address = null;
                if (n > 1 && (address = RT.ensureAddress(args[0])) == null) {
                    return context.withCastError(0, args, Types.ADDRESS);
                }
                ACell symArg = args[n - 1];
                Symbol sym = RT.ensureSymbol(symArg);
                if (sym == null) {
                    return context.withCastError(n - 1, args, Types.SYMBOL);
                }
                AHashMap<ACell, ACell> result = context.lookupMeta(address, sym);
                long juice = 15L;
                return context.withResult(juice, result);
            }
        });
        ADDRESS = Core.reg(new CoreFn<Address>(Symbols.ADDRESS){

            @Override
            public Context<Address> invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                ACell o = args[0];
                Address address = RT.castAddress(o);
                if (address == null) {
                    if (o instanceof AString) {
                        return context.withArgumentError("String not convertible to a valid Address: " + o);
                    }
                    if (o instanceof ABlob) {
                        return context.withArgumentError("Blob not convertiable a valid Address: " + o);
                    }
                    return context.withCastError(0, args, Types.ADDRESS);
                }
                long juice = 100L;
                return context.withResult(juice, address);
            }
        });
        BLOB = Core.reg(new CoreFn<ABlob>(Symbols.BLOB){

            @Override
            public Context<ABlob> invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                ABlob blob = RT.castBlob(args[0]);
                if (blob == null) {
                    return context.withCastError(0, args, Types.BLOB);
                }
                long juice = 100L + 1L * blob.count();
                return context.withResult(juice, blob);
            }
        });
        ACCOUNT = Core.reg(new CoreFn<AccountStatus>(Symbols.ACCOUNT){

            @Override
            public Context<AccountStatus> invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                ACell a0 = args[0];
                Address address = RT.ensureAddress(a0);
                if (address == null) {
                    return context.withCastError(0, args, Types.ADDRESS);
                }
                AccountStatus as = context.getAccountStatus(address);
                return context.withResult(20L, as);
            }
        });
        BALANCE = Core.reg(new CoreFn<CVMLong>(Symbols.BALANCE){

            @Override
            public Context<CVMLong> invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                Address address = RT.ensureAddress(args[0]);
                if (address == null) {
                    return context.withCastError(0, args, Types.ADDRESS);
                }
                AccountStatus as = context.getAccountStatus(address);
                CVMLong balance = as != null ? CVMLong.create(as.getBalance()) : null;
                return context.withResult(200L, balance);
            }
        });
        TRANSFER = Core.reg(new CoreFn<CVMLong>(Symbols.TRANSFER){

            @Override
            public Context<CVMLong> invoke(Context context, ACell[] args) {
                if (args.length != 2) {
                    return context.withArityError(this.exactArityMessage(2, args.length));
                }
                Address address = RT.ensureAddress(args[0]);
                if (address == null) {
                    return context.withCastError(0, args, Types.ADDRESS);
                }
                CVMLong amount = RT.ensureLong(args[1]);
                if (amount == null) {
                    return context.withCastError(1, args, Types.LONG);
                }
                return context.transfer(address, amount.longValue()).consumeJuice(100L);
            }
        });
        SET_MEMORY = Core.reg(new CoreFn<CVMLong>(Symbols.SET_MEMORY){

            @Override
            public Context<CVMLong> invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                CVMLong amount = RT.ensureLong(args[0]);
                if (amount == null) {
                    return context.withCastError(0, args, Types.LONG);
                }
                return context.setMemory(amount.longValue()).consumeJuice(100L);
            }
        });
        TRANSFER_MEMORY = Core.reg(new CoreFn<CVMLong>(Symbols.TRANSFER_MEMORY){

            @Override
            public Context<CVMLong> invoke(Context context, ACell[] args) {
                if (args.length != 2) {
                    return context.withArityError(this.exactArityMessage(2, args.length));
                }
                Address address = RT.ensureAddress(args[0]);
                if (address == null) {
                    return context.withCastError(0, args, Types.ADDRESS);
                }
                CVMLong amount = RT.ensureLong(args[1]);
                if (amount == null) {
                    return context.withCastError(1, args, Types.LONG);
                }
                return context.transferMemoryAllowance(address, amount).consumeJuice(100L);
            }
        });
        STAKE = Core.reg(new CoreFn<CVMLong>(Symbols.STAKE){

            @Override
            public Context<CVMLong> invoke(Context context, ACell[] args) {
                if (args.length != 2) {
                    return context.withArityError(this.exactArityMessage(2, args.length));
                }
                AccountKey accountKey = RT.ensureAccountKey(args[0]);
                if (accountKey == null) {
                    return context.withCastError(0, args, Types.BLOB);
                }
                CVMLong amount = RT.ensureLong(args[1]);
                if (amount == null) {
                    return context.withCastError(1, args, Types.LONG);
                }
                return context.setDelegatedStake(accountKey, amount.longValue()).consumeJuice(100L);
            }
        });
        CREATE_PEER = Core.reg(new CoreFn<CVMLong>(Symbols.CREATE_PEER){

            @Override
            public Context<CVMLong> invoke(Context context, ACell[] args) {
                if (args.length != 2) {
                    return context.withArityError(this.exactArityMessage(2, args.length));
                }
                AccountKey accountKey = RT.ensureAccountKey(args[0]);
                if (accountKey == null) {
                    return context.withCastError(0, args, Types.BLOB);
                }
                CVMLong amount = RT.ensureLong(args[1]);
                if (amount == null) {
                    return context.withCastError(1, args, Types.LONG);
                }
                return context.createPeer(accountKey, amount.longValue()).consumeJuice(1000L);
            }
        });
        SET_PEER_DATA = Core.reg(new CoreFn<CVMLong>(Symbols.SET_PEER_DATA){

            @Override
            public Context<CVMLong> invoke(Context context, ACell[] args) {
                if (args.length != 2) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                AccountKey peerKey = RT.ensureAccountKey(args[0]);
                if (peerKey == null) {
                    return context.withCastError(0, args, Types.BLOB);
                }
                AMap<ACell, ACell> data = RT.ensureMap(args[1]);
                if (data == null) {
                    return context.withCastError(1, args, Types.MAP);
                }
                if ((context = context.consumeJuice(1000L)).isExceptional()) {
                    return context;
                }
                return context.setPeerData(peerKey, data);
            }
        });
        SET_PEER_STAKE = Core.reg(new CoreFn<CVMLong>(Symbols.SET_PEER_STAKE){

            @Override
            public Context<CVMLong> invoke(Context context, ACell[] args) {
                if (args.length != 2) {
                    return context.withArityError(this.exactArityMessage(2, args.length));
                }
                AccountKey peerKey = RT.ensureAccountKey(args[0]);
                if (peerKey == null) {
                    return context.withCastError(0, args, Types.BLOB);
                }
                CVMLong newStake = RT.ensureLong(args[1]);
                if (newStake == null) {
                    return context.withCastError(1, args, Types.LONG);
                }
                long targetStake = newStake.longValue();
                if ((context = context.consumeJuice(1000L)).isExceptional()) {
                    return context;
                }
                return context.setPeerStake(peerKey, targetStake);
            }
        });
        HASHMAP = Core.reg(new CoreFn<AMap<?, ?>>(Symbols.HASH_MAP){

            @Override
            public Context<AMap<?, ?>> invoke(Context context, ACell[] args) {
                int len = args.length;
                if (Utils.isOdd(len)) {
                    return context.withArityError(this.name() + " requires an even number of arguments");
                }
                long juice = 50L + (long)len * 50L;
                return context.withResult(juice, Maps.create(args));
            }
        });
        BLOB_MAP = Core.reg(new CoreFn<ABlobMap>(Symbols.BLOB_MAP){

            @Override
            public Context<ABlobMap> invoke(Context context, ACell[] args) {
                int len = args.length;
                if (Utils.isOdd(len)) {
                    return context.withArityError(this.name() + " requires an even number of arguments");
                }
                long juice = 50L + (long)len * 50L;
                if (!context.checkJuice(juice)) {
                    return context.withJuiceError();
                }
                Object r = BlobMaps.empty();
                int n = len / 2;
                for (int i = 0; i < n; ++i) {
                    int ix = i * 2;
                    ACell k = args[ix];
                    ACell v = args[ix + 1];
                    if ((r = ((ABlobMap)r).assoc(k, v)) != null) continue;
                    return context.withArgumentError("Cannot have a key of Type " + RT.getType(k) + " in blob-map");
                }
                return context.withResult(juice, r);
            }
        });
        HASHSET = Core.reg(new CoreFn<ASet<?>>(Symbols.HASH_SET){

            @Override
            public Context<ASet<?>> invoke(Context context, ACell[] args) {
                long juice = 50L + (long)args.length * 50L;
                if (!context.checkJuice(juice)) {
                    return context.withJuiceError();
                }
                return context.withResult(juice, Sets.of(args));
            }
        });
        KEYS = Core.reg(new CoreFn<AVector<ACell>>(Symbols.KEYS){

            @Override
            public Context<AVector<ACell>> invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                ACell a = args[0];
                if (!(a instanceof AMap)) {
                    return context.withCastError(0, args, Types.MAP);
                }
                AMap m = (AMap)a;
                long juice = 50L + m.count() * 50L;
                if (!context.checkJuice(juice)) {
                    return context.withJuiceError();
                }
                AVector keys = RT.keys(m);
                return context.withResult(juice, keys);
            }
        });
        VALUES = Core.reg(new CoreFn<AVector<ACell>>(Symbols.VALUES){

            @Override
            public Context<AVector<ACell>> invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                ACell a = args[0];
                if (!(a instanceof AMap)) {
                    return context.withCastError(0, args, Types.MAP);
                }
                AMap m = (AMap)a;
                long juice = 50L + m.count() * 50L;
                if (!context.checkJuice(juice)) {
                    return context.withJuiceError();
                }
                AVector keys = RT.values(m);
                return context.withResult(juice, keys);
            }
        });
        ASSOC = Core.reg(new CoreFn<ADataStructure<ACell>>(Symbols.ASSOC){

            @Override
            public Context<ADataStructure<ACell>> invoke(Context context, ACell[] args) {
                int n = args.length;
                if (n < 1) {
                    return context.withArityError(this.minArityMessage(1, n));
                }
                if (!Utils.isOdd(n)) {
                    return context.withArityError(this.name() + " requires key/value pairs as successive args");
                }
                long juice = 50L + (long)(n - 1) * 50L;
                if (!context.checkJuice(juice)) {
                    return context.withJuiceError();
                }
                ACell o = args[0];
                ADataStructure<?> result = RT.ensureAssociative(o);
                if (o != null && result == null) {
                    return context.withCastError(0, args, Types.DATA_STRUCTURE);
                }
                for (int i = 1; i < n; i += 2) {
                    ACell key = args[i];
                    if ((result = RT.assoc(result, key, args[i + 1])) != null) continue;
                    return context.withError(ErrorCodes.ARGUMENT, "Cannot assoc value - invalid key of type " + RT.getType(key));
                }
                return context.withResult(juice, result);
            }
        });
        ASSOC_IN = Core.reg(new CoreFn<ACell>(Symbols.ASSOC_IN){

            @Override
            public Context<ACell> invoke(Context context, ACell[] args) {
                Object k;
                ADataStructure struct;
                int i;
                if (args.length != 3) {
                    return context.withArityError(this.exactArityMessage(3, args.length));
                }
                ASequence ixs = RT.ensureSequence(args[1]);
                if (ixs == null) {
                    return context.withCastError(1, args, Types.SEQUENCE);
                }
                int n = ixs.size();
                long juice = 180L * (1L + (long)n);
                ACell data = args[0];
                ADataStructure value = args[2];
                if (n == 0) {
                    return context.withResult(juice, value);
                }
                ADataStructure[] ass = new ADataStructure[n];
                ACell[] ks = new ACell[n];
                for (i = 0; i < n; ++i) {
                    struct = RT.ensureAssociative(data);
                    if (struct == null) {
                        return context.withCastError(struct, (AType)Types.DATA_STRUCTURE);
                    }
                    ass[i] = struct;
                    ks[i] = k = ixs.get(i);
                    data = struct.get((ACell)k);
                }
                for (i = n - 1; i >= 0; --i) {
                    struct = ass[i];
                    k = ks[i];
                    if ((value = RT.assoc(struct, (ACell)k, value)) != null) continue;
                    return context.withError(ErrorCodes.ARGUMENT, "Invalid key of type " + RT.getType((ACell)k) + " or value of type " + RT.getType(value) + " for " + this.name());
                }
                return context.withResult(juice, value);
            }
        });
        GET_HOLDING = Core.reg(new CoreFn<ACell>(Symbols.GET_HOLDING){

            @Override
            public Context<ACell> invoke(Context context, ACell[] args) {
                int n = args.length;
                if (n != 1) {
                    return context.withArityError(this.exactArityMessage(1, n));
                }
                Address address = RT.ensureAddress(args[0]);
                if (address == null) {
                    return context.withCastError(args[0], (AType)Types.ADDRESS);
                }
                AccountStatus as = context.getAccountStatus(address);
                if (as == null) {
                    return context.withError(ErrorCodes.NOBODY, "Account with holdings does not exist.");
                }
                ABlobMap<Address, ACell> holdings = as.getHoldings();
                ACell result = holdings.get(context.getAddress());
                return context.withResult(15L, result);
            }
        });
        SET_HOLDING = Core.reg(new CoreFn<ACell>(Symbols.SET_HOLDING){

            @Override
            public Context<ACell> invoke(Context context, ACell[] args) {
                int n = args.length;
                if (n != 2) {
                    return context.withArityError(this.exactArityMessage(2, n));
                }
                Address address = RT.ensureAddress(args[0]);
                if (address == null) {
                    return context.withCastError(args[0], (AType)Types.ADDRESS);
                }
                ACell result = args[1];
                if ((context = context.setHolding(address, result)).isExceptional()) {
                    return context;
                }
                return context.withResult(150L, result);
            }
        });
        SET_CONTROLLER = Core.reg(new CoreFn<ACell>(Symbols.SET_CONTROLLER){

            @Override
            public Context<ACell> invoke(Context context, ACell[] args) {
                int n = args.length;
                if (n != 1) {
                    return context.withArityError(this.exactArityMessage(1, n));
                }
                ACell arg = args[0];
                Address controller = null;
                if (arg != null) {
                    controller = RT.ensureAddress(arg);
                    if (controller == null) {
                        return context.withCastError(arg, (AType)Types.ADDRESS);
                    }
                    if (context.getAccountStatus(controller) == null) {
                        return context.withError(ErrorCodes.NOBODY, this.name() + " must be passed an address for an existing account as controller.");
                    }
                }
                if ((context = context.setController(controller)).isExceptional()) {
                    return context;
                }
                return context.withResult(150L, controller);
            }
        });
        SET_KEY = Core.reg(new CoreFn<AccountKey>(Symbols.SET_KEY){

            @Override
            public Context<AccountKey> invoke(Context context, ACell[] args) {
                int n = args.length;
                if (n != 1) {
                    return context.withArityError(this.exactArityMessage(1, n));
                }
                ACell arg = args[0];
                AccountKey publicKey = RT.ensureAccountKey(arg);
                if (publicKey == null && arg != null) {
                    return context.withCastError(arg, (AType)Types.BLOB);
                }
                if ((context = context.setAccountKey(publicKey)).isExceptional()) {
                    return context;
                }
                return context.withResult(150L, publicKey);
            }
        });
        GET = Core.reg(new CoreFn<ACell>(Symbols.GET){

            @Override
            public Context<ACell> invoke(Context context, ACell[] args) {
                ADataStructure gettable;
                ACell result;
                int n = args.length;
                if (n < 2 || n > 3) {
                    return context.withArityError(this.name() + " requires exactly 2 or 3 arguments");
                }
                ACell coll = args[0];
                if (coll == null) {
                    result = n == 3 ? args[2] : null;
                } else if (n == 2) {
                    gettable = RT.ensureDataStructure(coll);
                    if (gettable == null) {
                        return context.withCastError(coll, (AType)Types.DATA_STRUCTURE);
                    }
                    result = gettable.get(args[1]);
                } else {
                    gettable = RT.ensureDataStructure(coll);
                    if (gettable == null) {
                        return context.withCastError(coll, (AType)Types.DATA_STRUCTURE);
                    }
                    result = gettable.get(args[1], args[2]);
                }
                long juice = 30L;
                return context.withResult(juice, result);
            }
        });
        GET_IN = Core.reg(new CoreFn<ACell>(Symbols.GET_IN){

            @Override
            public Context<ACell> invoke(Context context, ACell[] args) {
                int n = args.length;
                if (n < 2 || n > 3) {
                    return context.withArityError(this.name() + " requires exactly 2 or 3 arguments");
                }
                ASequence ixs = RT.ensureSequence(args[1]);
                if (ixs == null) {
                    return context.withCastError(args[1], (AType)Types.SEQUENCE);
                }
                ACell notFound = n < 3 ? null : args[2];
                int il = ixs.size();
                long juice = 30L * (1L + (long)il);
                ACell result = args[0];
                for (int i = 0; i < il; ++i) {
                    if (result == null) {
                        result = notFound;
                        break;
                    }
                    ADataStructure gettable = RT.ensureDataStructure(result);
                    if (gettable == null) {
                        return context.withCastError(result, (AType)Types.DATA_STRUCTURE);
                    }
                    Object k = ixs.get(i);
                    if (!gettable.containsKey((ACell)k)) {
                        return context.withResult(juice, notFound);
                    }
                    result = gettable.get((ACell)k);
                }
                return context.withResult(juice, result);
            }
        });
        CONTAINS_KEY_Q = Core.reg(new CoreFn<CVMBool>(Symbols.CONTAINS_KEY_Q){

            @Override
            public Context<CVMBool> invoke(Context context, ACell[] args) {
                CVMBool result;
                int n = args.length;
                if (n != 2) {
                    return context.withArityError(this.exactArityMessage(2, n));
                }
                ACell coll = args[0];
                if (coll == null) {
                    result = CVMBool.FALSE;
                } else {
                    ADataStructure gettable = RT.ensureDataStructure(args[0]);
                    if (gettable == null) {
                        return context.withCastError(args[0], (AType)Types.DATA_STRUCTURE);
                    }
                    result = CVMBool.of(gettable.containsKey(args[1]));
                }
                long juice = 30L;
                return context.withResult(juice, result);
            }
        });
        SUBSET_Q = Core.reg(new CoreFn<CVMBool>(Symbols.SUBSET_Q){

            @Override
            public Context<CVMBool> invoke(Context context, ACell[] args) {
                int n = args.length;
                if (n != 2) {
                    return context.withArityError(this.exactArityMessage(2, n));
                }
                ASet s0 = RT.ensureSet(args[0]);
                if (s0 == null) {
                    return context.withCastError(args[0], (AType)Types.SET);
                }
                long juice = 10L * s0.count();
                if (!context.checkJuice(juice)) {
                    return context.withJuiceError();
                }
                ASet s1 = RT.ensureSet(args[1]);
                if (s1 == null) {
                    return context.withCastError(args[1], (AType)Types.SET);
                }
                CVMBool result = CVMBool.of(s0.isSubset(s1));
                return context.withResult(juice, result);
            }
        });
        DISSOC = Core.reg(new CoreFn<AMap<?, ?>>(Symbols.DISSOC){

            @Override
            public Context<AMap<?, ?>> invoke(Context context, ACell[] args) {
                int n = args.length;
                if (args.length < 1) {
                    return context.withArityError(this.minArityMessage(1, args.length));
                }
                AMap result = RT.ensureMap(args[0]);
                if (result == null) {
                    return context.withCastError(args[0], (AType)Types.MAP);
                }
                for (int i = 1; i < n; ++i) {
                    result = result.dissoc(args[i]);
                }
                long juice = 50L + (long)(n - 1) * 50L;
                return context.withResult(juice, result);
            }
        });
        CONJ = Core.reg(new CoreFn<ADataStructure<ACell>>(Symbols.CONJ){

            @Override
            public Context<ADataStructure<ACell>> invoke(Context context, ACell[] args) {
                int numAdditions = args.length - 1;
                if (args.length <= 0) {
                    return context.withArityError(this.name() + " requires a data structure as first argument");
                }
                long juice = 50L + 50L * (long)numAdditions;
                if (!context.checkJuice(juice)) {
                    return context.withJuiceError();
                }
                ADataStructure<Object> result = RT.castDataStructure(args[0]);
                if (result == null) {
                    return context.withCastError(0, args, Types.DATA_STRUCTURE);
                }
                for (int i = 0; i < numAdditions; ++i) {
                    int argIndex = i + 1;
                    ACell val = args[argIndex];
                    if ((result = result.conj(val)) != null) continue;
                    return context.withError(ErrorCodes.ARGUMENT, "Failure to 'conj' argument at position " + argIndex + " (with Type " + RT.getType(val) + "). Probably not a legal value for this data structure?");
                }
                return context.withResult(juice, result);
            }
        });
        DISJ = Core.reg(new CoreFn<ASet<ACell>>(Symbols.DISJ){

            @Override
            public Context<ASet<ACell>> invoke(Context context, ACell[] args) {
                if (args.length < 1) {
                    return context.withArityError(this.minArityMessage(1, args.length));
                }
                int numAdditions = args.length - 1;
                long juice = 50L + 50L * (long)numAdditions;
                if (!context.checkJuice(juice)) {
                    return context.withJuiceError();
                }
                ASet<ACell> result = RT.ensureSet(args[0]);
                if (result == null) {
                    return context.withCastError(0, args, Types.SET);
                }
                for (int i = 0; i < numAdditions; ++i) {
                    int argIndex = i + 1;
                    ACell val = args[argIndex];
                    result = result.exclude(val);
                }
                return context.withResult(juice, result);
            }
        });
        CONS = Core.reg(new CoreFn<AList<ACell>>(Symbols.CONS){

            @Override
            public Context<AList<ACell>> invoke(Context context, ACell[] args) {
                int n = args.length;
                if (args.length < 2) {
                    return context.withArityError(this.minArityMessage(2, args.length));
                }
                long juice = 50L + 50L * (long)(n - 1);
                if (!context.checkJuice(juice)) {
                    return context.withJuiceError();
                }
                int lastIndex = n - 1;
                ASequence seq = RT.sequence(args[lastIndex]);
                if (seq == null) {
                    return context.withCastError(lastIndex, args, Types.SEQUENCE);
                }
                AList<ACell> list = RT.cons(args[n - 2], seq);
                for (int i = n - 3; i >= 0; --i) {
                    list = RT.cons(args[i], list);
                }
                return context.withResult(juice, list);
            }
        });
        FIRST = Core.reg(new CoreFn<ACell>(Symbols.FIRST){

            @Override
            public Context<ACell> invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                ACell maybeColl = args[0];
                Long n = RT.count(maybeColl);
                if (n == null) {
                    return context.withCastError(0, args, Types.SEQUENCE);
                }
                if (n < 1L) {
                    return context.withBoundsError(0L);
                }
                Object result = RT.nth(maybeColl, 0L);
                long juice = 20L;
                return context.withResult(juice, result);
            }
        });
        SECOND = Core.reg(new CoreFn<ACell>(Symbols.SECOND){

            @Override
            public Context<ACell> invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                ACell maybeColl = args[0];
                Long n = RT.count(maybeColl);
                if (n == null) {
                    return context.withCastError(0, args, Types.SEQUENCE);
                }
                if (n < 2L) {
                    return context.withBoundsError(1L);
                }
                Object result = RT.nth(maybeColl, 1L);
                long juice = 20L;
                return context.withResult(juice, result);
            }
        });
        LAST = Core.reg(new CoreFn<ACell>(Symbols.LAST){

            @Override
            public Context<ACell> invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                ACell a = args[0];
                Long n = RT.count(a);
                if (n == null) {
                    return context.withCastError(0, args, Types.SEQUENCE);
                }
                if (n <= 0L) {
                    return context.withBoundsError(-1L);
                }
                Object result = RT.nth(a, n - 1L);
                long juice = 20L;
                return context.withResult(juice, result);
            }
        });
        EQUALS = Core.reg(new CoreFn<CVMBool>(Symbols.EQUALS){

            @Override
            public Context<CVMBool> invoke(Context context, ACell[] args) {
                CVMBool result = CVMBool.of(RT.allEqual((ACell[])args));
                return context.withResult(20L, result);
            }
        });
        EQ = Core.reg(new CoreFn<CVMBool>(Symbols.EQ){

            @Override
            public Context<CVMBool> invoke(Context context, ACell[] args) {
                Boolean result = RT.eq(args);
                if (result == null) {
                    return context.withCastError(RT.findNonNumeric(args), args, Types.NUMBER);
                }
                return context.withResult(20L, CVMBool.create(result));
            }
        });
        GE = Core.reg(new CoreFn<CVMBool>(Symbols.GE){

            @Override
            public Context<CVMBool> invoke(Context context, ACell[] args) {
                Boolean result = RT.ge(args);
                if (result == null) {
                    return context.withCastError(RT.findNonNumeric(args), args, Types.NUMBER);
                }
                return context.withResult(20L, CVMBool.create(result));
            }
        });
        GT = Core.reg(new CoreFn<CVMBool>(Symbols.GT){

            @Override
            public Context<CVMBool> invoke(Context context, ACell[] args) {
                Boolean result = RT.gt(args);
                if (result == null) {
                    return context.withCastError(RT.findNonNumeric(args), args, Types.NUMBER);
                }
                return context.withResult(20L, CVMBool.create(result));
            }
        });
        LE = Core.reg(new CoreFn<CVMBool>(Symbols.LE){

            @Override
            public Context<CVMBool> invoke(Context context, ACell[] args) {
                Boolean result = RT.le(args);
                if (result == null) {
                    return context.withCastError(RT.findNonNumeric(args), args, Types.NUMBER);
                }
                return context.withResult(20L, CVMBool.create(result));
            }
        });
        LT = Core.reg(new CoreFn<CVMBool>(Symbols.LT){

            @Override
            public Context<CVMBool> invoke(Context context, ACell[] args) {
                Boolean result = RT.lt(args);
                if (result == null) {
                    return context.withCastError(RT.findNonNumeric(args), args, Types.NUMBER);
                }
                return context.withResult(20L, CVMBool.create(result));
            }
        });
        INC = Core.reg(new CoreFn<CVMLong>(Symbols.INC){

            @Override
            public Context<CVMLong> invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                ACell a = args[0];
                CVMLong result = RT.inc(a);
                if (result == null) {
                    return context.withCastError(0, args, Types.LONG);
                }
                return context.withResult(20L, result);
            }
        });
        DEC = Core.reg(new CoreFn<CVMLong>(Symbols.DEC){

            @Override
            public Context<CVMLong> invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                ACell a = args[0];
                CVMLong result = RT.dec(a);
                if (result == null) {
                    return context.withCastError(0, args, Types.LONG);
                }
                return context.withResult(20L, result);
            }
        });
        BOOLEAN = Core.reg(new CoreFn<CVMBool>(Symbols.BOOLEAN){

            @Override
            public Context<CVMBool> invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                CVMBool result = RT.bool(args[0]) ? CVMBool.TRUE : CVMBool.FALSE;
                return context.withResult(20L, result);
            }
        });
        BOOLEAN_Q = Core.reg(new CorePred(Symbols.BOOLEAN_Q){

            @Override
            public boolean test(ACell val) {
                return RT.isBoolean(val);
            }
        });
        ENCODING = Core.reg(new CoreFn<ABlob>(Symbols.ENCODING){

            @Override
            public Context<ABlob> invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                ACell a = args[0];
                Blob encoding = Format.encodedBlob(a);
                long juice = Juice.addMul(100L, ((ABlob)encoding).count(), 1L);
                return context.withResult(juice, encoding);
            }
        });
        LONG = Core.reg(new CoreFn<CVMLong>(Symbols.LONG){

            @Override
            public Context<CVMLong> invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                ACell a = args[0];
                CVMLong result = RT.castLong(a);
                if (result == null) {
                    return context.withCastError(0, args, Types.LONG);
                }
                return context.withResult(20L, result);
            }
        });
        DOUBLE = Core.reg(new CoreFn<CVMDouble>(Symbols.DOUBLE){

            @Override
            public Context<CVMDouble> invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                ACell a = args[0];
                CVMDouble result = RT.castDouble(a);
                if (result == null) {
                    return context.withCastError(0, args, Types.DOUBLE);
                }
                return context.withResult(20L, result);
            }
        });
        CHAR = Core.reg(new CoreFn<CVMChar>(Symbols.CHAR){

            @Override
            public Context<CVMChar> invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                ACell a = args[0];
                CVMChar result = RT.toCharacter(a);
                if (result == null) {
                    return context.withCastError(0, args, Types.CHARACTER);
                }
                return context.withResult(20L, result);
            }
        });
        BYTE = Core.reg(new CoreFn<CVMByte>(Symbols.BYTE){

            @Override
            public Context<CVMByte> invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                ACell a = args[0];
                CVMByte result = RT.castByte(a);
                if (result == null) {
                    return context.withCastError(0, args, Types.BYTE);
                }
                return context.withResult(20L, result);
            }
        });
        PLUS = Core.reg(new CoreFn<APrimitive>(Symbols.PLUS){

            @Override
            public Context<APrimitive> invoke(Context context, ACell[] args) {
                APrimitive result = RT.plus(args);
                if (result == null) {
                    return context.withCastError(RT.findNonNumeric(args), args, Types.NUMBER);
                }
                return context.withResult(20L, result);
            }
        });
        MINUS = Core.reg(new CoreFn<APrimitive>(Symbols.MINUS){

            @Override
            public Context<APrimitive> invoke(Context context, ACell[] args) {
                if (args.length < 1) {
                    return context.withArityError(this.minArityMessage(1, args.length));
                }
                APrimitive result = RT.minus(args);
                if (result == null) {
                    return context.withCastError(RT.findNonNumeric(args), args, Types.NUMBER);
                }
                return context.withResult(20L, result);
            }
        });
        TIMES = Core.reg(new CoreFn<APrimitive>(Symbols.TIMES){

            @Override
            public Context<APrimitive> invoke(Context context, ACell[] args) {
                APrimitive result = RT.times(args);
                if (result == null) {
                    return context.withCastError(RT.findNonNumeric(args), args, Types.NUMBER);
                }
                return context.withResult(20L, result);
            }
        });
        DIVIDE = Core.reg(new CoreFn<CVMDouble>(Symbols.DIVIDE){

            @Override
            public Context<CVMDouble> invoke(Context context, ACell[] args) {
                if (args.length < 1) {
                    return context.withArityError(this.minArityMessage(1, args.length));
                }
                CVMDouble result = RT.divide(args);
                if (result == null) {
                    return context.withCastError(RT.findNonNumeric(args), args, Types.NUMBER);
                }
                return context.withResult(20L, result);
            }
        });
        FLOOR = Core.reg(new CoreFn<CVMDouble>(Symbols.FLOOR){

            @Override
            public Context<CVMDouble> invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                CVMDouble result = RT.floor(args[0]);
                if (result == null) {
                    return context.withCastError(RT.findNonNumeric(args), args, Types.NUMBER);
                }
                return context.withResult(20L, result);
            }
        });
        CEIL = Core.reg(new CoreFn<CVMDouble>(Symbols.CEIL){

            @Override
            public Context<CVMDouble> invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                CVMDouble result = RT.ceil(args[0]);
                if (result == null) {
                    return context.withCastError(RT.findNonNumeric(args), args, Types.NUMBER);
                }
                return context.withResult(20L, result);
            }
        });
        SQRT = Core.reg(new CoreFn<CVMDouble>(Symbols.SQRT){

            @Override
            public Context<CVMDouble> invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                CVMDouble result = RT.sqrt(args[0]);
                if (result == null) {
                    return context.withCastError(RT.findNonNumeric(args), args, Types.NUMBER);
                }
                return context.withResult(20L, result);
            }
        });
        ABS = Core.reg(new CoreFn<APrimitive>(Symbols.ABS){

            @Override
            public Context<APrimitive> invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                APrimitive result = RT.abs(args[0]);
                if (result == null) {
                    return context.withCastError(RT.findNonNumeric(args), args, Types.NUMBER);
                }
                return context.withResult(20L, result);
            }
        });
        SIGNUM = Core.reg(new CoreFn<CVMLong>(Symbols.SIGNUM){

            @Override
            public Context<CVMLong> invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                ACell result = RT.signum(args[0]);
                if (result == null) {
                    return context.withCastError(args[0], (AType)Types.NUMBER);
                }
                return context.withResult(20L, result);
            }
        });
        MOD = Core.reg(new CoreFn<CVMLong>(Symbols.MOD){

            @Override
            public Context<CVMLong> invoke(Context context, ACell[] args) {
                if (args.length != 2) {
                    return context.withArityError(this.exactArityMessage(2, args.length));
                }
                CVMLong la = RT.ensureLong(args[0]);
                CVMLong lb = RT.ensureLong(args[1]);
                if (lb == null || la == null) {
                    return context.withCastError(Types.LONG);
                }
                long num = la.longValue();
                long denom = lb.longValue();
                if (denom == 0L) {
                    return context.withArgumentError("Divsion by zero in " + this.name());
                }
                long m = num % denom;
                if (m < 0L) {
                    m += Math.abs(denom);
                }
                CVMLong result = CVMLong.create(m);
                return context.withResult(20L, result);
            }
        });
        REM = Core.reg(new CoreFn<CVMLong>(Symbols.REM){

            @Override
            public Context<CVMLong> invoke(Context context, ACell[] args) {
                if (args.length != 2) {
                    return context.withArityError(this.exactArityMessage(2, args.length));
                }
                CVMLong la = RT.ensureLong(args[0]);
                CVMLong lb = RT.ensureLong(args[1]);
                if (lb == null || la == null) {
                    return context.withCastError(Types.LONG);
                }
                long num = la.longValue();
                long denom = lb.longValue();
                if (denom == 0L) {
                    return context.withArgumentError("Divsion by zero in " + this.name());
                }
                long m = num % denom;
                CVMLong result = CVMLong.create(m);
                return context.withResult(20L, result);
            }
        });
        QUOT = Core.reg(new CoreFn<CVMLong>(Symbols.QUOT){

            @Override
            public Context<CVMLong> invoke(Context context, ACell[] args) {
                if (args.length != 2) {
                    return context.withArityError(this.exactArityMessage(2, args.length));
                }
                CVMLong la = RT.ensureLong(args[0]);
                CVMLong lb = RT.ensureLong(args[1]);
                if (lb == null || la == null) {
                    return context.withCastError(Types.LONG);
                }
                long num = la.longValue();
                long denom = lb.longValue();
                if (denom == 0L) {
                    return context.withArgumentError("Divsion by zero in " + this.name());
                }
                long m = num / denom;
                CVMLong result = CVMLong.create(m);
                return context.withResult(20L, result);
            }
        });
        POW = Core.reg(new CoreFn<CVMDouble>(Symbols.POW){

            @Override
            public Context<CVMDouble> invoke(Context context, ACell[] args) {
                if (args.length != 2) {
                    return context.withArityError(this.exactArityMessage(2, args.length));
                }
                CVMDouble result = RT.pow(args);
                if (result == null) {
                    return context.withCastError(Types.DOUBLE);
                }
                return context.withResult(20L, result);
            }
        });
        EXP = Core.reg(new CoreFn<CVMDouble>(Symbols.EXP){

            @Override
            public Context<CVMDouble> invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                CVMDouble result = RT.exp(args[0]);
                if (result == null) {
                    return context.withCastError(0, (AType)Types.DOUBLE);
                }
                return context.withResult(20L, result);
            }
        });
        NOT = Core.reg(new CoreFn<CVMBool>(Symbols.NOT){

            @Override
            public Context<CVMBool> invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                CVMBool result = CVMBool.of(!RT.bool(args[0]));
                return context.withResult(20L, result);
            }
        });
        HASH = Core.reg(new CoreFn<Hash>(Symbols.HASH){

            @Override
            public Context<Hash> invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                ABlob blob = RT.ensureBlob(args[0]);
                if (blob == null) {
                    return context.withCastError(0, args, Types.BLOB);
                }
                Hash result = blob.getContentHash();
                return context.withResult(10000L, result);
            }
        });
        COUNT = Core.reg(new CoreFn<CVMLong>(Symbols.COUNT){

            @Override
            public Context<CVMLong> invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                Long result = RT.count(args[0]);
                if (result == null) {
                    return context.withCastError(0, args, Types.DATA_STRUCTURE);
                }
                return context.withResult(20L, CVMLong.create(result));
            }
        });
        EMPTY = Core.reg(new CoreFn<ACell>(Symbols.EMPTY){

            @Override
            public Context<ACell> invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                ACell o = args[0];
                if (o == null) {
                    return context.withResult(20L, null);
                }
                ADataStructure coll = RT.ensureDataStructure(o);
                if (coll == null) {
                    return context.withCastError(0, args, Types.DATA_STRUCTURE);
                }
                ADataStructure result = coll.empty();
                return context.withResult(20L, result);
            }
        });
        NTH = Core.reg(new CoreFn<ACell>(Symbols.NTH){

            @Override
            public Context<ACell> invoke(Context context, ACell[] args) {
                if (args.length != 2) {
                    return context.withArityError(this.exactArityMessage(2, args.length));
                }
                ACell arg = args[0];
                Long n = RT.count(arg);
                if (n == null) {
                    return context.withCastError(arg, (AType)Types.SEQUENCE);
                }
                CVMLong ix = RT.ensureLong(args[1]);
                if (ix == null) {
                    return context.withCastError(1, args, Types.LONG);
                }
                long i = ix.longValue();
                if (i < 0L || i >= n) {
                    return context.withBoundsError(i);
                }
                Object result = RT.nth(arg, i);
                return context.withResult(20L, result);
            }
        });
        NEXT = Core.reg(new CoreFn<ASequence<ACell>>(Symbols.NEXT){

            @Override
            public Context<ASequence<ACell>> invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                ASequence seq = RT.sequence(args[0]);
                if (seq == null) {
                    return context.withCastError(0, args, Types.SEQUENCE);
                }
                ASequence result = seq.next();
                return context.withResult(20L, result);
            }
        });
        RECUR = Core.reg(new CoreFn<ACell>(Symbols.RECUR){

            @Override
            public Context<ACell> invoke(Context context, ACell[] args) {
                RecurValue result = RecurValue.wrap(args);
                return context.withException(30L, result);
            }
        });
        TAILCALL_STAR = Core.reg(new CoreFn<ACell>(Symbols.TAILCALL_STAR){

            @Override
            public Context<ACell> invoke(Context context, ACell[] args) {
                int n = args.length;
                if (n < 1) {
                    return context.withArityError(this.minArityMessage(1, n));
                }
                AFn f = RT.ensureFunction(args[0]);
                if (f == null) {
                    return context.withCastError(0, args, Types.FUNCTION);
                }
                ACell[] tailArgs = Arrays.copyOfRange(args, 1, args.length);
                TailcallValue result = TailcallValue.wrap(f, tailArgs);
                return context.withException(30L, result);
            }
        });
        ROLLBACK = Core.reg(new CoreFn<ACell>(Symbols.ROLLBACK){

            @Override
            public Context<ACell> invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                RollbackValue<ACell> result = RollbackValue.wrap(args[0]);
                return context.withException(50L, result);
            }
        });
        HALT = Core.reg(new CoreFn<ACell>(Symbols.HALT){

            @Override
            public Context<ACell> invoke(Context context, ACell[] args) {
                int n = args.length;
                if (n > 1) {
                    return context.withArityError(this.maxArityMessage(1, n));
                }
                HaltValue<Object> result = HaltValue.wrap(n > 0 ? args[0] : null);
                return context.withException(50L, result);
            }
        });
        RETURN = Core.reg(new CoreFn<ACell>(Symbols.RETURN){

            @Override
            public Context<ACell> invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                ReturnValue<ACell> result = ReturnValue.wrap(args[0]);
                return context.withException(50L, result);
            }
        });
        FAIL = Core.reg(new CoreFn<CVMBool>(Symbols.FAIL){

            @Override
            public Context<CVMBool> invoke(Context context, ACell[] args) {
                Keyword code;
                int alen = args.length;
                if (alen > 2) {
                    return context.withArityError(this.maxArityMessage(2, alen));
                }
                ACell aCell = code = alen == 2 ? args[0] : ErrorCodes.ASSERT;
                if (code == null) {
                    return context.withError(ErrorCodes.ARGUMENT, "Error code cannot be nil");
                }
                ACell message = alen > 0 ? args[alen - 1] : null;
                ErrorValue error = ErrorValue.createRaw(code, message);
                return context.withError(error);
            }
        });
        APPLY = Core.reg(new CoreFn<ACell>(Symbols.APPLY){

            @Override
            public Context<ACell> invoke(Context context, ACell[] args) {
                ACell[] applyArgs;
                int alen = args.length;
                if (alen < 2) {
                    return context.withArityError(this.minArityMessage(2, alen));
                }
                AFn fn = RT.castFunction(args[0]);
                if (fn == null) {
                    return context.withCastError(0, args, Types.FUNCTION);
                }
                int lastIndex = alen - 1;
                ACell lastArg = args[lastIndex];
                ASequence coll = RT.ensureSequence(lastArg);
                if (coll == null) {
                    return context.withCastError(lastIndex, args, Types.SEQUENCE);
                }
                int vlen = coll.size();
                int n = alen - 2 + vlen;
                if (alen > 2) {
                    applyArgs = new ACell[n];
                    for (int i = 0; i < alen - 2; ++i) {
                        applyArgs[i] = args[i + 1];
                    }
                    int ix = alen - 2;
                    Iterator it = coll.iterator();
                    while (it.hasNext()) {
                        applyArgs[ix++] = (ACell)it.next();
                    }
                } else {
                    applyArgs = coll.toCellArray();
                }
                Context rctx = context.invoke(fn, applyArgs);
                return rctx.consumeJuice(50L);
            }
        });
        INTO = Core.reg(new CoreFn<ADataStructure<ACell>>(Symbols.INTO){

            @Override
            public Context<ADataStructure<ACell>> invoke(Context context, ACell[] args) {
                if (args.length != 2) {
                    return context.withArityError(this.exactArityMessage(2, args.length));
                }
                ACell a0 = args[0];
                ADataStructure<Object> result = RT.ensureDataStructure(a0);
                if (a0 != null && result == null) {
                    return context.withCastError(0, args, Types.DATA_STRUCTURE);
                }
                long juice = 50L;
                ACell a1 = args[1];
                if (a0 == null) {
                    result = RT.ensureDataStructure(a1);
                    if (a1 != null && result == null) {
                        return context.withCastError(a1, (AType)Types.DATA_STRUCTURE);
                    }
                } else {
                    Long n = RT.count(a1);
                    if (n == null) {
                        return context.withCastError(a1, (AType)Types.DATA_STRUCTURE);
                    }
                    if (!context.checkJuice(juice += 50L * n)) {
                        return context.withJuiceError();
                    }
                    ASequence seq = RT.sequence(a1);
                    if (seq == null) {
                        return context.withCastError(a1, (AType)Types.DATA_STRUCTURE);
                    }
                    if ((result = result.conjAll(seq)) == null) {
                        return context.withError(ErrorCodes.ARGUMENT, "Invalid element type for 'into'");
                    }
                }
                return context.withResult(juice, result);
            }
        });
        MERGE = Core.reg(new CoreFn<AHashMap<ACell, ACell>>(Symbols.MERGE){

            @Override
            public Context<AHashMap<ACell, ACell>> invoke(Context context, ACell[] args) {
                int n = args.length;
                if (n == 0) {
                    return context.withResult(50L, Maps.empty());
                }
                ACell arg0 = args[0];
                AHashMap result = RT.ensureHashMap(arg0);
                if (result == null) {
                    return context.withCastError(arg0, (AType)Types.MAP);
                }
                long juice = 50L;
                for (int i = 1; i < n; ++i) {
                    ACell argi = args[i];
                    AHashMap argMap = RT.ensureHashMap(argi);
                    if (argMap == null) {
                        return context.withCastError(argi, (AType)Types.MAP);
                    }
                    long size = argMap.count();
                    if (!context.checkJuice(juice = Juice.addMul(juice, size, 50L))) {
                        return context.withJuiceError();
                    }
                    result = result.merge(argMap);
                }
                return context.withResult(juice, result);
            }
        });
        MAP = Core.reg(new CoreFn<ASequence<?>>(Symbols.MAP){

            @Override
            public Context<ASequence<?>> invoke(Context context, ACell[] args) {
                if (args.length < 2) {
                    return context.withArityError(this.minArityMessage(2, args.length));
                }
                ACell fnArg = args[0];
                AFn f = RT.castFunction(fnArg);
                if (f == null) {
                    return context.withCastError(fnArg, (AType)Types.FUNCTION);
                }
                int fnArity = args.length - 1;
                ACell[] xs = new ACell[fnArity];
                ASequence[] seqs = new ASequence[fnArity];
                int length = Integer.MAX_VALUE;
                for (int i = 0; i < fnArity; ++i) {
                    ACell maybeSeq = args[1 + i];
                    ASequence seq = RT.sequence(maybeSeq);
                    if (seq == null) {
                        return context.withCastError(maybeSeq, (AType)Types.SEQUENCE);
                    }
                    seqs[i] = seq;
                    length = Math.min(length, seq.size());
                }
                long juice = Juice.addMul(100L, 50L, length);
                if (!context.checkJuice(juice)) {
                    return context.withJuiceError();
                }
                ArrayList al = new ArrayList();
                for (int i = 0; i < length; ++i) {
                    for (int j = 0; j < fnArity; ++j) {
                        xs[j] = seqs[j].get(i);
                    }
                    if ((context = context.invoke(f, xs)).isExceptional()) {
                        return context;
                    }
                    ASequence<?> r = context.getResult();
                    al.add(r);
                }
                AVector result = Vectors.create(al);
                return context.withResult(juice, result);
            }
        });
        REDUCE = Core.reg(new CoreFn<ACell>(Symbols.REDUCE){

            @Override
            public Context<ACell> invoke(Context ctx, ACell[] args) {
                ACell result;
                ADataStructure seq;
                int ac = args.length;
                if (ac < 2 || ac > 3) {
                    return ctx.withArityError(this.exactArityMessage(3, ac));
                }
                ACell fnArg = args[0];
                AFn fn = RT.castFunction(fnArg);
                if (fn == null) {
                    return ctx.withCastError(0, args, Types.FUNCTION);
                }
                ACell maybeSeq = args[ac - 1];
                ADataStructure aDataStructure = seq = maybeSeq == null ? Vectors.empty() : RT.ensureDataStructure(maybeSeq);
                if (seq == null) {
                    return ctx.withCastError(ac - 1, args, Types.SEQUENCE);
                }
                long n = seq.count();
                long start = 0L;
                if (ac == 3) {
                    result = args[1];
                } else {
                    int initial = (int)Math.min(2L, n);
                    if (initial == 0) {
                        return Core.reduceResult(ctx.invoke(fn, ACell.EMPTY_ARRAY));
                    }
                    if (initial == 1) {
                        return Core.reduceResult(ctx.invoke(fn, new ACell[]{seq.get(0L)}));
                    }
                    result = seq.get(0L);
                    start = 1L;
                }
                ACell[] xs = new ACell[2];
                for (long i = start; i < n; ++i) {
                    xs[0] = result;
                    xs[1] = seq.get(i);
                    if ((ctx = ctx.invoke(fn, xs)).isExceptional()) {
                        return Core.reduceResult(ctx);
                    }
                    result = ctx.getResult();
                }
                return ctx.withResult(100L, result);
            }
        });
        REDUCED = Core.reg(new CoreFn<ACell>(Symbols.REDUCED){

            @Override
            public Context<ACell> invoke(Context context, ACell[] args) {
                if (args.length != 1) {
                    return context.withArityError(this.exactArityMessage(1, args.length));
                }
                Reduced result = Reduced.wrap(args[0]);
                return context.withException(50L, result);
            }
        });
        NIL_Q = Core.reg(new CorePred(Symbols.NIL_Q){

            @Override
            public boolean test(ACell val) {
                return val == null;
            }
        });
        VECTOR_Q = Core.reg(new CorePred(Symbols.VECTOR_Q){

            @Override
            public boolean test(ACell val) {
                return val instanceof AVector;
            }
        });
        LIST_Q = Core.reg(new CorePred(Symbols.LIST_Q){

            @Override
            public boolean test(ACell val) {
                return val instanceof AList;
            }
        });
        SET_Q = Core.reg(new CorePred(Symbols.SET_Q){

            @Override
            public boolean test(ACell val) {
                return val instanceof ASet;
            }
        });
        MAP_Q = Core.reg(new CorePred(Symbols.MAP_Q){

            @Override
            public boolean test(ACell val) {
                return val instanceof AMap;
            }
        });
        COLL_Q = Core.reg(new CorePred(Symbols.COLL_Q){

            @Override
            public boolean test(ACell val) {
                return val instanceof ADataStructure;
            }
        });
        EMPTY_Q = Core.reg(new CorePred(Symbols.EMPTY_Q){

            @Override
            public boolean test(ACell val) {
                if (val == null) {
                    return true;
                }
                return val instanceof ADataStructure && ((ADataStructure)val).isEmpty();
            }
        });
        SYMBOL_Q = Core.reg(new CorePred(Symbols.SYMBOL_Q){

            @Override
            public boolean test(ACell val) {
                return val instanceof Symbol;
            }
        });
        KEYWORD_Q = Core.reg(new CorePred(Symbols.KEYWORD_Q){

            @Override
            public boolean test(ACell val) {
                return val instanceof Keyword;
            }
        });
        BLOB_Q = Core.reg(new CorePred(Symbols.BLOB_Q){

            @Override
            public boolean test(ACell val) {
                if (!(val instanceof ABlob)) {
                    return false;
                }
                return ((ABlob)val).isRegularBlob();
            }
        });
        ADDRESS_Q = Core.reg(new CorePred(Symbols.ADDRESS_Q){

            @Override
            public boolean test(ACell val) {
                return val instanceof Address;
            }
        });
        LONG_Q = Core.reg(new CorePred(Symbols.LONG_Q){

            @Override
            public boolean test(ACell val) {
                return val instanceof CVMLong;
            }
        });
        STR_Q = Core.reg(new CorePred(Symbols.STR_Q){

            @Override
            public boolean test(ACell val) {
                return val instanceof AString;
            }
        });
        NUMBER_Q = Core.reg(new CorePred(Symbols.NUMBER_Q){

            @Override
            public boolean test(ACell val) {
                return RT.isNumber(val);
            }
        });
        NAN_Q = Core.reg(new CorePred(Symbols.NAN_Q){

            @Override
            public boolean test(ACell val) {
                return RT.isNaN(val);
            }
        });
        FN_Q = Core.reg(new CorePred(Symbols.FN_Q){

            @Override
            public boolean test(ACell val) {
                return val instanceof AFn;
            }
        });
        ZERO_Q = Core.reg(new CorePred(Symbols.ZERO_Q){

            @Override
            public boolean test(ACell val) {
                if (!RT.isNumber(val)) {
                    return false;
                }
                INumeric n = RT.ensureNumber(val);
                return n.doubleValue() == 0.0;
            }
        });
        Object coreEnv = Maps.empty();
        Object coreMeta = Maps.empty();
        try {
            for (ACell o : tempReg) {
                coreEnv = Core.register(coreEnv, o);
            }
            Context<?> ctx = Core.registerCoreCode(coreEnv);
            ctx = Core.applyDocumentation(ctx);
            coreEnv = ctx.getEnvironment();
            coreMeta = ctx.getMetadata();
            METADATA = coreMeta;
            ENVIRONMENT = coreEnv;
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new Error("Error initialising core!", e);
        }
    }
}

