/*
 * Decompiled with CFR 0.152.
 */
package convex.gui.components;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.util.function.Function;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.Scrollable;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ScrollyList<E>
extends JScrollPane {
    private final Function<E, Component> builder;
    private final ListModel<E> model;
    private final ScrollablePanel listPanel = new ScrollablePanel();

    private void refreshList() {
        this.listPanel.removeAll();
        int n = this.model.getSize();
        for (int i = 0; i < n; ++i) {
            E we = this.model.getElementAt(i);
            this.listPanel.add(this.builder.apply(we));
        }
        this.revalidate();
    }

    public ScrollyList(ListModel<E> model, Function<E, Component> builder) {
        this.builder = builder;
        this.model = model;
        this.setHorizontalScrollBarPolicy(31);
        this.listPanel.setLayout(new GridLayout(0, 1));
        this.setViewportView(this.listPanel);
        this.getViewport().setBackground(null);
        model.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                ScrollyList.this.refreshList();
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                ScrollyList.this.refreshList();
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                ScrollyList.this.refreshList();
            }
        });
        this.refreshList();
    }

    private static class ScrollablePanel
    extends JPanel
    implements Scrollable {
        private ScrollablePanel() {
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return new Dimension(800, 600);
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 60;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 180;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }
    }
}

