/*
 * Decompiled with CFR 0.152.
 */
package convex.core;

import convex.core.Block;
import convex.core.Constants;
import convex.core.MergeContext;
import convex.core.Order;
import convex.core.State;
import convex.core.crypto.AKeyPair;
import convex.core.data.ABlob;
import convex.core.data.ACell;
import convex.core.data.AMap;
import convex.core.data.ARecord;
import convex.core.data.AVector;
import convex.core.data.AccountKey;
import convex.core.data.BlobMap;
import convex.core.data.BlobMaps;
import convex.core.data.Format;
import convex.core.data.Hash;
import convex.core.data.Keyword;
import convex.core.data.Keywords;
import convex.core.data.MapEntry;
import convex.core.data.PeerStatus;
import convex.core.data.SignedData;
import convex.core.data.prim.CVMLong;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.BadSignatureException;
import convex.core.exceptions.InvalidDataException;
import convex.core.lang.impl.RecordFormat;
import convex.core.util.Counters;
import convex.core.util.Utils;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Map;
import java.util.function.Function;

public class Belief
extends ARecord {
    private static final RecordFormat BELIEF_KEYS = RecordFormat.of(Keywords.ORDERS, Keywords.TIMESTAMP);
    private final BlobMap<AccountKey, SignedData<Order>> orders;
    private final long timestamp;

    private Belief(BlobMap<AccountKey, SignedData<Order>> orders, long timestamp) {
        super(BELIEF_KEYS);
        this.orders = orders;
        this.timestamp = timestamp;
    }

    @Override
    public ACell get(ACell k) {
        if (Keywords.ORDERS.equals(k)) {
            return this.orders;
        }
        if (Keywords.TIMESTAMP.equals(k)) {
            return CVMLong.create(this.timestamp);
        }
        return null;
    }

    @Override
    protected Belief updateAll(ACell[] newVals) {
        BlobMap newOrders = (BlobMap)newVals[0];
        long newTimestamp = ((CVMLong)newVals[1]).longValue();
        if (this.orders == newOrders && this.timestamp == newTimestamp) {
            return this;
        }
        return new Belief(newOrders, newTimestamp);
    }

    public static Belief initial() {
        return Belief.create((BlobMap)BlobMaps.empty());
    }

    public static Belief create(AKeyPair kp, Order order) {
        BlobMap<AccountKey, SignedData<Order>> orders = BlobMap.of(kp.getAccountKey(), kp.signData(order));
        return Belief.create(orders);
    }

    private static Belief create(BlobMap<AccountKey, SignedData<Order>> orders, long timestamp) {
        return new Belief(orders, timestamp);
    }

    private static Belief create(BlobMap<AccountKey, SignedData<Order>> orders) {
        return Belief.create(orders, Constants.INITIAL_TIMESTAMP);
    }

    public static Belief createSingleOrder(AKeyPair kp) {
        AccountKey address = kp.getAccountKey();
        SignedData<Order> order = kp.signData(Order.create());
        return Belief.create(BlobMap.of(address, order));
    }

    public Belief merge(MergeContext mc, Belief ... beliefs) throws BadSignatureException, InvalidDataException {
        Belief newBelief = this.mergeOnce(mc, beliefs);
        if (this != newBelief) {
            newBelief = newBelief.mergeOnce(mc, new Belief[0]);
        }
        return newBelief;
    }

    Belief mergeOnce(MergeContext mc, Belief ... beliefs) throws BadSignatureException, InvalidDataException {
        ++Counters.beliefMerge;
        BlobMap<AccountKey, SignedData<Order>> accOrders = this.accumulateOrders(mc, beliefs);
        BlobMap<AccountKey, SignedData<Order>> resultOrders = this.vote(mc, accOrders);
        if (resultOrders == null) {
            return this;
        }
        long newTimestamp = mc.getTimeStamp();
        if (this.orders == resultOrders && this.timestamp == newTimestamp) {
            return this;
        }
        Belief result = new Belief(resultOrders, newTimestamp);
        return result;
    }

    private BlobMap<AccountKey, SignedData<Order>> accumulateOrders(MergeContext mc, Belief[] beliefs) {
        AMap result = this.orders;
        for (Belief belief : beliefs) {
            if (belief == null || belief.equals(this)) continue;
            BlobMap<AccountKey, SignedData<Order>> bOrders = belief.orders;
            long bcount = bOrders.count();
            for (long i = 0L; i < bcount; ++i) {
                MapEntry<AccountKey, SignedData<Order>> be = bOrders.entryAt(i);
                ABlob key = (ABlob)be.getKey();
                if (key.equalsBytes(mc.getAccountKey())) continue;
                SignedData<Order> a = ((BlobMap)result).get(key);
                if (a == null) {
                    result = ((BlobMap)result).assocEntry((MapEntry)be);
                    continue;
                }
                SignedData b = (SignedData)be.getValue();
                if (b == null || !b.checkSignature() || a.equals(b)) continue;
                Order ac = a.getValue();
                Order bc = (Order)b.getValue();
                if (bc.getConsensusPoint() > ac.getConsensusPoint()) {
                    result = ((BlobMap)result).assocEntry((MapEntry)be);
                    continue;
                }
                if (bc.getBlockCount() > ac.getBlockCount()) {
                    result = ((BlobMap)result).assocEntry((MapEntry)be);
                    continue;
                }
                if (bc.getProposalPoint() <= ac.getProposalPoint()) continue;
                result = ((BlobMap)result).assocEntry((MapEntry)be);
            }
        }
        return result;
    }

    private BlobMap<AccountKey, SignedData<Order>> vote(MergeContext mc, BlobMap<AccountKey, SignedData<Order>> accOrders) throws BadSignatureException {
        double consideredStake;
        AccountKey myAddress = mc.getAccountKey();
        Order myOrder = this.getMyOrder(mc);
        assert (myOrder != null);
        State votingState = mc.getConsensusState();
        AMap filteredOrders = accOrders.filterValues((T signedOrder) -> {
            try {
                Order otherOrder = (Order)signedOrder.getValue();
                return myOrder.checkConsistent(otherOrder);
            }
            catch (Exception e) {
                throw (RuntimeException)Utils.sneakyThrow(e);
            }
        });
        long consensusPoint = myOrder.getConsensusPoint();
        BlobMap<AccountKey, PeerStatus> peers = votingState.getPeers();
        HashMap<AccountKey, Double> weightedStakes = votingState.computeStakes();
        double totalStake = weightedStakes.get(null);
        HashMap<Order, Double> stakedOrders = new HashMap<Order, Double>(peers.size());
        AVector<Block> winningBlocks = Belief.computeWinningOrder(stakedOrders, consensusPoint, consideredStake = Belief.prepareStakedOrders(filteredOrders, weightedStakes, stakedOrders));
        if (winningBlocks == null) {
            return null;
        }
        Order winningOrder = myOrder.updateBlocks(winningBlocks);
        double P_THRESHOLD = totalStake * 0.5;
        Order proposedOrder = this.updateProposal(winningOrder, stakedOrders, P_THRESHOLD);
        assert (proposedOrder != null);
        double C_THRESHOLD = totalStake * 0.67;
        Order consensusOrder = this.updateConsensus(proposedOrder, stakedOrders, C_THRESHOLD);
        AMap resultOrders = filteredOrders;
        if (!consensusOrder.equals(myOrder)) {
            SignedData<Order> signedOrder2 = mc.sign(consensusOrder);
            resultOrders = ((BlobMap)resultOrders).assoc(myAddress, signedOrder2);
        }
        return resultOrders;
    }

    private Order updateConsensus(final Order proposedOrder, HashMap<Order, Double> stakedOrders, double THRESHOLD) {
        Order c;
        Double chainStake;
        int i;
        final AVector<Block> proposedBlocks = proposedOrder.getBlocks();
        ArrayList<Order> agreedChains = Utils.sortListBy(new Function<Order, Long>(){

            @Override
            public Long apply(Order c) {
                long minProposal;
                long blockMatch = proposedBlocks.commonPrefixLength(c.getBlocks());
                long match = Math.min(blockMatch, minProposal = Math.min(proposedOrder.getProposalPoint(), c.getProposalPoint()));
                if (match <= proposedOrder.getConsensusPoint()) {
                    return null;
                }
                return -match;
            }
        }, stakedOrders.keySet());
        int numAgreed = agreedChains.size();
        double accumulatedStake = 0.0;
        for (i = 0; i < numAgreed && !((accumulatedStake += (chainStake = stakedOrders.get(c = agreedChains.get(i))).doubleValue()) > THRESHOLD); ++i) {
        }
        if (i < numAgreed) {
            long proposalMatch;
            Order lastAgreed = agreedChains.get(i);
            long prefixMatch = proposedOrder.getBlocks().commonPrefixLength(lastAgreed.getBlocks());
            long newConsensusPoint = Math.min(prefixMatch, proposalMatch = Math.min(proposedOrder.getProposalPoint(), lastAgreed.getProposalPoint()));
            if (newConsensusPoint < proposedOrder.getConsensusPoint()) {
                throw new Error("Consensus going backwards! prefix=" + prefixMatch + " propsalmatch=" + proposalMatch);
            }
            return proposedOrder.withConsenusPoint(newConsensusPoint);
        }
        return proposedOrder;
    }

    private Order updateProposal(Order winningOrder, HashMap<Order, Double> stakedOrders, double THRESHOLD) {
        Order c;
        double orderStake;
        int i;
        AVector<Block> winningBlocks = winningOrder.getBlocks();
        ArrayList<Order> agreedOrders = this.sortByAgreement(stakedOrders, winningBlocks);
        int numAgreed = agreedOrders.size();
        double accumulatedStake = 0.0;
        for (i = 0; i < numAgreed && !((accumulatedStake += (orderStake = stakedOrders.get(c = agreedOrders.get(i)).doubleValue())) > THRESHOLD); ++i) {
        }
        if (i < numAgreed) {
            Order lastAgreed = agreedOrders.get(i);
            AVector<Block> lastBlocks = lastAgreed.getBlocks();
            long newProposalPoint = winningBlocks.commonPrefixLength(lastBlocks);
            return winningOrder.withProposalPoint(newProposalPoint);
        }
        return winningOrder;
    }

    private ArrayList<Order> sortByAgreement(HashMap<Order, ?> stakedOrders, final AVector<Block> winningBlocks) {
        return Utils.sortListBy(new Function<Order, Long>(){

            @Override
            public Long apply(Order c) {
                long match = winningBlocks.commonPrefixLength(c.getBlocks());
                return -match;
            }
        }, stakedOrders.keySet());
    }

    private static ArrayList<Block> collectNewBlocks(Collection<AVector<Block>> orders, long consensusPoint) {
        HashSet<Block> newBlocks = new HashSet<Block>();
        ArrayList<Block> newBlocksOrdered = new ArrayList<Block>();
        for (AVector<Block> blks : orders) {
            if (blks.count() <= consensusPoint) continue;
            ListIterator<Block> it = blks.listIterator(consensusPoint);
            while (it.hasNext()) {
                Block b = (Block)it.next();
                if (newBlocks.contains(b)) continue;
                newBlocks.add(b);
                newBlocksOrdered.add(b);
            }
        }
        return newBlocksOrdered;
    }

    public static AVector<Block> computeWinningOrder(HashMap<Order, Double> stakedOrders, long consensusPoint, double initialTotalStake) {
        assert (!stakedOrders.isEmpty());
        HashMap votingSet = Belief.combineToBlocks(stakedOrders);
        ArrayList<Block> newBlocksOrdered = Belief.collectNewBlocks(votingSet.keySet(), consensusPoint);
        double totalStake = initialTotalStake;
        long point = consensusPoint;
        block0: while (votingSet.size() > 1) {
            HashMap blockVotes = new HashMap();
            for (Map.Entry<AVector<Block>, Double> me : votingSet.entrySet()) {
                AVector<Block> blocks = me.getKey();
                long cCount = blocks.count();
                if (cCount <= point) continue;
                Block b = blocks.get(point);
                HashMap<AVector<Block>, Double> agreedOrders = (HashMap<AVector<Block>, Double>)blockVotes.get(b);
                if (agreedOrders == null) {
                    agreedOrders = new HashMap<AVector<Block>, Double>();
                    blockVotes.put(b, agreedOrders);
                }
                Double stake = me.getValue();
                agreedOrders.put(blocks, stake);
                if (!(stake >= totalStake * 0.5)) continue;
                votingSet.clear();
                votingSet.put(blocks, stake);
                break block0;
            }
            if (blockVotes.size() == 0) break;
            Map.Entry winningResult = null;
            double winningVote = Double.NEGATIVE_INFINITY;
            for (Map.Entry me : blockVotes.entrySet()) {
                HashMap agreedChains = (HashMap)me.getValue();
                double blockVote = Belief.computeVote(agreedChains);
                if (!(blockVote > winningVote)) continue;
                winningVote = blockVote;
                winningResult = me;
            }
            if (winningResult == null) {
                throw new Error("This shouldn't happen!");
            }
            votingSet = (HashMap)winningResult.getValue();
            totalStake = winningVote;
            ++point;
        }
        if (votingSet.size() == 0) {
            return null;
        }
        AVector<Block> winningBlocks = votingSet.keySet().iterator().next();
        AVector<Block> fullWinningBlocks = Belief.appendNewBlocks(winningBlocks, newBlocksOrdered, consensusPoint);
        return fullWinningBlocks;
    }

    private static final AVector<Block> appendNewBlocks(AVector<Block> blocks, ArrayList<Block> newBlocksOrdered, long consensusPoint) {
        HashSet<Block> newBlocks = new HashSet<Block>();
        newBlocks.addAll(newBlocksOrdered);
        ListIterator<Block> it = blocks.listIterator(Math.min(blocks.count(), consensusPoint));
        while (it.hasNext()) {
            newBlocks.remove(it.next());
        }
        newBlocksOrdered.removeIf(b -> !newBlocks.contains(b));
        newBlocksOrdered.sort(Block.TIMESTAMP_COMPARATOR);
        AVector<Block> fullBlocks = blocks.appendAll(newBlocksOrdered);
        return fullBlocks;
    }

    private static HashMap<AVector<Block>, Double> combineToBlocks(HashMap<Order, Double> stakedOrders) {
        HashMap<AVector<Block>, Double> result = new HashMap<AVector<Block>, Double>();
        for (Map.Entry<Order, Double> e : stakedOrders.entrySet()) {
            Order c = e.getKey();
            Double stake = e.getValue();
            AVector<Block> blocks = c.getBlocks();
            Double acc = result.get(blocks);
            if (acc == null) {
                result.put(blocks, stake);
                continue;
            }
            result.put(blocks, acc + stake);
        }
        return result;
    }

    public static <V> double computeVote(HashMap<V, Double> m) {
        double result = 0.0;
        for (Map.Entry<V, Double> me : m.entrySet()) {
            result += me.getValue().doubleValue();
        }
        return result;
    }

    public static double prepareStakedOrders(AMap<AccountKey, SignedData<Order>> peerOrders, HashMap<AccountKey, Double> peerStakes, HashMap<Order, Double> dest) {
        return peerOrders.reduceValues((? super R acc, ? super V signedOrder) -> {
            try {
                Order order = (Order)signedOrder.getValue();
                AccountKey cAddress = signedOrder.getAccountKey();
                Double cStake = (Double)peerStakes.get(cAddress);
                if (cStake == null || cStake == 0.0) {
                    return acc;
                }
                Double stake = (Double)dest.get(order);
                if (stake == null) {
                    dest.put(order, cStake);
                } else {
                    dest.put(order, stake + cStake);
                }
                return acc + cStake;
            }
            catch (Exception e) {
                throw (RuntimeException)Utils.sneakyThrow(e);
            }
        }, 0.0);
    }

    private Order getMyOrder(MergeContext mc) throws BadSignatureException {
        AccountKey myAddress = mc.getAccountKey();
        SignedData<Order> signed = this.orders.get(myAddress);
        if (signed == null) {
            return null;
        }
        assert (signed.getAccountKey().equals(myAddress));
        return signed.getValue();
    }

    public Belief withOrders(BlobMap<AccountKey, SignedData<Order>> newOrders) {
        if (newOrders == this.orders) {
            return this;
        }
        return Belief.create(newOrders);
    }

    @Override
    public int encode(byte[] bs, int pos) {
        bs[pos++] = this.getTag();
        return this.encodeRaw(bs, pos);
    }

    @Override
    public int estimatedEncodingSize() {
        return 1 + this.orders.estimatedEncodingSize() + 12;
    }

    public static Belief read(ByteBuffer bb) throws BadFormatException {
        BlobMap chains = (BlobMap)Format.read(bb);
        if (chains == null) {
            throw new BadFormatException("Null orders in Belief");
        }
        CVMLong timestamp = (CVMLong)Format.read(bb);
        if (timestamp == null) {
            throw new BadFormatException("Null timestamp");
        }
        return new Belief(chains, timestamp.longValue());
    }

    @Override
    public byte getTag() {
        return -86;
    }

    public Order getOrder(AccountKey address) {
        SignedData<Order> sc = this.orders.get(address);
        if (sc == null) {
            return null;
        }
        return sc.getValue();
    }

    public BlobMap<AccountKey, SignedData<Order>> getOrders() {
        return this.orders;
    }

    @Override
    public void validateCell() throws InvalidDataException {
        if (this.orders == null) {
            throw new InvalidDataException("Null orders", this);
        }
        this.orders.validateCell();
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public boolean equals(AMap<Keyword, ACell> a) {
        if (this == a) {
            return true;
        }
        if (a == null) {
            return false;
        }
        if (a.getTag() != this.getTag()) {
            return false;
        }
        Belief as = (Belief)a;
        return this.equals(as);
    }

    public boolean equals(Belief a) {
        Hash ha;
        if (a == null) {
            return false;
        }
        Hash h = this.cachedHash();
        if (h != null && (ha = a.cachedHash()) != null) {
            return Utils.equals(h, ha);
        }
        if (this.timestamp != a.timestamp) {
            return false;
        }
        return Utils.equals(this.orders, a.orders);
    }
}

