/*
 * Decompiled with CFR 0.152.
 */
package convex.cli;

import convex.cli.Helpers;
import convex.cli.Main;
import convex.cli.Peer;
import convex.cli.peer.PeerManager;
import convex.cli.peer.SessionItem;
import convex.core.crypto.AKeyPair;
import convex.core.data.Address;
import convex.core.store.AStore;
import convex.core.store.Stores;
import etch.EtchStore;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="start", aliases={"st"}, mixinStandardHelpOptions=true, description={"Starts a local peer."})
public class PeerStart
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(PeerStart.class);
    @CommandLine.ParentCommand
    private Peer peerParent;
    @CommandLine.Spec
    CommandLine.Model.CommandSpec spec;
    @CommandLine.Option(names={"-i", "--index-key"}, defaultValue="0", description={"Keystore index of the public/private key to use for the peer."})
    private int keystoreIndex;
    @CommandLine.Option(names={"--public-key"}, defaultValue="", description={"Hex string of the public key in the Keystore to use for the peer.%nYou only need to enter in the first distinct hex values of the public key.%nFor example: 0xf0234 or f0234"})
    private String keystorePublicKey;
    @CommandLine.Option(names={"-r", "--reset"}, description={"Reset and delete the etch database if it exists. Default: ${DEFAULT-VALUE}"})
    private boolean isReset;
    @CommandLine.Option(names={"--port"}, description={"Port number of this local peer."})
    private int port = 0;
    @CommandLine.Option(names={"--host"}, defaultValue="localhost", description={"Hostname of this peer. Default: ${DEFAULT-VALUE}"})
    private String hostname = "localhost";
    @CommandLine.Option(names={"--peer"}, description={"Hostname and port number of remote peer. If not provided then try to connect to a local peer"})
    private String remotePeerHostname;
    @CommandLine.Option(names={"-a", "--address"}, description={"Account address to use for the peer."})
    private long addressNumber;

    @Override
    public void run() {
        Main mainParent = this.peerParent.mainParent;
        PeerManager peerManager = null;
        AKeyPair keyPair = null;
        try {
            keyPair = mainParent.loadKeyFromStore(this.keystorePublicKey, this.keystoreIndex);
        }
        catch (Error e) {
            mainParent.showError(e);
            return;
        }
        if (keyPair == null) {
            log.warn("cannot load a valid key pair to perform peer start");
            return;
        }
        if (this.port != 0) {
            this.port = Math.abs(this.port);
        }
        if (this.addressNumber == 0L) {
            log.warn("please provide an account address to run the peer from.");
            return;
        }
        Address peerAddress = Address.create((long)this.addressNumber);
        if (this.remotePeerHostname == null) {
            try {
                SessionItem item = Helpers.getSessionItem(mainParent.getSessionFilename());
                if (item == null) {
                    log.warn("Cannot find a local peer to connect too");
                    return;
                }
                this.remotePeerHostname = item.getHostname();
            }
            catch (IOException e) {
                log.warn("Cannot load the session control file");
                return;
            }
        } else {
            this.remotePeerHostname = this.remotePeerHostname.strip();
        }
        if (this.hostname == null) {
            log.warn("you need to provide a host name for this peer");
            return;
        }
        this.hostname = this.hostname.strip();
        try {
            AStore store = null;
            String etchStoreFilename = mainParent.getEtchStoreFilename();
            if (etchStoreFilename != null && !etchStoreFilename.isEmpty()) {
                File etchFile = new File(etchStoreFilename);
                if (this.isReset && etchFile.exists()) {
                    log.info("reset: removing old etch storage file {}", (Object)etchStoreFilename);
                    etchFile.delete();
                }
                store = EtchStore.create((File)etchFile);
            } else {
                store = Stores.getGlobalStore();
            }
            peerManager = PeerManager.create(mainParent.getSessionFilename(), keyPair, peerAddress, store);
            peerManager.launchPeer(this.hostname, this.port, this.remotePeerHostname);
            peerManager.showPeerEvents();
        }
        catch (Throwable t) {
            mainParent.showError(t);
        }
    }
}

