/*
 * Decompiled with CFR 0.152.
 */
package world.avionik.space.spigot.api.task.manager;

import com.google.common.collect.HashBiMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u0005J\u0010\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u0007J\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00070\u0004J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u0005J\u0016\u0010\u0011\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0007RN\u0010\u0003\u001aB\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u0007 \u0006* \u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lworld/avionik/space/spigot/api/task/manager/TaskCacheManager;", "", "()V", "runnableMap", "Lcom/google/common/collect/HashBiMap;", "", "kotlin.jvm.PlatformType", "Lorg/bukkit/scheduler/BukkitRunnable;", "existRunnableWithValue", "", "value", "getRunnableByValue", "getRunnableValueByRunnable", "bukkitRunnable", "getRunnables", "removeRunnable", "", "setRunnable", "space-spigot-api"})
public final class TaskCacheManager {
    private final HashBiMap<String, BukkitRunnable> runnableMap = HashBiMap.create();

    public final void setRunnable(@NotNull String value, @NotNull BukkitRunnable bukkitRunnable) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)bukkitRunnable, (String)"bukkitRunnable");
        HashBiMap<String, BukkitRunnable> hashBiMap = this.runnableMap;
        Intrinsics.checkNotNullExpressionValue(hashBiMap, (String)"runnableMap");
        ((Map)hashBiMap).put(value, bukkitRunnable);
    }

    @Nullable
    public final BukkitRunnable getRunnableByValue(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return (BukkitRunnable)this.getRunnables().get((Object)value);
    }

    @Nullable
    public final String getRunnableValueByRunnable(@NotNull BukkitRunnable bukkitRunnable) {
        Intrinsics.checkNotNullParameter((Object)bukkitRunnable, (String)"bukkitRunnable");
        return (String)this.getRunnables().inverse().get((Object)bukkitRunnable);
    }

    @NotNull
    public final HashBiMap<String, BukkitRunnable> getRunnables() {
        HashBiMap<String, BukkitRunnable> hashBiMap = this.runnableMap;
        Intrinsics.checkNotNullExpressionValue(hashBiMap, (String)"runnableMap");
        return hashBiMap;
    }

    public final boolean existRunnableWithValue(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.runnableMap.containsKey((Object)value);
    }

    public final void removeRunnable(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!this.existRunnableWithValue(value)) {
            return;
        }
        BukkitRunnable bukkitRunnable = this.getRunnableByValue(value);
        if (bukkitRunnable != null) {
            bukkitRunnable.cancel();
        }
        this.runnableMap.remove((Object)value);
    }
}

