/*
 * Decompiled with CFR 0.152.
 */
package world.avionik.space.spigot.api.editor;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.kyori.adventure.text.Component;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.RegionAccessor;
import org.bukkit.World;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.TextDisplay;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.util.Transformation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import world.avionik.minecraft.common.extension.AdventureExtensionKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\f\u001a\u00020\u0007H\u0002J\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u000eJ\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0016\u001a\u00020\u00002\b\u0010\u0017\u001a\u0004\u0018\u00010\u0019J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u001cJ\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010 \u001a\u00020!J\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020!J\u0006\u0010#\u001a\u00020\u0000J?\u0010$\u001a\u00020\u0000\"\u0004\b\u0000\u0010%\"\b\b\u0001\u0010&*\u00020\u00012\u0006\u0010'\u001a\u00020(2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u0002H%\u0012\u0004\u0012\u0002H&0*2\u0006\u0010+\u001a\u0002H&\u00a2\u0006\u0002\u0010,J\u000e\u0010-\u001a\u00020\u00002\u0006\u0010.\u001a\u00020/J\u000e\u00100\u001a\u00020\u00002\u0006\u00101\u001a\u00020\u001cJ\u000e\u00102\u001a\u00020\u00002\u0006\u00103\u001a\u000204J\u000e\u00105\u001a\u00020\u00002\u0006\u00106\u001a\u00020\u001cJ\u000e\u00107\u001a\u00020\u00002\u0006\u00108\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lworld/avionik/space/spigot/api/editor/HologramEditor;", "", "location", "Lorg/bukkit/Location;", "(Lorg/bukkit/Location;)V", "nextLineHologram", "textDisplay", "Lorg/bukkit/entity/TextDisplay;", "getTextDisplay", "()Lorg/bukkit/entity/TextDisplay;", "yCloneLocation", "", "createTextDisplay", "destroy", "", "removeNextLines", "withAlignment", "alignment", "Lorg/bukkit/entity/TextDisplay$TextAlignment;", "withBillboard", "billboard", "Lorg/bukkit/entity/Display$Billboard;", "withCustomName", "name", "", "Lnet/kyori/adventure/text/Component;", "withDisplayHeight", "height", "", "withDisplayWidth", "width", "withInterpolationDelay", "delay", "", "withLineWidth", "withNextLine", "withPersistentDataContainer", "P", "C", "key", "Lorg/bukkit/NamespacedKey;", "type", "Lorg/bukkit/persistence/PersistentDataType;", "value", "(Lorg/bukkit/NamespacedKey;Lorg/bukkit/persistence/PersistentDataType;Ljava/lang/Object;)Lworld/avionik/space/spigot/api/editor/HologramEditor;", "withShadow", "shadow", "", "withShadowRadius", "radius", "withTransformation", "transformation", "Lorg/bukkit/util/Transformation;", "withViewRange", "range", "withYCloneLocation", "yClone", "space-spigot-api"})
@SourceDebugExtension(value={"SMAP\nHologramEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HologramEditor.kt\nworld/avionik/space/spigot/api/editor/HologramEditor\n+ 2 RegionAccessorExtension.kt\nworld/avionik/kotlin/paper/RegionAccessorExtensionKt\n*L\n1#1,204:1\n32#2:205\n*S KotlinDebug\n*F\n+ 1 HologramEditor.kt\nworld/avionik/space/spigot/api/editor/HologramEditor\n*L\n199#1:205\n*E\n"})
public final class HologramEditor {
    @NotNull
    private final Location location;
    private double yCloneLocation;
    @Nullable
    private HologramEditor nextLineHologram;
    @NotNull
    private final TextDisplay textDisplay;

    public HologramEditor(@NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.location = location;
        this.yCloneLocation = 0.3;
        this.textDisplay = this.createTextDisplay();
    }

    @NotNull
    public final TextDisplay getTextDisplay() {
        return this.textDisplay;
    }

    @NotNull
    public final HologramEditor withTransformation(@NotNull Transformation transformation) {
        Intrinsics.checkNotNullParameter((Object)transformation, (String)"transformation");
        this.textDisplay.setTransformation(transformation);
        return this;
    }

    @NotNull
    public final HologramEditor withBillboard(@NotNull Display.Billboard billboard) {
        Intrinsics.checkNotNullParameter((Object)billboard, (String)"billboard");
        this.textDisplay.setBillboard(billboard);
        return this;
    }

    @NotNull
    public final HologramEditor withViewRange(float range) {
        this.textDisplay.setViewRange(range);
        return this;
    }

    @NotNull
    public final HologramEditor withShadowRadius(float radius) {
        this.textDisplay.setShadowRadius(radius);
        return this;
    }

    @NotNull
    public final HologramEditor withDisplayHeight(float height) {
        this.textDisplay.setDisplayHeight(height);
        return this;
    }

    @NotNull
    public final HologramEditor withDisplayWidth(float width) {
        this.textDisplay.setDisplayWidth(width);
        return this;
    }

    @NotNull
    public final HologramEditor withInterpolationDelay(int delay) {
        this.textDisplay.setInterpolationDelay(delay);
        return this;
    }

    @NotNull
    public final HologramEditor withAlignment(@NotNull TextDisplay.TextAlignment alignment) {
        Intrinsics.checkNotNullParameter((Object)alignment, (String)"alignment");
        this.textDisplay.setAlignment(alignment);
        return this;
    }

    @NotNull
    public final HologramEditor withLineWidth(int width) {
        this.textDisplay.setLineWidth(width);
        return this;
    }

    @NotNull
    public final HologramEditor withShadow(boolean shadow) {
        this.textDisplay.setShadowed(shadow);
        return this;
    }

    @NotNull
    public final HologramEditor withCustomName(@Nullable Component name) {
        this.textDisplay.text(name);
        return this;
    }

    @NotNull
    public final HologramEditor withCustomName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.withCustomName(AdventureExtensionKt.text((String)name));
    }

    @NotNull
    public final HologramEditor withYCloneLocation(double yClone) {
        this.yCloneLocation = yClone;
        return this;
    }

    @NotNull
    public final <P, C> HologramEditor withPersistentDataContainer(@NotNull NamespacedKey key, @NotNull PersistentDataType<P, C> type, @NotNull C value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.textDisplay.getPersistentDataContainer().set(key, type, value);
        return this;
    }

    @NotNull
    public final HologramEditor withNextLine() {
        if (this.nextLineHologram == null) {
            Location location = this.location.clone().add(0.0, this.yCloneLocation, 0.0);
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"add(...)");
            return new HologramEditor(location);
        }
        HologramEditor hologramEditor = this.nextLineHologram;
        Intrinsics.checkNotNull((Object)hologramEditor);
        return hologramEditor;
    }

    public final void destroy() {
        block0: {
            this.textDisplay.remove();
            HologramEditor hologramEditor = this.nextLineHologram;
            if (hologramEditor == null) break block0;
            hologramEditor.destroy();
        }
    }

    public final void removeNextLines() {
        HologramEditor hologramEditor = this.nextLineHologram;
        if (hologramEditor != null) {
            hologramEditor.removeNextLines();
        }
        HologramEditor hologramEditor2 = this.nextLineHologram;
        if (hologramEditor2 != null) {
            hologramEditor2.destroy();
        }
        this.nextLineHologram = null;
    }

    /*
     * WARNING - void declaration
     */
    private final TextDisplay createTextDisplay() {
        void $this$spawn$iv;
        World world = this.location.getWorld();
        Intrinsics.checkNotNullExpressionValue((Object)world, (String)"getWorld(...)");
        RegionAccessor regionAccessor = (RegionAccessor)world;
        Location location$iv = this.location;
        boolean $i$f$spawn = false;
        Entity entity = $this$spawn$iv.spawn(location$iv, TextDisplay.class);
        Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"spawn(...)");
        TextDisplay textDisplay = (TextDisplay)entity;
        textDisplay.setBillboard(Display.Billboard.CENTER);
        return textDisplay;
    }
}

