/*
 * Decompiled with CFR 0.152.
 */
package world.avionik.nettykit.server.connection;

import eu.thesimplecloud.clientserverapi.lib.connection.IConnection;
import eu.thesimplecloud.clientserverapi.lib.handler.IConnectionHandler;
import eu.thesimplecloud.clientserverapi.server.client.connectedclient.IConnectedClient;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import world.avionik.nettykit.ConnectedClientValue;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lworld/avionik/nettykit/server/connection/ConnectionHandler;", "Leu/thesimplecloud/clientserverapi/lib/handler/IConnectionHandler;", "()V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "onConnectionActive", "", "connection", "Leu/thesimplecloud/clientserverapi/lib/connection/IConnection;", "onConnectionInactive", "onFailure", "ex", "", "netty-kit"})
public class ConnectionHandler
implements IConnectionHandler {
    private final Logger logger = LogManager.getLogger((String)"NETTY");

    public void onConnectionActive(@NotNull IConnection connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
    }

    public void onConnectionInactive(@NotNull IConnection connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        if (!(connection instanceof IConnectedClient)) {
            return;
        }
        IConnectedClient clientValue = (IConnectedClient)connection;
        ConnectedClientValue connectedClientValue = (ConnectedClientValue)clientValue.getClientValue();
        this.logger.info("Client " + (connectedClientValue != null ? connectedClientValue.getClientName() : null) + " has lost connection");
    }

    public void onFailure(@NotNull IConnection connection, @NotNull Throwable ex) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        throw ex;
    }
}

