/*
 * Decompiled with CFR 0.152.
 */
package world.avionik.nettykit.server;

import eu.thesimplecloud.clientserverapi.lib.handler.DefaultServerHandler;
import eu.thesimplecloud.clientserverapi.lib.handler.IConnectionHandler;
import eu.thesimplecloud.clientserverapi.lib.handler.IServerHandler;
import eu.thesimplecloud.clientserverapi.lib.packet.IPacket;
import eu.thesimplecloud.clientserverapi.server.NettyServer;
import eu.thesimplecloud.clientserverapi.server.client.clientmanager.IClientManager;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import world.avionik.nettykit.ConnectedClientValue;
import world.avionik.nettykit.server.configurator.NettyServerConfiguration;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B+\u0012\u0014\u0010\u0002\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u00040\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u0012J\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0002\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lworld/avionik/nettykit/server/NettyServerManager;", "", "packets", "", "Ljava/lang/Class;", "Leu/thesimplecloud/clientserverapi/lib/packet/IPacket;", "configuration", "Lworld/avionik/nettykit/server/configurator/NettyServerConfiguration;", "connectionHandler", "Leu/thesimplecloud/clientserverapi/lib/handler/IConnectionHandler;", "(Ljava/util/List;Lworld/avionik/nettykit/server/configurator/NettyServerConfiguration;Leu/thesimplecloud/clientserverapi/lib/handler/IConnectionHandler;)V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "nettyServer", "Leu/thesimplecloud/clientserverapi/server/NettyServer;", "Lworld/avionik/nettykit/ConnectedClientValue;", "getClientManager", "Leu/thesimplecloud/clientserverapi/server/client/clientmanager/IClientManager;", "initialize", "", "shutdown", "netty-kit"})
@SourceDebugExtension(value={"SMAP\nNettyServerManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NettyServerManager.kt\nworld/avionik/nettykit/server/NettyServerManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,63:1\n1855#2,2:64\n*S KotlinDebug\n*F\n+ 1 NettyServerManager.kt\nworld/avionik/nettykit/server/NettyServerManager\n*L\n37#1:64,2\n*E\n"})
public final class NettyServerManager {
    @NotNull
    private final List<Class<? extends IPacket>> packets;
    @NotNull
    private final NettyServerConfiguration configuration;
    @NotNull
    private final NettyServer<ConnectedClientValue> nettyServer;
    private final Logger logger;

    public NettyServerManager(@NotNull List<? extends Class<? extends IPacket>> packets, @NotNull NettyServerConfiguration configuration, @NotNull IConnectionHandler connectionHandler) {
        Intrinsics.checkNotNullParameter(packets, (String)"packets");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)connectionHandler, (String)"connectionHandler");
        this.packets = packets;
        this.configuration = configuration;
        this.nettyServer = new NettyServer(this.configuration.getHost(), this.configuration.getPort(), connectionHandler, (IServerHandler)new DefaultServerHandler());
        this.logger = LogManager.getLogger((String)"NETTY");
    }

    public final void initialize() {
        this.logger.info("NettyServer is currently being initialised...");
        this.logger.info("Following packages will be registered:");
        Iterable $this$forEach$iv = this.packets;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Class it = (Class)element$iv;
            boolean bl = false;
            this.nettyServer.getPacketManager().registerPacket(it);
            this.logger.info("> " + it.getSimpleName());
        }
        this.logger.info("NettyServer is now started on " + this.configuration);
        this.nettyServer.start().awaitUninterruptibly().throwFailure();
    }

    public final void shutdown() {
        this.logger.info("NettyServer is shutting down");
        this.nettyServer.shutdown().awaitUninterruptibly();
    }

    @NotNull
    public final IClientManager<ConnectedClientValue> getClientManager() {
        return this.nettyServer.getClientManager();
    }
}

