/*
 * Decompiled with CFR 0.152.
 */
package world.avionik.nettykit.client.reconnection;

import eu.thesimplecloud.clientserverapi.lib.connection.IConnection;
import eu.thesimplecloud.clientserverapi.lib.handler.IConnectionHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import world.avionik.nettykit.client.NettyClientManager;
import world.avionik.nettykit.client.reconnection.NettyClientReconnectManager;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lworld/avionik/nettykit/client/reconnection/ReconnectConnectionHandler;", "Leu/thesimplecloud/clientserverapi/lib/handler/IConnectionHandler;", "nettyClientManager", "Lworld/avionik/nettykit/client/NettyClientManager;", "reconnectionDelay", "", "(Lworld/avionik/nettykit/client/NettyClientManager;J)V", "onConnectionActive", "", "connection", "Leu/thesimplecloud/clientserverapi/lib/connection/IConnection;", "onConnectionInactive", "onFailure", "ex", "", "netty-kit"})
public class ReconnectConnectionHandler
implements IConnectionHandler {
    @NotNull
    private final NettyClientManager nettyClientManager;
    private final long reconnectionDelay;

    public ReconnectConnectionHandler(@NotNull NettyClientManager nettyClientManager, long reconnectionDelay) {
        Intrinsics.checkNotNullParameter((Object)nettyClientManager, (String)"nettyClientManager");
        this.nettyClientManager = nettyClientManager;
        this.reconnectionDelay = reconnectionDelay;
    }

    public void onConnectionActive(@NotNull IConnection connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        NettyClientReconnectManager reconnectManager = this.nettyClientManager.getReconnectManager();
        reconnectManager.stopClientReconnection();
    }

    public void onConnectionInactive(@NotNull IConnection connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        NettyClientReconnectManager reconnectManager = this.nettyClientManager.getReconnectManager();
        reconnectManager.reconnectNettyClient(this.reconnectionDelay);
    }

    public void onFailure(@NotNull IConnection connection, @NotNull Throwable ex) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        throw ex;
    }
}

