/*
 * Decompiled with CFR 0.152.
 */
package world.avionik.nettykit.client.logging;

import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import world.avionik.nettykit.client.logging.LoggingExecutor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\b\u001a\u00020\u0003H\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lworld/avionik/nettykit/client/logging/DefaultLoggingExecutor;", "Lworld/avionik/nettykit/client/logging/LoggingExecutor;", "systemName", "", "(Ljava/lang/String;)V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "getLoggerName", "info", "", "message", "warn", "netty-kit"})
public final class DefaultLoggingExecutor
implements LoggingExecutor {
    @NotNull
    private final String systemName;
    private final Logger logger;

    public DefaultLoggingExecutor(@NotNull String systemName) {
        Intrinsics.checkNotNullParameter((Object)systemName, (String)"systemName");
        this.systemName = systemName;
        this.logger = LogManager.getLogger((String)this.getLoggerName());
    }

    @Override
    public void info(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.logger.info(message);
    }

    @Override
    public void warn(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.logger.warn(message);
    }

    private final String getLoggerName() {
        if (StringsKt.isBlank((CharSequence)this.systemName)) {
            return "NETTY";
        }
        String string = this.systemName.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        return string + " - NETTY";
    }
}

