/*
 * Decompiled with CFR 0.152.
 */
package world.avionik.nettykit.client.configurator;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import world.avionik.nettykit.client.config.NettyClientConfig;
import world.avionik.nettykit.client.config.NettyClientConfigLoader;
import world.avionik.nettykit.client.configurator.NettyClientConfiguration;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J$\u0010\u0007\u001a\u00020\u00042\b\b\u0002\u0010\b\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\u00062\b\b\u0002\u0010\n\u001a\u00020\u0006\u00a8\u0006\u000b"}, d2={"Lworld/avionik/nettykit/client/configurator/NettyClientSettings;", "", "()V", "fromConfig", "Lworld/avionik/nettykit/client/configurator/NettyClientConfiguration;", "path", "", "fromEnv", "systemName", "host", "port", "netty-kit"})
public final class NettyClientSettings {
    @NotNull
    public static final NettyClientSettings INSTANCE = new NettyClientSettings();

    private NettyClientSettings() {
    }

    @NotNull
    public final NettyClientConfiguration fromEnv(@NotNull String systemName, @NotNull String host, @NotNull String port) {
        Intrinsics.checkNotNullParameter((Object)systemName, (String)"systemName");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)port, (String)"port");
        String string = System.getenv(systemName);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getenv(...)");
        String string2 = System.getenv(host);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getenv(...)");
        String string3 = System.getenv(port);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getenv(...)");
        return new NettyClientConfiguration(string, string2, Integer.parseInt(string3), null, 8, null);
    }

    public static /* synthetic */ NettyClientConfiguration fromEnv$default(NettyClientSettings nettyClientSettings, String string, String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string = "NETTY_CLIENT_SYSTEM_NAME";
        }
        if ((n & 2) != 0) {
            string2 = "NETTY_CLIENT_HOST";
        }
        if ((n & 4) != 0) {
            string3 = "NETTY_CLIENT_PORT";
        }
        return nettyClientSettings.fromEnv(string, string2, string3);
    }

    @NotNull
    public final NettyClientConfiguration fromConfig(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        NettyClientConfig nettyServerConfig = (NettyClientConfig)new NettyClientConfigLoader(path).load();
        return new NettyClientConfiguration(nettyServerConfig.getSystemName(), nettyServerConfig.getHost(), nettyServerConfig.getPort(), nettyServerConfig.getOptions());
    }
}

