/*
 * Decompiled with CFR 0.152.
 */
package world.avionik.nettykit.client.configurator;

import eu.thesimplecloud.clientserverapi.client.NettyClient;
import eu.thesimplecloud.clientserverapi.lib.handler.IConnectionHandler;
import eu.thesimplecloud.clientserverapi.lib.packet.IPacket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import world.avionik.nettykit.ConnectedClientValue;
import world.avionik.nettykit.client.NettyClientHandler;
import world.avionik.nettykit.client.NettyClientManager;
import world.avionik.nettykit.client.configurator.NettyClientConfiguration;
import world.avionik.nettykit.client.configurator.NettyClientConfigurator;
import world.avionik.nettykit.client.logging.DefaultLoggingExecutor;
import world.avionik.nettykit.client.logging.LoggingExecutor;
import world.avionik.nettykit.client.logging.PrintLoggingExecutor;
import world.avionik.nettykit.client.packet.PacketOutClientIsActive;
import world.avionik.nettykit.client.reconnection.ReconnectConnectionHandler;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0017\u001a\u00020\u0018J\u001a\u0010\u0019\u001a\u00020\u00002\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bJ\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0005J/\u0010\u001f\u001a\u00020\u00002\"\u0010 \u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u00110!\"\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0011\u00a2\u0006\u0002\u0010\"J\u0006\u0010#\u001a\u00020\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\u000f\u001a\"\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u00110\u0010j\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0011`\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lworld/avionik/nettykit/client/configurator/NettyClientConfigurator;", "", "configuration", "Lworld/avionik/nettykit/client/configurator/NettyClientConfiguration;", "clientName", "", "(Lworld/avionik/nettykit/client/configurator/NettyClientConfiguration;Ljava/lang/String;)V", "connectionHandlerFunction", "Lkotlin/Function1;", "Lworld/avionik/nettykit/client/NettyClientManager;", "Leu/thesimplecloud/clientserverapi/lib/handler/IConnectionHandler;", "loggingExecutor", "Lworld/avionik/nettykit/client/logging/LoggingExecutor;", "options", "", "packets", "Ljava/util/ArrayList;", "Ljava/lang/Class;", "Leu/thesimplecloud/clientserverapi/lib/packet/IPacket;", "Lkotlin/collections/ArrayList;", "start", "Lworld/avionik/nettykit/client/NettyClientHandler;", "withAutoReconnect", "reconnectionDelay", "", "withConnectionHandler", "function", "withLoggingExecutor", "withOption", "key", "value", "withPackets", "packet", "", "([Ljava/lang/Class;)Lworld/avionik/nettykit/client/configurator/NettyClientConfigurator;", "withSystemLogging", "netty-kit"})
public final class NettyClientConfigurator {
    @NotNull
    private final NettyClientConfiguration configuration;
    @NotNull
    private final String clientName;
    @NotNull
    private final Map<String, String> options;
    @NotNull
    private final ArrayList<Class<? extends IPacket>> packets;
    @NotNull
    private Function1<? super NettyClientManager, ? extends IConnectionHandler> connectionHandlerFunction;
    @NotNull
    private LoggingExecutor loggingExecutor;

    public NettyClientConfigurator(@NotNull NettyClientConfiguration configuration, @NotNull String clientName) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)clientName, (String)"clientName");
        this.configuration = configuration;
        this.clientName = clientName;
        this.options = MapsKt.toMutableMap(this.configuration.getOptions());
        Object[] objectArray = new Class[]{PacketOutClientIsActive.class};
        this.packets = CollectionsKt.arrayListOf((Object[])objectArray);
        this.connectionHandlerFunction = connectionHandlerFunction.1.INSTANCE;
        this.loggingExecutor = new PrintLoggingExecutor(this.configuration.getSystemName());
    }

    @NotNull
    public final NettyClientConfigurator withPackets(Class<? extends IPacket> ... packet) {
        Intrinsics.checkNotNullParameter(packet, (String)"packet");
        CollectionsKt.addAll((Collection)this.packets, (Object[])packet);
        return this;
    }

    @NotNull
    public final NettyClientConfigurator withOption(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.options.put(key, value);
        return this;
    }

    @NotNull
    public final NettyClientConfigurator withSystemLogging() {
        this.withLoggingExecutor(new DefaultLoggingExecutor(this.configuration.getSystemName()));
        return this;
    }

    @NotNull
    public final NettyClientConfigurator withLoggingExecutor(@NotNull LoggingExecutor loggingExecutor) {
        Intrinsics.checkNotNullParameter((Object)loggingExecutor, (String)"loggingExecutor");
        this.loggingExecutor = loggingExecutor;
        return this;
    }

    @NotNull
    public final NettyClientConfigurator withConnectionHandler(@NotNull Function1<? super NettyClientManager, ? extends IConnectionHandler> function) {
        Intrinsics.checkNotNullParameter(function, (String)"function");
        this.connectionHandlerFunction = function;
        return this;
    }

    @NotNull
    public final NettyClientConfigurator withAutoReconnect(long reconnectionDelay) {
        this.withConnectionHandler((Function1<? super NettyClientManager, ? extends IConnectionHandler>)((Function1)new Function1<NettyClientManager, IConnectionHandler>(reconnectionDelay){
            final /* synthetic */ long $reconnectionDelay;
            {
                this.$reconnectionDelay = $reconnectionDelay;
                super(1);
            }

            @NotNull
            public final IConnectionHandler invoke(@NotNull NettyClientManager it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return new ReconnectConnectionHandler(it, this.$reconnectionDelay);
            }
        }));
        return this;
    }

    public static /* synthetic */ NettyClientConfigurator withAutoReconnect$default(NettyClientConfigurator nettyClientConfigurator, long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = 5L;
        }
        return nettyClientConfigurator.withAutoReconnect(l);
    }

    @NotNull
    public final NettyClientHandler start() {
        ConnectedClientValue connectedClientValue = new ConnectedClientValue(this.clientName, this.options);
        NettyClientManager nettyClientManager = new NettyClientManager(connectedClientValue, this.configuration, this.connectionHandlerFunction, (List<? extends Class<? extends IPacket>>)this.packets, this.loggingExecutor);
        NettyClient newNettyClient = nettyClientManager.createClient();
        nettyClientManager.initialize(newNettyClient);
        return new NettyClientHandler(nettyClientManager);
    }
}

