/*
 * Decompiled with CFR 0.152.
 */
package world.avionik.nettykit.client;

import eu.thesimplecloud.clientserverapi.client.NettyClient;
import eu.thesimplecloud.clientserverapi.lib.connection.IConnection;
import eu.thesimplecloud.clientserverapi.lib.handler.IConnectionHandler;
import eu.thesimplecloud.clientserverapi.lib.packet.IPacket;
import eu.thesimplecloud.clientserverapi.lib.packet.packetsender.IPacketSender;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import world.avionik.nettykit.ConnectedClientValue;
import world.avionik.nettykit.client.configurator.NettyClientConfiguration;
import world.avionik.nettykit.client.logging.LoggingExecutor;
import world.avionik.nettykit.client.packet.PacketOutClientIsActive;
import world.avionik.nettykit.client.reconnection.NettyClientReconnectManager;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0014\u0010\t\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b0\n\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0006\u0010\u001a\u001a\u00020\u0015J\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u001f\u001a\u00020\u001eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006 "}, d2={"Lworld/avionik/nettykit/client/NettyClientManager;", "", "connectedClientValue", "Lworld/avionik/nettykit/ConnectedClientValue;", "configuration", "Lworld/avionik/nettykit/client/configurator/NettyClientConfiguration;", "connectionHandlerFunction", "Lkotlin/Function1;", "Leu/thesimplecloud/clientserverapi/lib/handler/IConnectionHandler;", "packets", "", "Ljava/lang/Class;", "Leu/thesimplecloud/clientserverapi/lib/packet/IPacket;", "loggingExecutor", "Lworld/avionik/nettykit/client/logging/LoggingExecutor;", "(Lworld/avionik/nettykit/ConnectedClientValue;Lworld/avionik/nettykit/client/configurator/NettyClientConfiguration;Lkotlin/jvm/functions/Function1;Ljava/util/List;Lworld/avionik/nettykit/client/logging/LoggingExecutor;)V", "getConfiguration", "()Lworld/avionik/nettykit/client/configurator/NettyClientConfiguration;", "getLoggingExecutor", "()Lworld/avionik/nettykit/client/logging/LoggingExecutor;", "nettyClient", "Leu/thesimplecloud/clientserverapi/client/NettyClient;", "reconnectManager", "Lworld/avionik/nettykit/client/reconnection/NettyClientReconnectManager;", "getReconnectManager", "()Lworld/avionik/nettykit/client/reconnection/NettyClientReconnectManager;", "createClient", "getConnection", "Leu/thesimplecloud/clientserverapi/lib/connection/IConnection;", "initialize", "", "shutdown", "netty-kit"})
@SourceDebugExtension(value={"SMAP\nNettyClientManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NettyClientManager.kt\nworld/avionik/nettykit/client/NettyClientManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,82:1\n1855#2,2:83\n*S KotlinDebug\n*F\n+ 1 NettyClientManager.kt\nworld/avionik/nettykit/client/NettyClientManager\n*L\n49#1:83,2\n*E\n"})
public final class NettyClientManager {
    @NotNull
    private final ConnectedClientValue connectedClientValue;
    @NotNull
    private final NettyClientConfiguration configuration;
    @NotNull
    private final Function1<NettyClientManager, IConnectionHandler> connectionHandlerFunction;
    @NotNull
    private final List<Class<? extends IPacket>> packets;
    @NotNull
    private final LoggingExecutor loggingExecutor;
    @NotNull
    private final NettyClientReconnectManager reconnectManager;
    @Nullable
    private NettyClient nettyClient;

    public NettyClientManager(@NotNull ConnectedClientValue connectedClientValue, @NotNull NettyClientConfiguration configuration, @NotNull Function1<? super NettyClientManager, ? extends IConnectionHandler> connectionHandlerFunction2, @NotNull List<? extends Class<? extends IPacket>> packets, @NotNull LoggingExecutor loggingExecutor) {
        Intrinsics.checkNotNullParameter((Object)connectedClientValue, (String)"connectedClientValue");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter(connectionHandlerFunction2, (String)"connectionHandlerFunction");
        Intrinsics.checkNotNullParameter(packets, (String)"packets");
        Intrinsics.checkNotNullParameter((Object)loggingExecutor, (String)"loggingExecutor");
        this.connectedClientValue = connectedClientValue;
        this.configuration = configuration;
        this.connectionHandlerFunction = connectionHandlerFunction2;
        this.packets = packets;
        this.loggingExecutor = loggingExecutor;
        this.reconnectManager = new NettyClientReconnectManager(this);
    }

    @NotNull
    public final NettyClientConfiguration getConfiguration() {
        return this.configuration;
    }

    @NotNull
    public final LoggingExecutor getLoggingExecutor() {
        return this.loggingExecutor;
    }

    @NotNull
    public final NettyClientReconnectManager getReconnectManager() {
        return this.reconnectManager;
    }

    @NotNull
    public final NettyClient createClient() {
        return new NettyClient(this.configuration.getHost(), this.configuration.getPort(), (IConnectionHandler)this.connectionHandlerFunction.invoke((Object)this));
    }

    public final void initialize(@NotNull NettyClient nettyClient) {
        Intrinsics.checkNotNullParameter((Object)nettyClient, (String)"nettyClient");
        this.nettyClient = nettyClient;
        this.loggingExecutor.info("NettyClient is currently being initialised...");
        this.loggingExecutor.info("Following packages will be registered:");
        Iterable $this$forEach$iv = this.packets;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Class it = (Class)element$iv;
            boolean bl = false;
            nettyClient.getPacketManager().registerPacket(it);
            this.loggingExecutor.info("> " + it.getSimpleName());
        }
        this.loggingExecutor.info("NettyClient is now started on " + this.configuration);
        nettyClient.start().awaitUninterruptibly().throwFailure();
        try {
            Thread.sleep(200L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        PacketOutClientIsActive packet = new PacketOutClientIsActive(this.connectedClientValue);
        IPacketSender.DefaultImpls.sendUnitQuery$default((IPacketSender)((IPacketSender)nettyClient.getConnection()), (IPacket)((IPacket)packet), (long)0L, (int)2, null);
    }

    public final void shutdown() {
        NettyClient nettyClient = this.nettyClient;
        if (nettyClient == null || (nettyClient = nettyClient.shutdown()) == null || (nettyClient = nettyClient.awaitUninterruptibly()) == null) {
            throw new IllegalStateException("No netty client has been created yet");
        }
    }

    @NotNull
    public final IConnection getConnection() {
        NettyClient nettyClient = this.nettyClient;
        if (nettyClient == null || (nettyClient = nettyClient.getConnection()) == null) {
            throw new IllegalStateException("No netty client has been created yet");
        }
        return nettyClient;
    }
}

