/*
 * Decompiled with CFR 0.152.
 */
package world.avionik.database.simplified.repository;

import com.mongodb.client.result.DeleteResult;
import dev.morphia.Datastore;
import dev.morphia.query.Query;
import dev.morphia.query.filters.Filter;
import dev.morphia.query.filters.Filters;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import world.avionik.database.simplified.repository.Repository;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u00020\u0004B\u001b\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\b\u00a2\u0006\u0002\u0010\tJ\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJ\u0019\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00010\u00102\u0006\u0010\u0011\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0012J\u0012\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00140\rJ\u001b\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\r2\u0006\u0010\u0011\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0016J\u0013\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0019J\u0019\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00180\r2\u0006\u0010\u001b\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lworld/avionik/database/simplified/repository/AbstractMorphiaRepository;", "I", "", "T", "Lworld/avionik/database/simplified/repository/Repository;", "datastore", "Ldev/morphia/Datastore;", "entityClass", "Ljava/lang/Class;", "(Ldev/morphia/Datastore;Ljava/lang/Class;)V", "getDatastore", "()Ldev/morphia/Datastore;", "count", "Ljava/util/concurrent/CompletableFuture;", "", "createIdentifierQuery", "Ldev/morphia/query/Query;", "identifier", "(Ljava/lang/Object;)Ldev/morphia/query/Query;", "findAll", "", "findOrNull", "(Ljava/lang/Object;)Ljava/util/concurrent/CompletableFuture;", "remove", "", "(Ljava/lang/Object;)V", "save", "value", "database-simplified-kit"})
public abstract class AbstractMorphiaRepository<I, T>
implements Repository {
    @NotNull
    private final Datastore datastore;
    @NotNull
    private final Class<T> entityClass;

    public AbstractMorphiaRepository(@NotNull Datastore datastore, @NotNull Class<T> entityClass) {
        Intrinsics.checkNotNullParameter((Object)datastore, (String)"datastore");
        Intrinsics.checkNotNullParameter(entityClass, (String)"entityClass");
        this.datastore = datastore;
        this.entityClass = entityClass;
    }

    @NotNull
    public final Datastore getDatastore() {
        return this.datastore;
    }

    @NotNull
    public final CompletableFuture<List<T>> findAll() {
        CompletableFuture<List<T>> completableFuture = CompletableFuture.supplyAsync(() -> AbstractMorphiaRepository.findAll$lambda$0(this));
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"supplyAsync(...)");
        return completableFuture;
    }

    @NotNull
    public final CompletableFuture<T> findOrNull(@NotNull I identifier) {
        Intrinsics.checkNotNullParameter(identifier, (String)"identifier");
        CompletableFuture<Object> completableFuture = CompletableFuture.supplyAsync(() -> AbstractMorphiaRepository.findOrNull$lambda$1(this, identifier));
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"supplyAsync(...)");
        return completableFuture;
    }

    @NotNull
    public final CompletableFuture<Unit> save(@NotNull T value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        CompletableFuture<Unit> completableFuture = CompletableFuture.supplyAsync(() -> AbstractMorphiaRepository.save$lambda$2(this, value));
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"supplyAsync(...)");
        return completableFuture;
    }

    public final void remove(@NotNull I identifier) {
        Intrinsics.checkNotNullParameter(identifier, (String)"identifier");
        CompletableFuture.supplyAsync(() -> AbstractMorphiaRepository.remove$lambda$3(this, identifier));
    }

    @NotNull
    public final CompletableFuture<Long> count() {
        CompletableFuture<Long> completableFuture = CompletableFuture.supplyAsync(() -> AbstractMorphiaRepository.count$lambda$4(this));
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"supplyAsync(...)");
        return completableFuture;
    }

    @NotNull
    public final Query<T> createIdentifierQuery(@NotNull I identifier) {
        Intrinsics.checkNotNullParameter(identifier, (String)"identifier");
        Filter[] filterArray = new Filter[]{Filters.eq((String)"_id", identifier)};
        Query query = this.datastore.find(this.entityClass).filter(filterArray);
        Intrinsics.checkNotNullExpressionValue((Object)query, (String)"filter(...)");
        return query;
    }

    private static final List findAll$lambda$0(AbstractMorphiaRepository this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Query query = this$0.datastore.find(this$0.entityClass);
        Intrinsics.checkNotNullExpressionValue((Object)query, (String)"find(...)");
        return CollectionsKt.toList((Iterable)((Iterable)query));
    }

    private static final Object findOrNull$lambda$1(AbstractMorphiaRepository this$0, Object $identifier) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$identifier, (String)"$identifier");
        return this$0.createIdentifierQuery($identifier).first();
    }

    private static final Unit save$lambda$2(AbstractMorphiaRepository this$0, Object $value) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$value, (String)"$value");
        this$0.datastore.save($value);
        return Unit.INSTANCE;
    }

    private static final DeleteResult remove$lambda$3(AbstractMorphiaRepository this$0, Object $identifier) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$identifier, (String)"$identifier");
        return this$0.createIdentifierQuery($identifier).delete();
    }

    private static final Long count$lambda$4(AbstractMorphiaRepository this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.datastore.find(this$0.entityClass).count();
    }
}

