/*
 * Decompiled with CFR 0.152.
 */
package world.avionik.database.simplified.repository;

import eu.thesimplecloud.jsonlib.JsonLib;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import world.avionik.database.simplified.DatabaseSimplifiedKit;
import world.avionik.database.simplified.repository.Repository;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\"\n\u0002\b\u0007\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u001b\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u000b\u001a\u00020\fJ\u0015\u0010\r\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000e\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000fJ\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u0011J\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u0013J\u0015\u0010\u0014\u001a\u00028\u00002\u0006\u0010\u0015\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010\u000fJ\u001b\u0010\u0016\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0018J\u000e\u0010\u0019\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u0007R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lworld/avionik/database/simplified/repository/AbstractJedisRepository;", "V", "", "Lworld/avionik/database/simplified/repository/Repository;", "valueClass", "Ljava/lang/Class;", "databasePattern", "", "(Ljava/lang/Class;Ljava/lang/String;)V", "jedisPool", "Lredis/clients/jedis/JedisPool;", "clear", "", "find", "key", "(Ljava/lang/String;)Ljava/lang/Object;", "findAll", "", "findAllKeys", "", "getObjectFromJsonString", "string", "insert", "value", "(Ljava/lang/String;Ljava/lang/Object;)V", "remove", "database-simplified-kit"})
@SourceDebugExtension(value={"SMAP\nAbstractJedisRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractJedisRepository.kt\nworld/avionik/database/simplified/repository/AbstractJedisRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,55:1\n766#2:56\n857#2,2:57\n1549#2:59\n1620#2,3:60\n1603#2,9:63\n1855#2:72\n1856#2:74\n1612#2:75\n1#3:73\n1#3:76\n*S KotlinDebug\n*F\n+ 1 AbstractJedisRepository.kt\nworld/avionik/database/simplified/repository/AbstractJedisRepository\n*L\n20#1:56\n20#1:57,2\n21#1:59\n21#1:60,3\n22#1:63,9\n22#1:72\n22#1:74\n22#1:75\n22#1:73\n*E\n"})
public abstract class AbstractJedisRepository<V>
implements Repository {
    @NotNull
    private final Class<V> valueClass;
    @NotNull
    private final String databasePattern;
    @NotNull
    private final JedisPool jedisPool;

    public AbstractJedisRepository(@NotNull Class<V> valueClass, @NotNull String databasePattern) {
        Intrinsics.checkNotNullParameter(valueClass, (String)"valueClass");
        Intrinsics.checkNotNullParameter((Object)databasePattern, (String)"databasePattern");
        this.valueClass = valueClass;
        this.databasePattern = databasePattern;
        this.jedisPool = DatabaseSimplifiedKit.Companion.getInstance().getJedisPool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final List<V> findAll() {
        Closeable closeable = (Closeable)this.jedisPool.getResource();
        Throwable throwable = null;
        try {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            String it;
            void $this$filterTo$iv$iv;
            Jedis jedis = (Jedis)closeable;
            boolean bl = false;
            Set keys = jedis.keys(this.databasePattern + ":*");
            Intrinsics.checkNotNull((Object)keys);
            Iterable $this$filter$iv = keys;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl2 = false;
                if (!jedis.exists(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(jedis.get(it));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$mapNotNull = false;
            $this$mapTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                V it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl4 = false;
                String it2 = (String)element$iv$iv;
                boolean bl5 = false;
                Intrinsics.checkNotNull((Object)it2);
                if (this.getObjectFromJsonString(it2) == null) continue;
                boolean bl6 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List list = (List)destination$iv$iv;
            return list;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Set<String> findAllKeys() {
        Set set;
        Closeable closeable = (Closeable)this.jedisPool.getResource();
        Throwable throwable = null;
        try {
            Jedis it = (Jedis)closeable;
            boolean bl = false;
            Set set2 = it.keys(this.databasePattern + ":*");
            set = set2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"use(...)");
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final V find(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Closeable closeable = (Closeable)this.jedisPool.getResource();
        Throwable throwable = null;
        try {
            Jedis it = (Jedis)closeable;
            boolean bl = false;
            if (!it.exists(this.databasePattern + ":" + key)) {
                V v = null;
                return v;
            }
            String string = it.get(this.databasePattern + ":" + key);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
            V v = this.getObjectFromJsonString(string);
            return v;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void remove(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Closeable closeable = (Closeable)this.jedisPool.getResource();
        Throwable throwable = null;
        try {
            Jedis it = (Jedis)closeable;
            boolean bl = false;
            long l = it.del(this.databasePattern + ":" + key);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void insert(@NotNull String key, @NotNull V value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        String jsonString = JsonLib.Companion.fromObject(value).getAsJsonString();
        Closeable closeable = (Closeable)this.jedisPool.getResource();
        Throwable throwable = null;
        try {
            Jedis it = (Jedis)closeable;
            boolean bl = false;
            String string = it.set(this.databasePattern + ":" + key, jsonString);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() {
        Closeable closeable = (Closeable)this.jedisPool.getResource();
        Throwable throwable = null;
        try {
            Jedis it = (Jedis)closeable;
            boolean bl = false;
            long l = it.del(this.databasePattern + ":*");
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final V getObjectFromJsonString(String string) {
        return (V)JsonLib.Companion.fromJsonString$default((JsonLib.Companion)JsonLib.Companion, (String)string, null, (int)2, null).getObject(this.valueClass);
    }
}

