/*
 * Decompiled with CFR 0.152.
 */
package world.avionik.database.simplified.rabbitmq;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import world.avionik.database.simplified.kubernetes.KubernetesSecrets;
import world.avionik.database.simplified.rabbitmq.RabbitMQConfiguration;
import world.avionik.database.simplified.rabbitmq.RabbitMQSecretLoader;
import world.avionik.database.simplified.rabbitmq.config.RabbitMQConfig;
import world.avionik.database.simplified.rabbitmq.config.RabbitMQConfigLoader;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006J.\u0010\u0007\u001a\u00020\u00042\b\b\u0002\u0010\b\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\u00062\b\b\u0002\u0010\n\u001a\u00020\u00062\b\b\u0002\u0010\u000b\u001a\u00020\u0006J\u0010\u0010\f\u001a\u00020\u00042\b\b\u0002\u0010\r\u001a\u00020\u0006\u00a8\u0006\u000e"}, d2={"Lworld/avionik/database/simplified/rabbitmq/RabbitMQSettings;", "", "()V", "fromConfig", "Lworld/avionik/database/simplified/rabbitmq/RabbitMQConfiguration;", "path", "", "fromEnv", "host", "username", "port", "password", "fromKubeSecret", "namespace", "database-simplified-kit"})
public final class RabbitMQSettings {
    @NotNull
    public static final RabbitMQSettings INSTANCE = new RabbitMQSettings();

    private RabbitMQSettings() {
    }

    @NotNull
    public final RabbitMQConfiguration fromEnv(@NotNull String host, @NotNull String username, @NotNull String port, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter((Object)port, (String)"port");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        String string = System.getenv(host);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getenv(...)");
        String string2 = System.getenv(username);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getenv(...)");
        String string3 = System.getenv(port);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getenv(...)");
        int n = Integer.parseInt(string3);
        String string4 = System.getenv(password);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getenv(...)");
        return new RabbitMQConfiguration(string, string2, n, string4);
    }

    public static /* synthetic */ RabbitMQConfiguration fromEnv$default(RabbitMQSettings rabbitMQSettings, String string, String string2, String string3, String string4, int n, Object object) {
        if ((n & 1) != 0) {
            string = "RABBITMQ_HOST";
        }
        if ((n & 2) != 0) {
            string2 = "RABBITMQ_USERNAME";
        }
        if ((n & 4) != 0) {
            string3 = "RABBITMQ_PORT";
        }
        if ((n & 8) != 0) {
            string4 = "RABBITMQ_PASSWORD";
        }
        return rabbitMQSettings.fromEnv(string, string2, string3, string4);
    }

    @NotNull
    public final RabbitMQConfiguration fromConfig(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        RabbitMQConfig rabbitMQConfig = (RabbitMQConfig)new RabbitMQConfigLoader(path).load();
        return new RabbitMQConfiguration(rabbitMQConfig.getHost(), rabbitMQConfig.getUsername(), rabbitMQConfig.getPort(), rabbitMQConfig.getPassword());
    }

    public static /* synthetic */ RabbitMQConfiguration fromConfig$default(RabbitMQSettings rabbitMQSettings, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "database";
        }
        return rabbitMQSettings.fromConfig(string);
    }

    @NotNull
    public final RabbitMQConfiguration fromKubeSecret(@NotNull String namespace) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        return new RabbitMQSecretLoader(namespace).get();
    }

    public static /* synthetic */ RabbitMQConfiguration fromKubeSecret$default(RabbitMQSettings rabbitMQSettings, String string, int n, Object object) {
        if ((n & 1) != 0) {
            String string2 = KubernetesSecrets.INSTANCE.getNamespace();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-namespace>(...)");
            string = string2;
        }
        return rabbitMQSettings.fromKubeSecret(string);
    }
}

