/*
 * Decompiled with CFR 0.152.
 */
package world.avionik.database.simplified.rabbitmq;

import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lworld/avionik/database/simplified/rabbitmq/RabbitMQConfiguration;", "", "host", "", "username", "port", "", "password", "(Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;)V", "createConnection", "Lcom/rabbitmq/client/Connection;", "database-simplified-kit"})
public final class RabbitMQConfiguration {
    @NotNull
    private final String host;
    @NotNull
    private final String username;
    private final int port;
    @NotNull
    private final String password;

    public RabbitMQConfiguration(@NotNull String host, @NotNull String username, int port, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        this.host = host;
        this.username = username;
        this.port = port;
        this.password = password;
    }

    @NotNull
    public final Connection createConnection() {
        ConnectionFactory connectionFactory = new ConnectionFactory();
        connectionFactory.setHost(this.host);
        connectionFactory.setPort(this.port);
        connectionFactory.setUsername(this.username);
        connectionFactory.setPassword(this.password);
        connectionFactory.setVirtualHost("/");
        connectionFactory.setChannelRpcTimeout(0);
        connectionFactory.setNetworkRecoveryInterval(10000L);
        connectionFactory.setAutomaticRecoveryEnabled(true);
        Connection connection = connectionFactory.newConnection();
        Intrinsics.checkNotNullExpressionValue((Object)connection, (String)"newConnection(...)");
        return connection;
    }
}

