/*
 * Decompiled with CFR 0.152.
 */
package world.avionik.database.simplified.morphia;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import world.avionik.database.simplified.kubernetes.KubernetesSecrets;
import world.avionik.database.simplified.morphia.MorphiaSecretLoader;
import world.avionik.database.simplified.morphia.config.MorphiaConfig;
import world.avionik.database.simplified.morphia.config.MorphiaConfigLoader;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0004J\u0010\u0010\u0006\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u0004J\u0010\u0010\b\u001a\u00020\u00042\b\b\u0002\u0010\t\u001a\u00020\u0004\u00a8\u0006\n"}, d2={"Lworld/avionik/database/simplified/morphia/MorphiaSettings;", "", "()V", "fromConfig", "", "path", "fromEnv", "environment", "fromKubeSecret", "namespace", "database-simplified-kit"})
public final class MorphiaSettings {
    @NotNull
    public static final MorphiaSettings INSTANCE = new MorphiaSettings();

    private MorphiaSettings() {
    }

    @NotNull
    public final String fromEnv(@NotNull String environment) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        String string = System.getenv(environment);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getenv(...)");
        return string;
    }

    public static /* synthetic */ String fromEnv$default(MorphiaSettings morphiaSettings, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "MORPHIA_CONNECTION_STRING";
        }
        return morphiaSettings.fromEnv(string);
    }

    @NotNull
    public final String fromConfig(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        MorphiaConfig morphiaConfig = (MorphiaConfig)new MorphiaConfigLoader(path).load();
        return morphiaConfig.getConnectionString();
    }

    public static /* synthetic */ String fromConfig$default(MorphiaSettings morphiaSettings, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "database";
        }
        return morphiaSettings.fromConfig(string);
    }

    @NotNull
    public final String fromKubeSecret(@NotNull String namespace) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        return new MorphiaSecretLoader(namespace).get();
    }

    public static /* synthetic */ String fromKubeSecret$default(MorphiaSettings morphiaSettings, String string, int n, Object object) {
        if ((n & 1) != 0) {
            String string2 = KubernetesSecrets.INSTANCE.getNamespace();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-namespace>(...)");
            string = string2;
        }
        return morphiaSettings.fromKubeSecret(string);
    }
}

