/*
 * Decompiled with CFR 0.152.
 */
package world.avionik.database.simplified.morphia;

import io.fabric8.kubernetes.api.model.Secret;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import world.avionik.database.simplified.kubernetes.KubernetesSecrets;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006j\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003`\u0007H\u0002J\u0006\u0010\n\u001a\u00020\u0003J\f\u0010\u000b\u001a\u00020\u0003*\u00020\u0003H\u0002R*\u0010\u0005\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006j\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lworld/avionik/database/simplified/morphia/MorphiaSecretLoader;", "", "namespace", "", "(Ljava/lang/String;)V", "defaultSecrets", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "secretName", "createSecret", "get", "decodeBase64", "database-simplified-kit"})
public final class MorphiaSecretLoader {
    @NotNull
    private final String namespace;
    @NotNull
    private final String secretName;
    @NotNull
    private final HashMap<String, String> defaultSecrets;

    public MorphiaSecretLoader(@NotNull String namespace) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        this.namespace = namespace;
        this.secretName = "morphia-secret";
        Pair[] pairArray = new Pair[]{new Pair((Object)"connectionString", (Object)"")};
        this.defaultSecrets = MapsKt.hashMapOf((Pair[])pairArray);
    }

    private final HashMap<String, String> createSecret() {
        KubernetesSecrets.INSTANCE.createSecret(this.namespace, this.secretName, (Map<String, String>)this.defaultSecrets);
        return this.defaultSecrets;
    }

    @NotNull
    public final String get() {
        Map secrets;
        String string;
        Secret secret = KubernetesSecrets.INSTANCE.getSecret(this.namespace, this.secretName);
        Map map = secret != null ? secret.getData() : null;
        if (map == null) {
            map = this.createSecret();
        }
        if ((string = (String)(secrets = map).get("connectionString")) == null || (string = this.decodeBase64(string)) == null) {
            throw new NullPointerException("failed to find connectionString");
        }
        return string;
    }

    private final String decodeBase64(String $this$decodeBase64) {
        byte[] byArray = Base64.getDecoder().decode($this$decodeBase64);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(...)");
        byte[] byArray2 = byArray;
        return new String(byArray2, Charsets.UTF_8);
    }
}

