/*
 * Decompiled with CFR 0.152.
 */
package world.avionik.database.simplified.morphia;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.connection.ClusterSettings;
import com.mongodb.connection.SocketSettings;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bson.UuidRepresentation;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.codecs.pojo.PojoCodecProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006J\b\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lworld/avionik/database/simplified/morphia/MorphiaClientFactory;", "", "connectionString", "", "(Ljava/lang/String;)V", "createClient", "Lcom/mongodb/client/MongoClient;", "createClientSettings", "Lcom/mongodb/MongoClientSettings;", "database-simplified-kit"})
public final class MorphiaClientFactory {
    @NotNull
    private final String connectionString;

    public MorphiaClientFactory(@NotNull String connectionString) {
        Intrinsics.checkNotNullParameter((Object)connectionString, (String)"connectionString");
        this.connectionString = connectionString;
    }

    @NotNull
    public final MongoClient createClient() {
        MongoClient mongoClient = MongoClients.create((MongoClientSettings)this.createClientSettings());
        Intrinsics.checkNotNullExpressionValue((Object)mongoClient, (String)"create(...)");
        return mongoClient;
    }

    private final MongoClientSettings createClientSettings() {
        CodecProvider[] codecProviderArray = new CodecProvider[]{PojoCodecProvider.builder().automatic(true).build()};
        CodecRegistry pojoCodecRegistry = CodecRegistries.fromProviders((CodecProvider[])codecProviderArray);
        CodecRegistry[] codecRegistryArray = new CodecRegistry[]{MongoClientSettings.getDefaultCodecRegistry(), pojoCodecRegistry};
        CodecRegistry codecRegistry = CodecRegistries.fromRegistries((CodecRegistry[])codecRegistryArray);
        MongoClientSettings mongoClientSettings = MongoClientSettings.builder().uuidRepresentation(UuidRepresentation.STANDARD).codecRegistry(codecRegistry).applyToSocketSettings(MorphiaClientFactory::createClientSettings$lambda$0).applyToClusterSettings(MorphiaClientFactory::createClientSettings$lambda$1).applyConnectionString(new ConnectionString(this.connectionString)).build();
        Intrinsics.checkNotNullExpressionValue((Object)mongoClientSettings, (String)"build(...)");
        return mongoClientSettings;
    }

    private static final void createClientSettings$lambda$0(SocketSettings.Builder it) {
        it.readTimeout(5, TimeUnit.SECONDS);
    }

    private static final void createClientSettings$lambda$1(ClusterSettings.Builder it) {
        it.serverSelectionTimeout(5L, TimeUnit.SECONDS);
    }
}

