/*
 * Decompiled with CFR 0.152.
 */
package world.avionik.database.simplified.kubernetes;

import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\b\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\fJ\u0018\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lworld/avionik/database/simplified/kubernetes/KubernetesSecrets;", "", "()V", "namespace", "", "kotlin.jvm.PlatformType", "getNamespace", "()Ljava/lang/String;", "createSecret", "", "secretName", "secrets", "", "getSecret", "Lio/fabric8/kubernetes/api/model/Secret;", "database-simplified-kit"})
public final class KubernetesSecrets {
    @NotNull
    public static final KubernetesSecrets INSTANCE = new KubernetesSecrets();
    private static final String namespace = new KubernetesClientBuilder().build().getNamespace();

    private KubernetesSecrets() {
    }

    public final String getNamespace() {
        return namespace;
    }

    public final void createSecret(@NotNull String namespace, @NotNull String secretName, @NotNull Map<String, String> secrets) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)secretName, (String)"secretName");
        Intrinsics.checkNotNullParameter(secrets, (String)"secrets");
        Secret secret = new Secret();
        secret.setMetadata(((ObjectMetaBuilder)new ObjectMetaBuilder().withName(secretName)).build());
        secret.setData(secrets);
        KubernetesClient kubernetesClient = new KubernetesClientBuilder().build();
        ((Resource)((NonNamespaceOperation)kubernetesClient.secrets().inNamespace(namespace)).resource((Object)secret)).create();
    }

    @Nullable
    public final Secret getSecret(@NotNull String namespace, @NotNull String secretName) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)secretName, (String)"secretName");
        KubernetesClient kubernetesClient = new KubernetesClientBuilder().build();
        return (Secret)((Resource)((NonNamespaceOperation)kubernetesClient.secrets().inNamespace(namespace)).withName(secretName)).get();
    }
}

