/*
 * Decompiled with CFR 0.152.
 */
package world.avionik.database.simplified.jedis;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import world.avionik.database.simplified.jedis.JedisConfiguration;
import world.avionik.database.simplified.jedis.JedisSecretLoader;
import world.avionik.database.simplified.jedis.config.JedisConfig;
import world.avionik.database.simplified.jedis.config.JedisConfigLoader;
import world.avionik.database.simplified.kubernetes.KubernetesSecrets;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006J$\u0010\u0007\u001a\u00020\u00042\b\b\u0002\u0010\b\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\u00062\b\b\u0002\u0010\n\u001a\u00020\u0006J\u0010\u0010\u000b\u001a\u00020\u00042\b\b\u0002\u0010\f\u001a\u00020\u0006\u00a8\u0006\r"}, d2={"Lworld/avionik/database/simplified/jedis/JedisSettings;", "", "()V", "fromConfig", "Lworld/avionik/database/simplified/jedis/JedisConfiguration;", "path", "", "fromEnv", "host", "port", "password", "fromKubeSecret", "namespace", "database-simplified-kit"})
public final class JedisSettings {
    @NotNull
    public static final JedisSettings INSTANCE = new JedisSettings();

    private JedisSettings() {
    }

    @NotNull
    public final JedisConfiguration fromEnv(@NotNull String host, @NotNull String port, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)port, (String)"port");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        String string = System.getenv(host);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getenv(...)");
        String string2 = System.getenv(port);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getenv(...)");
        int n = Integer.parseInt(string2);
        String string3 = System.getenv(password);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getenv(...)");
        return new JedisConfiguration(string, n, string3);
    }

    public static /* synthetic */ JedisConfiguration fromEnv$default(JedisSettings jedisSettings, String string, String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string = "JEDIS_HOST";
        }
        if ((n & 2) != 0) {
            string2 = "JEDIS_PORT";
        }
        if ((n & 4) != 0) {
            string3 = "JEDIS_PASSWORD";
        }
        return jedisSettings.fromEnv(string, string2, string3);
    }

    @NotNull
    public final JedisConfiguration fromConfig(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        JedisConfig jedisConfig = (JedisConfig)new JedisConfigLoader(path).load();
        return new JedisConfiguration(jedisConfig.getHost(), jedisConfig.getPort(), jedisConfig.getPassword());
    }

    public static /* synthetic */ JedisConfiguration fromConfig$default(JedisSettings jedisSettings, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "database";
        }
        return jedisSettings.fromConfig(string);
    }

    @NotNull
    public final JedisConfiguration fromKubeSecret(@NotNull String namespace) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        return new JedisSecretLoader(namespace).get();
    }

    public static /* synthetic */ JedisConfiguration fromKubeSecret$default(JedisSettings jedisSettings, String string, int n, Object object) {
        if ((n & 1) != 0) {
            String string2 = KubernetesSecrets.INSTANCE.getNamespace();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-namespace>(...)");
            string = string2;
        }
        return jedisSettings.fromKubeSecret(string);
    }
}

