/*
 * Decompiled with CFR 0.152.
 */
package world.avionik.database.simplified.jedis;

import io.fabric8.kubernetes.api.model.Secret;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import world.avionik.database.simplified.jedis.JedisConfiguration;
import world.avionik.database.simplified.kubernetes.KubernetesSecrets;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006j\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003`\u0007H\u0002J\u0006\u0010\n\u001a\u00020\u000bJ\f\u0010\f\u001a\u00020\u0003*\u00020\u0003H\u0002R*\u0010\u0005\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006j\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lworld/avionik/database/simplified/jedis/JedisSecretLoader;", "", "namespace", "", "(Ljava/lang/String;)V", "defaultSecrets", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "secretName", "createSecret", "get", "Lworld/avionik/database/simplified/jedis/JedisConfiguration;", "decodeBase64", "database-simplified-kit"})
public final class JedisSecretLoader {
    @NotNull
    private final String namespace;
    @NotNull
    private final String secretName;
    @NotNull
    private final HashMap<String, String> defaultSecrets;

    public JedisSecretLoader(@NotNull String namespace) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        this.namespace = namespace;
        this.secretName = "jedis-secret";
        Pair[] pairArray = new Pair[]{new Pair((Object)"host", (Object)""), new Pair((Object)"port", (Object)""), new Pair((Object)"password", (Object)"")};
        this.defaultSecrets = MapsKt.hashMapOf((Pair[])pairArray);
    }

    private final HashMap<String, String> createSecret() {
        KubernetesSecrets.INSTANCE.createSecret(this.namespace, this.secretName, (Map<String, String>)this.defaultSecrets);
        return this.defaultSecrets;
    }

    @NotNull
    public final JedisConfiguration get() {
        Map secrets;
        String string;
        Secret secret = KubernetesSecrets.INSTANCE.getSecret(this.namespace, this.secretName);
        Map map = secret != null ? secret.getData() : null;
        if (map == null) {
            map = this.createSecret();
        }
        if ((string = (String)(secrets = map).get("host")) == null || (string = this.decodeBase64(string)) == null) {
            throw new NullPointerException("failed to find host");
        }
        String string2 = (String)secrets.get("port");
        if (string2 == null || (string2 = this.decodeBase64(string2)) == null) {
            throw new NullPointerException("failed to find port");
        }
        String string3 = (String)secrets.get("password");
        if (string3 == null || (string3 = this.decodeBase64(string3)) == null) {
            throw new NullPointerException("failed to find password");
        }
        return new JedisConfiguration(string, Integer.parseInt(string2), string3);
    }

    private final String decodeBase64(String $this$decodeBase64) {
        byte[] byArray = Base64.getDecoder().decode($this$decodeBase64);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(...)");
        byte[] byArray2 = byArray;
        return new String(byArray2, Charsets.UTF_8);
    }
}

