/*
 * Decompiled with CFR 0.152.
 */
package world.avionik.database.simplified;

import com.arangodb.ArangoDB;
import com.mongodb.client.MongoClient;
import com.rabbitmq.client.Connection;
import dev.morphia.Datastore;
import dev.morphia.Morphia;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import redis.clients.jedis.JedisPool;
import world.avionik.database.simplified.DatabaseConfigurator;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B-\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u0003J\u0006\u0010\u0010\u001a\u00020\u0005J\u0006\u0010\u0011\u001a\u00020\tR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lworld/avionik/database/simplified/DatabaseSimplifiedKit;", "", "arangoDB", "Lcom/arangodb/ArangoDB;", "jedisPool", "Lredis/clients/jedis/JedisPool;", "mongoClient", "Lcom/mongodb/client/MongoClient;", "rabbitConnection", "Lcom/rabbitmq/client/Connection;", "(Lcom/arangodb/ArangoDB;Lredis/clients/jedis/JedisPool;Lcom/mongodb/client/MongoClient;Lcom/rabbitmq/client/Connection;)V", "createMorphiaDatastore", "Ldev/morphia/Datastore;", "dbName", "", "getArangoDB", "getJedisPool", "getRabbitConnection", "Companion", "database-simplified-kit"})
public final class DatabaseSimplifiedKit {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final ArangoDB arangoDB;
    @Nullable
    private final JedisPool jedisPool;
    @Nullable
    private final MongoClient mongoClient;
    @Nullable
    private Connection rabbitConnection;
    private static DatabaseSimplifiedKit instance;

    public DatabaseSimplifiedKit(@Nullable ArangoDB arangoDB, @Nullable JedisPool jedisPool, @Nullable MongoClient mongoClient, @Nullable Connection rabbitConnection) {
        this.arangoDB = arangoDB;
        this.jedisPool = jedisPool;
        this.mongoClient = mongoClient;
        this.rabbitConnection = rabbitConnection;
        instance = this;
    }

    @NotNull
    public final Datastore createMorphiaDatastore(@NotNull String dbName) {
        Intrinsics.checkNotNullParameter((Object)dbName, (String)"dbName");
        if (this.mongoClient == null) {
            throw new IllegalStateException("No morphia database has been set up");
        }
        Datastore datastore = Morphia.createDatastore((MongoClient)this.mongoClient, (String)dbName);
        datastore.ensureIndexes();
        Intrinsics.checkNotNull((Object)datastore);
        return datastore;
    }

    @NotNull
    public final JedisPool getJedisPool() {
        JedisPool jedisPool = this.jedisPool;
        if (jedisPool == null) {
            throw new IllegalStateException("No jedis database has been set up");
        }
        return jedisPool;
    }

    @NotNull
    public final ArangoDB getArangoDB() {
        ArangoDB arangoDB = this.arangoDB;
        if (arangoDB == null) {
            throw new IllegalStateException("No arangoDB database has been set up");
        }
        return arangoDB;
    }

    @NotNull
    public final Connection getRabbitConnection() {
        Connection connection = this.rabbitConnection;
        if (connection == null) {
            throw new IllegalStateException("No rabbitMQ database has been set up");
        }
        return connection;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\b\u001a\u00020\tR\u001e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lworld/avionik/database/simplified/DatabaseSimplifiedKit$Companion;", "", "()V", "<set-?>", "Lworld/avionik/database/simplified/DatabaseSimplifiedKit;", "instance", "getInstance", "()Lworld/avionik/database/simplified/DatabaseSimplifiedKit;", "createConfiguration", "Lworld/avionik/database/simplified/DatabaseConfigurator;", "database-simplified-kit"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DatabaseSimplifiedKit getInstance() {
            DatabaseSimplifiedKit databaseSimplifiedKit = instance;
            if (databaseSimplifiedKit != null) {
                return databaseSimplifiedKit;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"instance");
            return null;
        }

        @NotNull
        public final DatabaseConfigurator createConfiguration() {
            return new DatabaseConfigurator();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

