/*
 * Decompiled with CFR 0.152.
 */
package world.avionik.database.simplified;

import com.arangodb.ArangoDB;
import com.mongodb.client.MongoClient;
import com.rabbitmq.client.Connection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import redis.clients.jedis.JedisPool;
import world.avionik.database.simplified.DatabaseSimplifiedKit;
import world.avionik.database.simplified.arango.ArangoConfiguration;
import world.avionik.database.simplified.jedis.JedisConfiguration;
import world.avionik.database.simplified.morphia.MorphiaClientFactory;
import world.avionik.database.simplified.rabbitmq.RabbitMQConfiguration;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lworld/avionik/database/simplified/DatabaseConfigurator;", "", "()V", "arangoDB", "Lcom/arangodb/ArangoDB;", "jedisPool", "Lredis/clients/jedis/JedisPool;", "mongoClient", "Lcom/mongodb/client/MongoClient;", "rabbitConnection", "Lcom/rabbitmq/client/Connection;", "start", "Lworld/avionik/database/simplified/DatabaseSimplifiedKit;", "withArango", "configuration", "Lworld/avionik/database/simplified/arango/ArangoConfiguration;", "withJedis", "Lworld/avionik/database/simplified/jedis/JedisConfiguration;", "withMorphia", "connection", "", "withRabbitMQ", "Lworld/avionik/database/simplified/rabbitmq/RabbitMQConfiguration;", "database-simplified-kit"})
public final class DatabaseConfigurator {
    @Nullable
    private ArangoDB arangoDB;
    @Nullable
    private MongoClient mongoClient;
    @Nullable
    private JedisPool jedisPool;
    @Nullable
    private Connection rabbitConnection;

    @NotNull
    public final DatabaseConfigurator withMorphia(@NotNull String connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        this.mongoClient = new MorphiaClientFactory(connection).createClient();
        return this;
    }

    @NotNull
    public final DatabaseConfigurator withJedis(@NotNull JedisConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.jedisPool = configuration.createJedisPool();
        return this;
    }

    @NotNull
    public final DatabaseConfigurator withArango(@NotNull ArangoConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.arangoDB = configuration.createArango();
        return this;
    }

    @NotNull
    public final DatabaseConfigurator withRabbitMQ(@NotNull RabbitMQConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.rabbitConnection = configuration.createConnection();
        return this;
    }

    @NotNull
    public final DatabaseSimplifiedKit start() {
        return new DatabaseSimplifiedKit(this.arangoDB, this.jedisPool, this.mongoClient, this.rabbitConnection);
    }
}

