/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.clientserverapi.client;

import eu.thesimplecloud.clientserverapi.client.ClientConnection;
import eu.thesimplecloud.clientserverapi.client.NettyClient;
import eu.thesimplecloud.clientserverapi.lib.connection.AbstractNettyConnection;
import eu.thesimplecloud.clientserverapi.lib.connection.IConnection;
import eu.thesimplecloud.clientserverapi.lib.handler.IConnectionHandler;
import eu.thesimplecloud.clientserverapi.lib.handler.packet.AbstractChannelInboundHandlerImpl;
import io.netty.channel.ChannelHandlerContext;
import java.io.IOException;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0017J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Leu/thesimplecloud/clientserverapi/client/NettyClientHandler;", "Leu/thesimplecloud/clientserverapi/lib/handler/packet/AbstractChannelInboundHandlerImpl;", "nettyClient", "Leu/thesimplecloud/clientserverapi/client/NettyClient;", "connectionHandler", "Leu/thesimplecloud/clientserverapi/lib/handler/IConnectionHandler;", "(Leu/thesimplecloud/clientserverapi/client/NettyClient;Leu/thesimplecloud/clientserverapi/lib/handler/IConnectionHandler;)V", "channelActive", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "channelInactive", "exceptionCaught", "cause", "", "getConnection", "Leu/thesimplecloud/clientserverapi/lib/connection/AbstractNettyConnection;", "clientserverapi"})
public final class NettyClientHandler
extends AbstractChannelInboundHandlerImpl {
    @NotNull
    private final NettyClient nettyClient;
    @NotNull
    private final IConnectionHandler connectionHandler;

    public NettyClientHandler(@NotNull NettyClient nettyClient, @NotNull IConnectionHandler connectionHandler) {
        Intrinsics.checkNotNullParameter((Object)nettyClient, (String)"nettyClient");
        Intrinsics.checkNotNullParameter((Object)connectionHandler, (String)"connectionHandler");
        this.nettyClient = nettyClient;
        this.connectionHandler = connectionHandler;
    }

    @Override
    @NotNull
    public AbstractNettyConnection getConnection(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        IConnection iConnection = this.nettyClient.getConnection();
        Intrinsics.checkNotNull((Object)iConnection, (String)"null cannot be cast to non-null type eu.thesimplecloud.clientserverapi.lib.connection.AbstractNettyConnection");
        return (AbstractNettyConnection)iConnection;
    }

    public void channelActive(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        IConnection iConnection = this.nettyClient.getConnection();
        Intrinsics.checkNotNull((Object)iConnection, (String)"null cannot be cast to non-null type eu.thesimplecloud.clientserverapi.client.ClientConnection");
        ((ClientConnection)iConnection).sendAllQueuedPackets();
        this.connectionHandler.onConnectionActive(this.nettyClient.getConnection());
    }

    public void channelInactive(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.connectionHandler.onConnectionInactive(this.nettyClient.getConnection());
    }

    @Deprecated(message="Deprecated in Java")
    public void exceptionCaught(@NotNull ChannelHandlerContext ctx, @NotNull Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        if (cause instanceof IOException) {
            String string = cause.getMessage();
            boolean bl = string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"reset by peer", (boolean)false, (int)2, null) : false;
            if (bl) {
                return;
            }
        }
        if (!this.nettyClient.getConnection().wasConnectionCloseIntended()) {
            this.connectionHandler.onFailure(this.nettyClient.getConnection(), cause);
        }
    }
}

