/*
 * Decompiled with CFR 0.152.
 */
package net.suuft.yookassa.type;

import java.math.BigDecimal;
import net.suuft.yookassa.utility.JsonUtil;

public class PaymentRequest {
    public final AmountType amount;
    public final ConfirmationType confirmation;
    public final boolean capture;
    public final String description;

    public static PaymentRequest create(BigDecimal value, String currency, String urlRedirect, String description) {
        return new PaymentRequest(new AmountType(value, currency), new ConfirmationType(urlRedirect), true, description);
    }

    public String toJson() {
        return JsonUtil.toJson(this);
    }

    public PaymentRequest(AmountType amount, ConfirmationType confirmation, boolean capture, String description) {
        this.amount = amount;
        this.confirmation = confirmation;
        this.capture = capture;
        this.description = description;
    }

    private static class ConfirmationType {
        public final String type = "redirect";
        public final String return_url;

        public ConfirmationType(String url) {
            this.return_url = url;
        }
    }

    public static class AmountType {
        public final BigDecimal value;
        public final String currency;

        public AmountType(BigDecimal value, String currency) {
            this.value = value;
            this.currency = currency;
        }
    }
}

