/*
 * Decompiled with CFR 0.152.
 */
package net.suuft.shadowsocks.implementation;

import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Scanner;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import lombok.NonNull;
import net.suuft.shadowsocks.ShadowsocksWrapper;
import net.suuft.shadowsocks.gson.GsonUtil;
import net.suuft.shadowsocks.implementation.model.Response;
import net.suuft.shadowsocks.model.OutlineKey;
import net.suuft.shadowsocks.model.OutlineKeyList;
import net.suuft.shadowsocks.model.OutlineServer;

public class RealShadowsocksWrapper
implements ShadowsocksWrapper {
    private String apiAddress;

    @Override
    public OutlineKeyList getKeys() {
        return GsonUtil.unparseJson(this.getResponse((String)"/access-keys", (String)"GET", null).responseString, OutlineKeyList.class);
    }

    @Override
    public OutlineKey generateKey() {
        return GsonUtil.unparseJson(this.getResponse((String)"/access-keys", (String)"POST", null).responseString, OutlineKey.class);
    }

    @Override
    public boolean removeKey(int keyIdentifier) {
        return this.getResponse((String)new StringBuilder().append((String)"/access-keys/").append((int)keyIdentifier).toString(), (String)"DELETE", null).responseCode == 204;
    }

    @Override
    public OutlineServer getServerInformation() {
        return GsonUtil.unparseJson(this.getResponse((String)"/server", (String)"GET", null).responseString, OutlineServer.class);
    }

    private Response getResponse(@NonNull String requestAddress, @NonNull String method, String writableJson) {
        if (requestAddress == null) {
            throw new NullPointerException("requestAddress is marked non-null but is null");
        }
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        try {
            URL url = new URL(this.apiAddress + requestAddress);
            HttpsURLConnection httpConn = (HttpsURLConnection)url.openConnection();
            httpConn.setRequestMethod(method);
            this.removeSSLVerifier(httpConn);
            if (writableJson != null) {
                httpConn.setDoOutput(true);
                OutputStreamWriter writer = new OutputStreamWriter(httpConn.getOutputStream());
                writer.write(writableJson);
                writer.flush();
                writer.close();
                httpConn.getOutputStream().close();
            }
            InputStream responseStream = httpConn.getResponseCode() / 100 == 2 ? httpConn.getInputStream() : httpConn.getErrorStream();
            Scanner s = new Scanner(responseStream).useDelimiter("\\A");
            String response = s.hasNext() ? s.next() : "";
            return new Response(httpConn.getResponseCode(), response);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void removeSSLVerifier(@NonNull HttpsURLConnection connection) {
        if (connection == null) {
            throw new NullPointerException("connection is marked non-null but is null");
        }
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }
        }};
        SSLContext sc = null;
        try {
            sc = SSLContext.getInstance("SSL");
        }
        catch (NoSuchAlgorithmException e) {
            System.out.println(e.getMessage());
        }
        try {
            sc.init(null, trustAllCerts, new SecureRandom());
        }
        catch (KeyManagementException e) {
            System.out.println(e.getMessage());
        }
        connection.setSSLSocketFactory(sc.getSocketFactory());
        HostnameVerifier validHosts = new HostnameVerifier(){

            @Override
            public boolean verify(String arg0, SSLSession arg1) {
                return true;
            }
        };
        connection.setHostnameVerifier(validHosts);
    }

    public RealShadowsocksWrapper(String apiAddress) {
        this.apiAddress = apiAddress;
    }
}

