/*
 * Decompiled with CFR 0.152.
 */
package net.suuft.bukkitlib.util;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import lombok.NonNull;
import org.bukkit.entity.Player;

public final class DelayUtil {
    private static final Table<String, String, Long> delayTable = HashBasedTable.create();

    public static void putDelay(@NonNull String delayName, @NonNull Player player, long mills) {
        if (delayName == null) {
            throw new NullPointerException("delayName is marked non-null but is null");
        }
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        delayTable.put((Object)delayName, (Object)player.getName(), (Object)(System.currentTimeMillis() + mills));
    }

    public static long getDelay(@NonNull String delayName, @NonNull Player player) {
        if (delayName == null) {
            throw new NullPointerException("delayName is marked non-null but is null");
        }
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        Long playerDelay = (Long)delayTable.get((Object)delayName, (Object)player.getName());
        return playerDelay == null ? 0L : playerDelay - System.currentTimeMillis();
    }

    public static void removeDelay(@NonNull String delayName, @NonNull Player player) {
        if (delayName == null) {
            throw new NullPointerException("delayName is marked non-null but is null");
        }
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        delayTable.remove((Object)delayName, (Object)player.getName());
    }

    public static boolean hasDelay(@NonNull String delayName, @NonNull Player player) {
        if (delayName == null) {
            throw new NullPointerException("delayName is marked non-null but is null");
        }
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        return DelayUtil.getDelay(delayName, player) > 0L;
    }

    private DelayUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

