/*
 * Decompiled with CFR 0.152.
 */
package net.suuft.bukkitlib.gui;

import java.util.Iterator;
import net.suuft.bukkitlib.gui.EveryInventory;
import net.suuft.bukkitlib.gui.GuiItem;
import net.suuft.bukkitlib.gui.GuiService;
import net.suuft.bukkitlib.util.DelayUtil;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;

public class GuiListener
implements Listener {
    private GuiService guiService;

    @EventHandler(priority=EventPriority.MONITOR)
    private void onInventoryClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        EveryInventory gui = this.guiService.get(player);
        if (gui == null) {
            return;
        }
        Inventory inventory = event.getView().getTopInventory();
        if (!gui.getViewer().getName().equals(player.getName())) {
            return;
        }
        event.setCancelled(event.getClick().isShiftClick());
        int slot = event.getRawSlot();
        if (slot >= 0 && slot < inventory.getSize()) {
            event.setCancelled(true);
            GuiItem guiItem = gui.getItem(slot);
            if (guiItem == null || inventory.getItem(slot) == null) {
                return;
            }
            if (guiItem.getAction() == null) {
                return;
            }
            if (DelayUtil.hasDelay("gui_click", player)) {
                return;
            }
            DelayUtil.putDelay("gui_click", player, 200L);
            guiItem.getAction().accept(player, event);
        }
    }

    @EventHandler
    private void onInventoryDrag(InventoryDragEvent event) {
        Player player = (Player)event.getWhoClicked();
        EveryInventory gui = this.guiService.get(player);
        if (gui == null) {
            return;
        }
        if (!player.getName().equalsIgnoreCase(gui.getViewer().getName())) {
            return;
        }
        Iterator iterator = event.getRawSlots().iterator();
        while (iterator.hasNext()) {
            int slot = (Integer)iterator.next();
            if (slot < 0 || slot >= gui.getSize()) continue;
            event.setCancelled(true);
        }
    }

    @EventHandler
    private void onInventoryClose(InventoryCloseEvent e) {
        Player player = (Player)e.getPlayer();
        this.guiService.close(player);
    }

    @EventHandler
    private void onInventoryClose(PlayerQuitEvent e) {
        Player player = e.getPlayer();
        this.guiService.close(player);
    }

    @EventHandler
    private void onInventoryClose(PlayerChangedWorldEvent e) {
        Player player = e.getPlayer();
        this.guiService.close(player);
    }

    public GuiListener(GuiService guiService) {
        this.guiService = guiService;
    }
}

