/*
 * Decompiled with CFR 0.152.
 */
package net.suuft.bukkitlib.command.implementation;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.NonNull;
import net.suuft.bukkitlib.command.CommandProcessor;
import net.suuft.bukkitlib.command.CommandService;
import net.suuft.bukkitlib.command.annotation.CommandPermission;
import net.suuft.bukkitlib.command.annotation.RepeatableCommandAlias;
import net.suuft.bukkitlib.command.proxy.CommandExecutorProxy;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.plugin.Plugin;

public class CommandServiceImpl
implements CommandService {
    private CommandMap commandMap;
    private Map<Class<? extends CommandProcessor>, CommandExecutorProxy> classProxyMap = new HashMap<Class<? extends CommandProcessor>, CommandExecutorProxy>();
    private final Plugin plugin;

    @Override
    public void registerCommand(@NonNull CommandProcessor processor) {
        if (processor == null) {
            throw new NullPointerException("processor is marked non-null but is null");
        }
        try {
            RepeatableCommandAlias repeatableCommandAlias = processor.getClass().getAnnotation(RepeatableCommandAlias.class);
            CommandPermission commandPermission = processor.getClass().getAnnotation(CommandPermission.class);
            if (repeatableCommandAlias == null || repeatableCommandAlias.value().length < 1) {
                throw new IllegalArgumentException("Please put @CommandAlias annotation(s) to setup command names!");
            }
            List<String> aliases = Arrays.stream(repeatableCommandAlias.value()).map(a -> a.value()).collect(Collectors.toList());
            String name = (String)aliases.get(0);
            aliases.remove(name);
            CommandExecutorProxy command = new CommandExecutorProxy(name, aliases, commandPermission == null ? null : commandPermission.value(), processor);
            command.setLabel(command.getName());
            this.checkCommandMap();
            this.commandMap.register(this.plugin.getName(), (Command)command);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void registerCommand(@NonNull Class<? extends CommandProcessor> processor) {
        if (processor == null) {
            throw new NullPointerException("processor is marked non-null but is null");
        }
        try {
            this.registerCommand(processor.newInstance());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void unregisterCommand(@NonNull Class<? extends CommandProcessor> processor) {
        if (processor == null) {
            throw new NullPointerException("processor is marked non-null but is null");
        }
        CommandExecutorProxy proxy = this.classProxyMap.get(processor);
        if (proxy == null) {
            return;
        }
        try {
            this.checkCommandMap();
            Field field = Bukkit.getServer().getClass().getDeclaredField("knownCommands");
            field.setAccessible(true);
            Map stringCommandMap = (Map)field.get(this.commandMap);
            Command command1 = (Command)stringCommandMap.get(proxy.getLabel());
            stringCommandMap.remove(command1.getName());
            command1.getAliases().forEach(stringCommandMap::remove);
            this.classProxyMap.remove(processor);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void checkCommandMap() throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        if (this.commandMap == null) {
            String version = Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3];
            Class<?> craftServerClass = Class.forName("org.bukkit.craftbukkit." + version + ".CraftServer");
            Object craftServerObject = craftServerClass.cast(Bukkit.getServer());
            Field commandMapField = craftServerClass.getDeclaredField("commandMap");
            commandMapField.setAccessible(true);
            this.commandMap = (SimpleCommandMap)commandMapField.get(craftServerObject);
        }
    }

    public CommandServiceImpl(Plugin plugin) {
        this.plugin = plugin;
    }
}

