/*
 * Decompiled with CFR 0.152.
 */
package works.lmz.util;

import com.bluetrainsoftware.classpathscanner.ClasspathScanner;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.stickycode.stereotype.configured.PostConfigured;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import works.lmz.common.Flags;
import works.lmz.common.stereotypes.SingletonBean;
import works.lmz.util.AppVersion;

@SingletonBean
public class LmzAppVersion
implements AppVersion,
GroovyObject {
    private static Logger log;
    public static final String KEY_IMPLEMENTATION_VERSION = "Implementation-Version";
    public static final String DEFAULT = "unknown";
    protected String version;
    private boolean initialized;
    public static final Map<String, GroupArtifactVersion> classpathGavs;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public LmzAppVersion() {
        MetaClass metaClass;
        boolean bl;
        String string;
        this.version = string = DEFAULT;
        this.initialized = bl = false;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    private static Element findChildElement(Node node, String element) {
        Node child = node.getFirstChild();
        while (child != null) {
            Node node2;
            if (child.getNodeName().equals(element)) {
                return (Element)ScriptBytecodeAdapter.castToType((Object)child, Element.class);
            }
            child = node2 = child.getNextSibling();
        }
        return (Element)ScriptBytecodeAdapter.castToType(null, Element.class);
    }

    private static Element findChild(Node node, String element) {
        Element el = LmzAppVersion.findChildElement(node, element);
        if (el != null) {
            return el;
        }
        Element parent = LmzAppVersion.findChild(node, "parent");
        return (Element)ScriptBytecodeAdapter.castToType((Object)(parent != null ? LmzAppVersion.findChildElement(parent, element) : null), Element.class);
    }

    public static String parseGAVfromPOM(File projDir) {
        if (projDir.getName().equals("pom.xml")) {
            File file;
            projDir = file = projDir.getParentFile();
        }
        File pom = new File(projDir, "pom.xml");
        if (!pom.exists()) {
            throw (Throwable)new RuntimeException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{projDir.getAbsolutePath()}, new String[]{"Unable to find pom.xml in ", ""})));
        }
        Document doc = null;
        try {
            Document document;
            doc = document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(pom);
        }
        catch (SAXException e) {
            throw (Throwable)new RuntimeException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{projDir.getAbsolutePath()}, new String[]{"Cannot parse ", ""})), e);
        }
        catch (IOException e) {
            throw (Throwable)new RuntimeException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{projDir.getAbsolutePath()}, new String[]{"Cannot parse ", ""})), e);
        }
        catch (ParserConfigurationException e) {
            throw (Throwable)new RuntimeException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{projDir.getAbsolutePath()}, new String[]{"Cannot parse ", ""})), e);
        }
        doc.getDocumentElement().normalize();
        NodeList projectNode = doc.getElementsByTagName("project");
        if (projectNode.getLength() < 1) {
            throw (Throwable)new RuntimeException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{projDir.getAbsolutePath()}, new String[]{"Improperly formed pom.xml file in ", ""})));
        }
        GroupArtifactVersion gav = new GroupArtifactVersion();
        Node project = projectNode.item(0);
        String string = LmzAppVersion.findChild(project, "groupId").getTextContent();
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)gav, (String)"groupId");
        String string2 = LmzAppVersion.findChild(project, "artifactId").getTextContent();
        ScriptBytecodeAdapter.setProperty((Object)string2, null, (Object)gav, (String)"artfiactId");
        String string3 = LmzAppVersion.findChild(project, "version").getTextContent();
        ScriptBytecodeAdapter.setProperty((Object)string3, null, (Object)gav, (String)"version");
        log.info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{gav.groupId, gav.artfiactId, gav.version, projDir.getAbsolutePath()}, new String[]{"loaded pom: ", ":", ":", " as key: ", ""})));
        classpathGavs.put(projDir.getAbsolutePath(), gav);
        return gav.version;
    }

    protected String getManifestVersion() {
        String string = System.getProperty("Bathe-Implementation-Version");
        return string != null ? string.toString() : null;
    }

    @PostConfigured
    public void configured() {
        String string;
        boolean bl;
        if (this.initialized) {
            return;
        }
        this.initialized = bl = true;
        this.version = string = this.getManifestVersion();
        if (this.version == null && Flags.DEVMODE.on()) {
            File basePath = ClasspathScanner.findTestClassesBasePath();
            if (DefaultTypeTransformation.booleanUnbox((Object)basePath)) {
                String string2;
                this.version = string2 = LmzAppVersion.parseGAVfromPOM(basePath);
            }
        }
        if (this.version == null) {
            throw (Throwable)new RuntimeException("Unable to detect the version of the running application, all server side APIs will be unreliable, failing.");
        }
        if (this.version.endsWith("-SNAPSHOT")) {
            String string3;
            this.version = string3 = this.version.replace("-SNAPSHOT", StringGroovyMethods.plus((String)"-", (CharSequence)Long.toHexString(System.currentTimeMillis())));
        }
    }

    public String getVersion() {
        this.configured();
        return this.version;
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(LmzAppVersion.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, LmzAppVersion.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(LmzAppVersion.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != LmzAppVersion.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger(LmzAppVersion.class);
        HashMap<String, GroupArtifactVersion> hashMap = new HashMap<String, GroupArtifactVersion>();
        classpathGavs = hashMap;
    }

    public static class GroupArtifactVersion
    implements GroovyObject {
        public String groupId;
        public String artfiactId;
        public String version;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;

        public GroupArtifactVersion() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(GroupArtifactVersion.class, LmzAppVersion.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, LmzAppVersion.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(GroupArtifactVersion.class, LmzAppVersion.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != GroupArtifactVersion.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }
    }
}

