/*
 * Decompiled with CFR 0.152.
 */
package works.lmz.syllabus.apidoc;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import works.lmz.common.stereotypes.SingletonBean;
import works.lmz.syllabus.SyllabusContext;
import works.lmz.syllabus.apidoc.Endpoint;
import works.lmz.syllabus.apidoc.utils.GenericUtils;
import works.lmz.syllabus.events.EventHandler;
import works.lmz.syllabus.events.EventHandlerCollection;
import works.lmz.syllabus.generator.EventHandlerConfig;

@SingletonBean
public class SyllabusInspector {
    private static final int IDX_INPUT_STRUCT = 0;
    private static final int IDX_OUTPUT_STRUCT = 1;
    @Inject
    private EventHandlerCollection eventHandlerCollection;
    private List<Endpoint> endpoint;

    @PostConstruct
    public void afterInitialization() {
        this.endpoint = new ArrayList<Endpoint>();
        for (EventHandlerConfig handler : this.eventHandlerCollection.findAll()) {
            Class inputClazz = null;
            if (handler.getParamaterTypes().length > 1) {
                inputClazz = handler.getParamaterTypes()[0].getTheClass() != SyllabusContext.class ? handler.getParamaterTypes()[0].getTheClass() : handler.getParamaterTypes()[1].getTheClass();
            } else if (handler.getParamaterTypes().length == 1) {
                inputClazz = handler.getParamaterTypes()[0].getTheClass();
            }
            Class outputClazz = handler.getMethod().getReturnType();
            this.endpoint.add(new Endpoint(handler.getInstance().getClass(), inputClazz, outputClazz));
        }
    }

    public Set<String> getNamespaces() {
        HashSet<String> namespaces = new HashSet<String>();
        for (Endpoint endpoint : this.endpoint) {
            namespaces.add(endpoint.getNamespace());
        }
        return namespaces;
    }

    public List<Endpoint> getEndpointsInNamespace(String namespace) {
        ArrayList<Endpoint> endpointList = new ArrayList<Endpoint>();
        for (Endpoint endpoint : this.endpoint) {
            if (!namespace.equals(endpoint.getNamespace())) continue;
            endpointList.add(endpoint);
        }
        return endpointList;
    }

    public Map<String, List<Endpoint>> getEndpointsByNamespace() {
        Set<String> namespaces = this.getNamespaces();
        LinkedHashMap<String, List<Endpoint>> endpointsByNs = new LinkedHashMap<String, List<Endpoint>>();
        for (String namespace : namespaces) {
            endpointsByNs.put(namespace, this.getEndpointsInNamespace(namespace));
        }
        return endpointsByNs;
    }

    protected Class<?> getInputClassForHandler(EventHandler handler) {
        return GenericUtils.getGenericClassAtIndexForEvent(handler.getClass(), 0);
    }

    protected Class<?> getOutputClassForHandler(EventHandler handler) {
        return GenericUtils.getGenericClassAtIndexForEvent(handler.getClass(), 1);
    }
}

