/*
 * Decompiled with CFR 0.152.
 */
package works.lmz.war;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.concurrent.CountDownLatch;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SessionManager;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.eclipse.jetty.server.session.AbstractSessionManager;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.WebAppContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import works.lmz.jetty.RemoteUserSecurityHandler;
import works.lmz.war.MetaDataHandler;
import works.lmz.war.ShutdownWatcher;
import works.lmz.war.StdinWatcher;
import works.lmz.war.WebAppLockFile;
import works.lmz.war.WebApplicationSimpleContext;

public class WebAppRunner {
    public static final String WEBAPP_HTTP_PORT_PROPERTY = "webapp.http.port";
    public static final String WEBAPP_CONTEXT_PROPERTY = "webapp.context";
    public static final String WEBAPP_SHUTDOWN_STDIN_PROPERTY = "webapp.shutdown.stdin";
    public static final String WEBAPP_SHUTDOWN_TIMEOUT_PROPERTY = "webapp.shutdown.timeout";
    public static final String WEBAPP_LOCKFILE_PROPERTY = "webapp.lockfile";
    public static final String WEBAPP_WEBDEFAULT_XML_LOCATION = "webapp.webdefaultxml";
    public static final String WEBAPP_SECURE_COOKIES_PROPERTY = "webapp.cookies.secure";
    public static final String WEBAPP_EXTRA_CONFIGURATION_CLASSES = "webapp.configClasses";
    public static final String WEBAPP_WAR_FILENAME = "webapp.warFile";
    public static final String WEBAPP_REQUEST_HEADER_SIZE = "webapp.header.request.size";
    public static final String WEBAPP_RESPONSE_HEADER_SIZE = "webapp.header.response.size";
    public static final String WEBAPP_HEADER_CACHE_SIZE = "webapp.header.cache.size";
    public static final String WEBAPP_OUTPUT_BUFFER_SIZE = "webapp.output.buffer.size";
    public static final String WEBDEFAULT_XML = "works/lmz/war/webdefault.xml";
    public static final String WEBDEFAULT_DEV_XML = "works/lmz/war/webdefault-dev.xml";
    protected static final int WEBAPP_HTTP_PORT_DEFAULT = 8090;
    protected static final int WEBAPP_SHUTDOWN_TIMEOUT_DEFAULT = 12000;
    protected static final String WEBAPP_CONTEXT_DEFAULT = "/";
    protected static final int HEADER_SIZE_BASE = 1024;
    protected static final int WEBAPP_REQUEST_HEADER_SIZE_DEFAULT = 8;
    protected static final int WEBAPP_RESPONSE_HEADER_SIZE_DEFAULT = 8;
    protected static final int WEBAPP_OUTPUT_BUFFER_SIZE_DEFAULT = 32;
    protected static final int WEBAPP_HEADER_CACHE_SIZE_DEFAULT = 1;
    private static String[] JETTY_CONFIGURATION_CLASSES = new String[]{"ScanConfiguration", "ScannedWebXmlConfiguration", "org.eclipse.jetty.webapp.JettyWebXmlConfiguration"};
    private static final Logger log = LoggerFactory.getLogger(WebAppRunner.class);
    private File war;
    private Server server;
    private HandlerList serverHandler;
    private StatisticsHandler statistics;
    private WebAppContext context;
    private WebAppLockFile lockfile;
    private int port;

    public static void run(File war) {
        WebAppRunner.run(war, null);
    }

    public static void run(File war, String[] args) {
        new WebAppRunner(war).run();
    }

    public WebAppRunner(File war) {
        if (war != null) {
            System.setProperty(WEBAPP_WAR_FILENAME, war.toURI().toString());
        }
        this.war = war;
    }

    protected void createServer() {
        Resource.setDefaultUseCaches((boolean)false);
        this.server = new Server();
        this.serverHandler = new HandlerList();
        this.server.setHandler((Handler)this.serverHandler);
    }

    protected void createConnector() {
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.addCustomizer(new HttpConfiguration.Customizer(){

            public void customize(Connector connector, HttpConfiguration channelConfig, Request request) {
                MetaDataHandler.rewriteProxyRequest(request);
            }
        });
        int request_header_size = Integer.getInteger(WEBAPP_REQUEST_HEADER_SIZE, 8);
        int response_header_size = Integer.getInteger(WEBAPP_RESPONSE_HEADER_SIZE, 8);
        int output_buffer_size = Integer.getInteger(WEBAPP_OUTPUT_BUFFER_SIZE, 32);
        int header_cache_size = Integer.getInteger(WEBAPP_HEADER_CACHE_SIZE, 1);
        httpConfig.setRequestHeaderSize(request_header_size * 1024);
        httpConfig.setResponseHeaderSize(response_header_size * 1024);
        httpConfig.setOutputBufferSize(output_buffer_size * 1024);
        httpConfig.setHeaderCacheSize(header_cache_size * 1024);
        ServerConnector connector = new ServerConnector(this.server, new ConnectionFactory[]{new HttpConnectionFactory(httpConfig)});
        this.port = Integer.getInteger(WEBAPP_HTTP_PORT_PROPERTY, 8090);
        connector.setPort(this.port);
        this.server.addConnector((Connector)connector);
    }

    protected boolean walkClasspathParentToFind(ClassLoader current) {
        if (this.getClass().getClassLoader() == current) {
            return true;
        }
        if (current == null) {
            return false;
        }
        return this.walkClasspathParentToFind(current.getParent());
    }

    protected void createContext() throws IOException, URISyntaxException {
        String webDefaultXml = WEBDEFAULT_XML;
        this.context = new WebApplicationSimpleContext(this.war == null ? "devmode" : this.war.toString(), System.getProperty(WEBAPP_CONTEXT_PROPERTY, WEBAPP_CONTEXT_DEFAULT));
        this.context.setClassLoader(this.getClass().getClassLoader());
        if (this.war == null) {
            if (this.walkClasspathParentToFind(Thread.currentThread().getContextClassLoader())) {
                this.context.setClassLoader(Thread.currentThread().getContextClassLoader());
            }
            webDefaultXml = WEBDEFAULT_DEV_XML;
        } else if (this.war.isDirectory()) {
            this.context.setBaseResource(Resource.newResource((URL)this.war.toURI().toURL()));
        } else {
            this.context.setBaseResource(Resource.newResource((URL)new URL("jar:file:" + this.war.getAbsolutePath() + "!/")));
        }
        this.context.setConfigurationClasses(this.getConfigurationClasses(JETTY_CONFIGURATION_CLASSES));
        if (System.getProperty(WEBAPP_WEBDEFAULT_XML_LOCATION) != null) {
            this.context.setDefaultsDescriptor(System.getProperty(WEBAPP_WEBDEFAULT_XML_LOCATION));
        } else {
            this.context.setDefaultsDescriptor(webDefaultXml);
        }
        this.context.setExtractWAR(false);
        this.context.setSecurityHandler((SecurityHandler)new RemoteUserSecurityHandler());
        SessionManager sessionManager = this.context.getSessionHandler().getSessionManager();
        if (!(sessionManager instanceof AbstractSessionManager)) {
            throw new RuntimeException("Cannot set secure cookies on session manager.");
        }
        AbstractSessionManager realSessionManager = (AbstractSessionManager)sessionManager;
        boolean allowCookiesToOnlyBePassedSecurely = Boolean.parseBoolean(System.getProperty(WEBAPP_SECURE_COOKIES_PROPERTY, "true"));
        realSessionManager.getSessionCookieConfig().setSecure(allowCookiesToOnlyBePassedSecurely);
        realSessionManager.setHttpOnly(true);
        this.createContextTempDirectory();
    }

    private String[] getConfigurationClasses(String[] jetty_configuration_classes) {
        String extra = System.getProperty(WEBAPP_EXTRA_CONFIGURATION_CLASSES);
        if (extra != null) {
            StringTokenizer st = new StringTokenizer(extra.trim(), ";");
            ArrayList<String> configClasses = new ArrayList<String>();
            while (st.hasMoreElements()) {
                configClasses.add(st.nextToken());
            }
            for (String configClass : jetty_configuration_classes) {
                configClasses.add(configClass);
            }
            return configClasses.toArray(new String[configClasses.size()]);
        }
        return jetty_configuration_classes;
    }

    protected void wrapHandlers() {
        MetaDataHandler wrapper = new MetaDataHandler();
        wrapper.setHandler((Handler)this.context);
        this.statistics = new StatisticsHandler();
        this.statistics.setHandler((Handler)wrapper);
        this.serverHandler.addHandler((Handler)this.statistics);
    }

    protected void createContextTempDirectory() {
        if (this.context.getTempDirectory() == null) {
            File tmpDir = new File(System.getProperty("java.io.tmpdir"));
            tmpDir.mkdirs();
            this.context.setTempDirectory(tmpDir);
        }
    }

    public void run() {
        try {
            this.createLockFile();
            try {
                this.start();
                this.waitForShutdown();
            }
            finally {
                this.stop();
            }
        }
        finally {
            this.releaseLockFile();
        }
    }

    protected void start() {
        try {
            log.info("Starting WebApp server");
            this.createServer();
            this.createConnector();
            this.createContext();
            this.wrapHandlers();
            this.server.start();
            Throwable error = this.context.getUnavailableException();
            if (error != null) {
                log.error("Jetty context startup failed", error);
                throw new RuntimeException("WebApp context startup is unavailable", error);
            }
            if (this.context.isFailed()) {
                throw new RuntimeException("WebApp context startup failed");
            }
            log.info("WebApp server started");
        }
        catch (Exception e) {
            throw new RuntimeException("WebApp server failed", e);
        }
    }

    protected void stop() {
        if (this.server == null) {
            log.error("Never started, can't stop!");
            return;
        }
        this.attemptCleanClose();
        try {
            log.info("jetty shutdown: stopping server");
            this.server.stop();
            log.info("WebApp server shutdown complete");
        }
        catch (Exception e) {
            throw new RuntimeException("WebApp server shutdown failed", e);
        }
        finally {
            this.statistics = null;
            this.server = null;
            this.context = null;
        }
    }

    private void attemptCleanClose() {
        long timeout = Integer.getInteger(WEBAPP_SHUTDOWN_TIMEOUT_PROPERTY, 12000).intValue();
        if (timeout > 0L) {
            log.info("jetty shutdown: requesting shutdown");
            try {
                int open;
                Connector[] connectors = this.server.getConnectors();
                if (connectors != null) {
                    for (Connector connector : connectors) {
                        connector.shutdown();
                    }
                }
                if ((open = this.statistics.getRequestsActive()) > 0) {
                    this.waitForConnections(timeout, open);
                }
            }
            catch (Exception e) {
                log.warn("jetty shutdown: formal shutdown failed", (Throwable)e);
            }
        }
    }

    private void waitForConnections(long timeout, int open) {
        block3: {
            log.info("jetty shutdown: {} requests are active, delaying for {} ms", (Object)open, (Object)timeout);
            timeout += System.currentTimeMillis();
            do {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    log.warn("jetty shutdown: clean shutdown failed sleep interval");
                }
                open = this.statistics.getRequestsActive();
                if (open <= 0) break block3;
            } while (System.currentTimeMillis() < timeout);
            log.warn("jetty shutdown: {} requests not finished, kicking them out", (Object)open);
        }
    }

    protected void createLockFile() {
        String file = System.getProperty(WEBAPP_LOCKFILE_PROPERTY);
        if (file != null && file.length() > 0) {
            this.lockfile = new WebAppLockFile(file);
            log.debug("Acquired lock file '{}'", (Object)this.lockfile);
        }
    }

    protected void releaseLockFile() {
        if (this.lockfile != null) {
            this.lockfile.release();
            log.debug("Released lock file '{}'", (Object)this.lockfile);
            this.lockfile = null;
        }
    }

    protected void waitForShutdown() {
        CountDownLatch latch = new CountDownLatch(1);
        try {
            try {
                Runtime.getRuntime().addShutdownHook(new Thread((Runnable)new ShutdownWatcher(latch), "shutdown-hook"));
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            if (Boolean.getBoolean(WEBAPP_SHUTDOWN_STDIN_PROPERTY)) {
                Thread stdin = new Thread((Runnable)new StdinWatcher(latch), "shutdown-stdin");
                stdin.setDaemon(true);
                stdin.start();
            }
            log.info("WebApp container is up and running on port {}", (Object)this.port);
            try {
                latch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        finally {
            latch.countDown();
        }
    }
}

