/*
 * Decompiled with CFR 0.152.
 */
package works.lmz.war;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;

public class WebAppLockFile {
    private final File file;
    private final FileChannel nioFile;

    public WebAppLockFile(String file) {
        this(new File(file));
    }

    public WebAppLockFile(File file) {
        try {
            this.file = file;
            this.nioFile = new RandomAccessFile(file, "rw").getChannel();
            if (this.nioFile.tryLock() == null) {
                throw new IllegalStateException("Looks like we are already running, our lock file is already locked");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Failed to lock file '%s'", file), e);
        }
    }

    public void release() {
        if (null == this.nioFile) {
            throw new IllegalStateException("Lock file was already release");
        }
        try {
            this.nioFile.close();
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Failed to close lock file '%s'", this.file), e);
        }
        finally {
            this.file.delete();
        }
    }

    public String toString() {
        return this.file.toString();
    }
}

