/*
 * Decompiled with CFR 0.152.
 */
package works.lmz.war;

import com.bluetrainsoftware.classpathscanner.ClasspathScanner;
import com.bluetrainsoftware.classpathscanner.ResourceScanListener;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.eclipse.jetty.webapp.AbstractConfiguration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import works.lmz.war.InMemoryResource;

public class ScanConfiguration
extends AbstractConfiguration {
    private Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static Resource webXml;
    protected static final Path PATH_TARGET_RESOURCES;
    protected static final Path PATH_TARGET_TEST_RESOURCES;
    public static String RESOURCE_URLS;
    private final boolean devMode = System.getProperty("webapp.warFile") == null;

    public void preConfigure(final WebAppContext context) throws Exception {
        InMemoryResource inMemoryResource;
        ArrayList<InMemoryResource> theResources = (ArrayList<InMemoryResource>)context.getAttribute(RESOURCE_URLS);
        if (theResources == null) {
            theResources = new ArrayList<InMemoryResource>();
            context.setAttribute(RESOURCE_URLS, theResources);
        }
        final ArrayList<InMemoryResource> resources = theResources;
        final ArrayList interesting = new ArrayList();
        InMemoryResource inMemoryResource2 = inMemoryResource = this.devMode ? null : new InMemoryResource();
        if (inMemoryResource != null) {
            resources.add(inMemoryResource);
        }
        ResourceScanListener listener = new ResourceScanListener(){

            public List<ResourceScanListener.ScanResource> resource(List<ResourceScanListener.ScanResource> scanResources) throws Exception {
                interesting.clear();
                for (ResourceScanListener.ScanResource scanResource : scanResources) {
                    if ("WEB-INF/web.xml".equals(scanResource.resourceName)) {
                        ScanConfiguration.this.foundWebXml(scanResource, context);
                        if (ScanConfiguration.this.log.isDebugEnabled()) {
                            ScanConfiguration.this.log.debug("webapp.scan: found web.xml {}", (Object)scanResource.getResolvedUrl().toString());
                        }
                        if (context.getBaseResource() != null) continue;
                        if (ScanConfiguration.this.log.isDebugEnabled()) {
                            ScanConfiguration.this.log.debug("webapp.scan: found base directory {}", (Object)Resource.newResource((URL)scanResource.offsetUrl).toString());
                        }
                        context.setBaseResource(Resource.newResource((URL)scanResource.offsetUrl));
                        continue;
                    }
                    if ("META-INF/resources/WEB-INF/web.xml".equals(scanResource.resourceName)) {
                        if (ScanConfiguration.this.log.isDebugEnabled()) {
                            ScanConfiguration.this.log.debug("webapp.scan: found web.xml {}", (Object)scanResource.getResolvedUrl().toString());
                        }
                        ScanConfiguration.this.foundWebXml(scanResource, context);
                        continue;
                    }
                    if ("META-INF/web-fragment.xml".equals(scanResource.resourceName)) {
                        URL resolvedUrl = scanResource.getResolvedUrl();
                        if (ScanConfiguration.this.log.isDebugEnabled()) {
                            ScanConfiguration.this.log.debug("webapp.scan: found web fragment {}", (Object)resolvedUrl.toString());
                        }
                        Resource fragmentResource = Resource.newResource((URL)scanResource.offsetUrl);
                        context.getMetaData().addWebInfJar(fragmentResource);
                        context.getMetaData().addFragment(fragmentResource, Resource.newResource((URL)resolvedUrl));
                        continue;
                    }
                    if (ScanConfiguration.this.devMode && ScanConfiguration.this.isWebResourceBase(scanResource)) {
                        for (URL resolvedUrl : ScanConfiguration.this.morphDevelopmentResource(scanResource)) {
                            if (ScanConfiguration.this.log.isDebugEnabled()) {
                                ScanConfiguration.this.log.debug("webapp.scan: found resource {}", (Object)resolvedUrl.toString());
                            }
                            resources.add(Resource.newResource((URL)resolvedUrl));
                        }
                        continue;
                    }
                    if (ScanConfiguration.this.devMode || ScanConfiguration.this.prefixWebResource(scanResource) == null) continue;
                    interesting.add(scanResource);
                }
                return interesting;
            }

            public void deliver(ResourceScanListener.ScanResource desire, InputStream inputStream) {
                ScanConfiguration.this.putResource(desire, ScanConfiguration.this.prefixWebResource(desire), inputStream, inMemoryResource);
            }

            public ResourceScanListener.InterestAction isInteresting(ResourceScanListener.InterestingResource interestingResource) {
                String url = interestingResource.url.toString();
                if (url.contains("jre") || url.contains("jdk")) {
                    return ResourceScanListener.InterestAction.NONE;
                }
                return ResourceScanListener.InterestAction.ONCE;
            }

            public void scanAction(ResourceScanListener.ScanAction action) {
                if (action == ResourceScanListener.ScanAction.COMPLETE) {
                    context.getMetaData().orderFragments();
                }
            }
        };
        ClasspathScanner scanner = ClasspathScanner.getInstance();
        scanner.registerResourceScanner(listener);
        scanner.scan(context.getClassLoader());
    }

    protected void putResource(ResourceScanListener.ScanResource desire, String stripPrefix, InputStream stream, InMemoryResource resource) {
        String resourceName = desire.resourceName;
        if (stripPrefix.length() > 0) {
            resourceName = resourceName.substring(stripPrefix.length());
        }
        String[] paths = resourceName.split("/");
        for (int count = 0; count < paths.length - 1; ++count) {
            InMemoryResource child = resource.findPath(paths[count]);
            if (child == null) {
                child = resource.addDirectory(paths[count]);
            }
            resource = child;
        }
        if (desire.entry.isDirectory()) {
            resource.addDirectory(paths[paths.length - 1]);
        } else {
            resource.addFile(paths[paths.length - 1], stream);
        }
    }

    protected String prefixWebResource(ResourceScanListener.ScanResource scanResource) {
        if (scanResource.resourceName.startsWith("META-INF/resources/")) {
            return "META-INF/resources/";
        }
        return null;
    }

    protected void foundWebXml(ResourceScanListener.ScanResource scanResource, WebAppContext context) throws Exception {
        if (context.getMetaData().getWebXml() == null) {
            webXml = Resource.newResource((URL)scanResource.getResolvedUrl());
            if (this.log.isDebugEnabled()) {
                this.log.debug("webapp.scan: found web.xml {}", (Object)webXml.toString());
            }
            context.getMetaData().setWebXml(webXml);
        } else {
            this.log.info("Found extra web.xml, ignoring {}", (Object)scanResource.getResolvedUrl().toString());
        }
    }

    protected boolean isWebResourceBase(ResourceScanListener.ScanResource scanResource) {
        return scanResource.resourceName.equals("META-INF/resources") || scanResource.resourceName.equals("META-INF/resources/") || scanResource.file == null && scanResource.offsetUrl.toString().endsWith("!WEB-INF/classes/") || scanResource.file != null && scanResource.file.isDirectory() && (scanResource.file.getAbsolutePath().endsWith("/src/main/webapp") || scanResource.file.getAbsolutePath().endsWith("/src/test/webapp"));
    }

    protected List<URL> morphDevelopmentResource(ResourceScanListener.ScanResource scanResource) {
        ArrayList<URL> resolvedUrls = new ArrayList<URL>();
        URL resolved = scanResource.getResolvedUrl();
        if (scanResource.file != null && scanResource.file.isDirectory()) {
            Path absoluteFilePath = scanResource.file.toPath();
            URL newUrl = null;
            try {
                if (absoluteFilePath.endsWith(PATH_TARGET_TEST_RESOURCES)) {
                    newUrl = new File(scanResource.file.getParentFile().getParentFile().getParentFile().getParentFile(), "src/test/resources/META-INF/resources").toURI().toURL();
                } else if (absoluteFilePath.endsWith(PATH_TARGET_RESOURCES)) {
                    newUrl = new File(scanResource.file.getParentFile().getParentFile().getParentFile().getParentFile(), "src/main/resources/META-INF/resources").toURI().toURL();
                }
            }
            catch (MalformedURLException mue) {
                this.log.error("Unable to morph {} to development resource, this is unexpected, be warned!", (Object)resolved.toString());
            }
            if (newUrl != null) {
                resolvedUrls.add(newUrl);
            }
        }
        resolvedUrls.add(resolved);
        return resolvedUrls;
    }

    public void configure(WebAppContext context) throws Exception {
        List resources = (List)context.getAttribute(RESOURCE_URLS);
        if (resources != null) {
            if (resources.size() > 1) {
                Resource[] collection = new Resource[resources.size() + 1];
                int i = 0;
                collection[i++] = context.getBaseResource();
                for (Resource resource : resources) {
                    collection[i++] = resource;
                }
                context.setBaseResource((Resource)new ResourceCollection(collection));
            } else {
                context.setBaseResource((Resource)resources.get(0));
            }
        }
    }

    static {
        PATH_TARGET_RESOURCES = Paths.get("target/classes/META-INF/resources", new String[0]);
        PATH_TARGET_TEST_RESOURCES = Paths.get("target/test-classes/META-INF/resources", new String[0]);
        RESOURCE_URLS = "works.lmz.jetty.resource-urls";
    }
}

