/*
 * Decompiled with CFR 0.152.
 */
package works.lmz.war;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortWatcher
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(PortWatcher.class);
    private final CountDownLatch latch;
    private final ServerSocket listener;

    public PortWatcher(CountDownLatch latch, int port) {
        this.latch = latch;
        try {
            this.listener = new ServerSocket(port, 1, InetAddress.getByAddress(new byte[]{127, 0, 0, 1}));
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot start port watcher", e);
        }
        log.debug("Port watcher is listening on port {} for shutdown", (Object)port);
    }

    @Override
    public void run() {
        try {
            try {
                this.listener.accept();
            }
            finally {
                this.listener.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.latch.getCount() > 0L) {
            log.debug("Received tcp connection, shutting down");
            this.latch.countDown();
        }
    }
}

