/*
 * Decompiled with CFR 0.152.
 */
package works.lmz.war;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.ReadableByteChannel;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryResource
extends Resource {
    private static final Logger log = LoggerFactory.getLogger(InMemoryResource.class);
    private Map<String, InMemoryResource> resources;
    private final ByteArray self;
    private final InMemoryResource parent;
    private final String fileName;
    private String[] files = null;

    public InMemoryResource() {
        this.parent = null;
        this.self = null;
        this.fileName = null;
    }

    public InMemoryResource(InMemoryResource parent, String path) {
        this.self = null;
        this.fileName = path;
        this.parent = parent;
    }

    public InMemoryResource(InMemoryResource parent, InputStream stream, String fileName) {
        this.parent = parent;
        try {
            this.self = new ByteArray();
            if (stream != null) {
                this.self.bytes = IO.readBytes((InputStream)stream);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Unable to read input stream for %s", fileName));
        }
        this.fileName = fileName;
    }

    protected void addResource(InMemoryResource child, String path) {
        if (this.resources == null) {
            this.resources = new HashMap<String, InMemoryResource>();
        }
        this.resources.put(path, child);
        String[] nFiles = new String[this.resources.size()];
        int count = 0;
        for (Map.Entry<String, InMemoryResource> key : this.resources.entrySet()) {
            if (key.getValue().isDirectory()) {
                nFiles[count++] = key.getKey() + "/";
                continue;
            }
            nFiles[count++] = key.getKey();
        }
        this.files = nFiles;
    }

    public InMemoryResource addDirectory(String path) {
        InMemoryResource child = this.findPath(path);
        if (child == null) {
            child = new InMemoryResource(this, path);
            this.addResource(child, path);
        }
        return child;
    }

    public InMemoryResource addFile(String path, InputStream stream) {
        InMemoryResource child = this.findPath(path);
        if (child == null) {
            child = new InMemoryResource(this, stream, path);
            this.addResource(child, path);
        }
        return child;
    }

    InMemoryResource getParent() {
        return this.parent;
    }

    public boolean isContainedIn(Resource r) throws MalformedURLException {
        return r instanceof InMemoryResource && ((InMemoryResource)r).getParent() == this;
    }

    public void close() {
    }

    public boolean exists() {
        return this.self == null || this.self.bytes != null;
    }

    public boolean isDirectory() {
        return this.self == null;
    }

    public long lastModified() {
        return 0L;
    }

    public long length() {
        return this.self == null || this.self.bytes == null ? 0L : (long)this.self.bytes.length;
    }

    public URL getURL() {
        return null;
    }

    public File getFile() throws IOException {
        return null;
    }

    public String getName() {
        return this.fileName;
    }

    public InputStream getInputStream() throws IOException {
        if (this.self == null || this.self.bytes == null) {
            return null;
        }
        return new ByteArrayInputStream(this.self.bytes);
    }

    public ReadableByteChannel getReadableByteChannel() throws IOException {
        return null;
    }

    public boolean delete() throws SecurityException {
        return false;
    }

    public boolean renameTo(Resource dest) throws SecurityException {
        return false;
    }

    public String[] list() {
        return this.files;
    }

    public InMemoryResource findPath(String path) {
        if (this.resources != null) {
            return this.resources.get(path);
        }
        return null;
    }

    public Resource addPath(String path) throws IOException {
        String[] fullPath;
        if ("/".equals(path)) {
            return this;
        }
        InMemoryResource resource = this;
        for (String partPath : fullPath = path.split("/")) {
            if (partPath.length() == 0 || (resource = resource.findPath(partPath)) != null) continue;
            return new InMemoryResource(this, null, path);
        }
        return resource;
    }

    public String toString() {
        return this.fileName;
    }

    class ByteArray {
        byte[] bytes;

        ByteArray() {
        }
    }
}

