/*
 * Decompiled with CFR 0.152.
 */
package works.lmz.jetty;

import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.UserIdentity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import works.lmz.jetty.RemoteUserAuthenticationUser;
import works.lmz.jetty.RemoteUserIdentity;
import works.lmz.jetty.RoleSource;

public class RemoteUserUtils {
    private static final Logger log = LoggerFactory.getLogger(RemoteUserUtils.class);
    private static final String USER_HEADER = "X-Forwarded-User";
    private static final String REMOTEUSER_NAME = "remoteuser.name";
    private static final String REMOTEUSER_SETTABLE = "remoteuser.settable";
    private static final String REMOTEUSER_ROLES = "remoteuser.localroles";
    public static final String ROLE_CHECK_OVERRIDE_CLASS = "remoteuser.rolesource";
    private static RoleSource roleSource = null;
    private static boolean allowFakeUser = false;

    public static void initialize() {
        String clazzName = System.getProperty(ROLE_CHECK_OVERRIDE_CLASS);
        allowFakeUser = System.getProperty(REMOTEUSER_SETTABLE, "false").equalsIgnoreCase("true");
        if (clazzName != null) {
            try {
                Class<?> clazz = Class.forName(clazzName);
                Object ru = clazz.newInstance();
                if (ru instanceof RoleSource) {
                    roleSource = (RoleSource)ru;
                }
            }
            catch (Exception ex) {
                log.error("Unable to find role class " + clazzName, (Throwable)ex);
            }
        }
    }

    public static Authentication ensureRemoteUserSetIfIncluded(Request request) {
        String remoteUser = allowFakeUser ? System.getProperty(REMOTEUSER_NAME) : request.getHeader(USER_HEADER);
        if (remoteUser != null && remoteUser.trim().length() == 0) {
            remoteUser = null;
        }
        RemoteUserAuthenticationUser user = null;
        if (remoteUser != null) {
            user = new RemoteUserAuthenticationUser(remoteUser, request);
            if (roleSource != null) {
                user.getIdentity().setRoles(roleSource.getRoles(remoteUser, (HttpServletRequest)request));
            }
        }
        return user;
    }

    public static boolean isRoleOverrideSet() {
        return System.getProperty(REMOTEUSER_ROLES) != null;
    }

    public static boolean inRole(String role) {
        String rSplit = System.getProperty(REMOTEUSER_ROLES);
        if (rSplit != null) {
            String[] roles = rSplit.split(",");
            return Arrays.asList(roles).contains(role);
        }
        return false;
    }

    public static boolean isUserInRole(RemoteUserIdentity remoteUserIdentity, String role, UserIdentity.Scope scope, Request request) {
        if (RemoteUserUtils.isRoleOverrideSet()) {
            log.trace("isUserInRole: using overridden roles");
            return RemoteUserUtils.inRole(role);
        }
        if (remoteUserIdentity != null && remoteUserIdentity.getUserPrincipal().getName() != null && roleSource != null) {
            log.trace("isUserInRole: asking for roles from roleSource");
            if (remoteUserIdentity.getRoles() == null) {
                remoteUserIdentity.setRoles(roleSource.getRoles(remoteUserIdentity.getUserPrincipal().getName(), (HttpServletRequest)request));
            }
            return remoteUserIdentity.getRoles() != null && remoteUserIdentity.getRoles().contains(role);
        }
        log.trace("isUserInRole: unknown user or user principal not understood");
        return false;
    }
}

