/*
 * Decompiled with CFR 0.152.
 */
package works.lmz.jetty;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import works.lmz.jetty.RemoteUserUtils;

public class RemoteUserSecurityHandler
extends ConstraintSecurityHandler {
    private static final Logger log = LoggerFactory.getLogger(RemoteUserSecurityHandler.class);

    public RemoteUserSecurityHandler() {
        RemoteUserUtils.initialize();
        this.setAuthenticator(new Authenticator(){

            public void setConfiguration(Authenticator.AuthConfiguration configuration) {
            }

            public String getAuthMethod() {
                return "form";
            }

            public void prepareRequest(ServletRequest servletRequest) {
            }

            public Authentication validateRequest(ServletRequest request, ServletResponse response, boolean mandatory) throws ServerAuthException {
                return ((Request)request).getAuthentication();
            }

            public boolean secureResponse(ServletRequest request, ServletResponse response, boolean mandatory, Authentication.User validatedUser) throws ServerAuthException {
                return false;
            }
        });
    }

    public void handle(String pathInContext, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        baseRequest.setAuthentication(RemoteUserUtils.ensureRemoteUserSetIfIncluded(baseRequest));
        super.handle(pathInContext, baseRequest, request, response);
    }
}

