/*
 * Decompiled with CFR 0.152.
 */
package works.lmz.common.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import works.lmz.common.jackson.JacksonException;
import works.lmz.common.jackson.JacksonHelperApi;
import works.lmz.common.stereotypes.SingletonBean;

@SingletonBean
public class JacksonHelper
implements JacksonHelperApi {
    private static ObjectMapper mapper = new ObjectMapper(new JsonFactory());

    public static String serialize(Object dataToSerialize) throws JacksonException {
        try {
            return mapper.writeValueAsString(dataToSerialize);
        }
        catch (Exception e) {
            throw new JacksonException((Throwable)e);
        }
    }

    public static <T> T deserialize(String text, Class<T> type) throws JacksonException {
        try {
            return (T)mapper.reader(type).readValue(text);
        }
        catch (Exception e) {
            throw new JacksonException((Throwable)e);
        }
    }

    public String jsonSerialize(Object dataToSerialize) throws JacksonException {
        return JacksonHelper.serialize(dataToSerialize);
    }

    public <T> T jsonDeserialize(String text, Class<T> type) throws JacksonException {
        return JacksonHelper.deserialize(text, type);
    }

    static {
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.disable(new MapperFeature[]{MapperFeature.AUTO_DETECT_IS_GETTERS});
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
    }
}

