package work.labradors.cos;

import com.tencentcloudapi.ses.v20201002.models.Attachment;
import com.tencentcloudapi.ses.v20201002.models.SendEmailResponse;
import com.tencentcloudapi.ses.v20201002.models.Template;

import java.util.List;

/**
 * @author 姜陶
 * @date 2022/1/21 14:29
 * @describe 邮件发送公共接口
 **/
public interface ISesService {

    /**
     * 根据模板发送邮件
     * @param subject 主题
     * @param to 接收者数组
     * @param template 模板对象
     * @return
     */
    public SendEmailResponse sendMail(String subject, List<String> to, Template template);

    /**
     * 根据模板发送邮件及附件
     * @param subject 主题
     * @param to 接收者数组
     * @param template 模板对象
     * @param attachments 附件数组
     * @return
     */
    public SendEmailResponse sendMailAttach(String subject, List<String> to, Template template, List<Attachment> attachments);
}
