package work.labradors.cos.ses;

import com.tencentcloudapi.common.Credential;
import com.tencentcloudapi.ses.v20201002.SesClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @author 姜陶
 * @date 2022/1/18 13:18
 * @describe Cos自动配置
 **/
@Configuration
@EnableConfigurationProperties(SesProperties.class)
@ConditionalOnClass(SesService.class)
@ConditionalOnProperty(prefix = "ses", value = "enabled", matchIfMissing = true)
public class SesAutoConfiguration {

    @Autowired
    SesProperties properties;

    SesClient client(){
        Credential credential = new Credential(properties.getSecretId(),properties.getSecretKey());
        return new SesClient(credential,properties.getRegion());
    }

    @Bean
    @ConditionalOnMissingBean(SesService.class)
    public SesService cosService(){
        return new SesService(client(),properties);
    }
}
