/*
 * Decompiled with CFR 0.152.
 */
package work.curioustools.dog_network;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.os.Build;
import androidx.annotation.RequiresPermission;
import androidx.annotation.WorkerThread;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Interceptor;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import work.curioustools.dog_network.BaseResponseType;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lwork/curioustools/dog_network/InternetCheckInterceptor;", "Lokhttp3/Interceptor;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "Companion", "dog_network_release"})
public final class InternetCheckInterceptor
implements Interceptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Context context;

    public InternetCheckInterceptor(@Nullable Context context) {
        this.context = context;
    }

    public /* synthetic */ InternetCheckInterceptor(Context context, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            context = null;
        }
        this(context);
    }

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        if (this.context == null) {
            Response response = chain.proceed(chain.request());
            Intrinsics.checkNotNullExpressionValue((Object)response, (String)"chain.proceed(chain.request())");
            return response;
        }
        if (!Companion.isConnectedToInternetProvider(this.context)) {
            throw new Exception(BaseResponseType.NO_INTERNET_CONNECTION.getMsg());
        }
        if (!Companion.isReceivingInternetPackets()) {
            throw new IOException(BaseResponseType.NO_INTERNET_PACKETS_RECEIVED.getMsg());
        }
        Response response = chain.proceed(chain.request());
        Intrinsics.checkNotNullExpressionValue((Object)response, (String)"chain.proceed(chain.request())");
        return response;
    }

    public InternetCheckInterceptor() {
        this(null, 1, null);
    }

    @JvmStatic
    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public static final boolean isConnectedToInternetProvider(@NotNull Context ctx) {
        return Companion.isConnectedToInternetProvider(ctx);
    }

    @JvmStatic
    @WorkerThread
    public static final boolean isReceivingInternetPackets() {
        return Companion.isReceivingInternetPackets();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\b\u0010\u0007\u001a\u00020\u0004H\u0007\u00a8\u0006\b"}, d2={"Lwork/curioustools/dog_network/InternetCheckInterceptor$Companion;", "", "()V", "isConnectedToInternetProvider", "", "ctx", "Landroid/content/Context;", "isReceivingInternetPackets", "dog_network_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
        public final boolean isConnectedToInternetProvider(@NotNull Context ctx) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Object object = ctx.getApplicationContext().getSystemService("connectivity");
            ConnectivityManager cm = object instanceof ConnectivityManager ? (ConnectivityManager)object : null;
            object = cm;
            if (object == null) {
                return false;
            }
            if (Build.VERSION.SDK_INT >= 23) {
                Network network = cm.getActiveNetwork();
                if (network == null) {
                    return false;
                }
                Network network2 = network;
                Network currentNetwork = network2;
                NetworkCapabilities networkCapabilities = cm.getNetworkCapabilities(currentNetwork);
                if (networkCapabilities == null) {
                    return false;
                }
                Network capabilities = network = networkCapabilities;
                bl = capabilities.hasTransport(0) ? true : (capabilities.hasTransport(1) ? true : capabilities.hasTransport(3));
            } else {
                NetworkInfo networkInfo = cm.getActiveNetworkInfo();
                if (networkInfo == null) {
                    return false;
                }
                NetworkInfo networkInfo2 = networkInfo;
                NetworkInfo currentNetworkINFO = networkInfo2;
                bl = currentNetworkINFO.isConnectedOrConnecting() || currentNetworkINFO.getType() == 1 || currentNetworkINFO.getType() == 0;
            }
            return bl;
        }

        @JvmStatic
        @WorkerThread
        public final boolean isReceivingInternetPackets() {
            Object object;
            int dnsPort = 53;
            String googleIp = "8.8.8.8";
            int timeOut = 1500;
            boolean bl = false;
            try {
                object = Result.Companion;
                boolean bl2 = false;
                Socket socket = new Socket();
                InetSocketAddress inetAddress = new InetSocketAddress(googleIp, dnsPort);
                socket.connect(inetAddress, timeOut);
                socket.close();
                Boolean bl3 = true;
                boolean bl4 = false;
                object = Result.constructor-impl((Object)bl3);
            }
            catch (Throwable throwable) {
                Result.Companion companion = Result.Companion;
                boolean bl5 = false;
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            Object object2 = object;
            object = false;
            boolean bl6 = false;
            return (Boolean)(Result.isFailure-impl((Object)object2) ? object : object2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

